/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeRole.findAll", query="select o from CubeRole o"), @NamedQuery(name="CubeRole.findByName", query="select o from CubeRole o where o.roleName = :roleName"), @NamedQuery(name="CubeRole.findByNameAndProcessId", query="select o from CubeRole o where o.roleName = :roleName and o.cubeProcess.processId = :processId")})
@Table(name="BPM_CUBE_ROLE")
public class CubeRole
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="ROLEID", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long roleId;
    @Column(name="ROLENAME", nullable=false, length=200)
    private String roleName;
    @Column(name="LABEL", length=500)
    private String label;
    @Column(name="APPROLENAME", length=400)
    private String applicationRoleName;
    @Column(name="ISPROCESSOWNER", length=1)
    private String isProcessOwner;
    @Column(name="SYSTEMSTRING01", length=400)
    private String systemString01;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="PROCESSID")
    private CubeProcess cubeProcess;
    @OneToMany(mappedBy="cubeRole")
    private List<CubeWorkload> cubeWorkloadList;
    @OneToMany(mappedBy="cubeRole")
    private List<CubeTaskPerformance> cubeTaskPerformanceList;

    public CubeRole() {
    }

    public CubeRole(CubeProcess cubeProcess, String label, Long roleid, String rolename) {
        this.cubeProcess = cubeProcess;
        this.label = label;
        this.roleId = roleid;
        this.roleName = rolename;
    }

    public CubeProcess getCubeProcess() {
        return this.cubeProcess;
    }

    public void setCubeProcess(CubeProcess cubeProcess) {
        this.cubeProcess = cubeProcess;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Long roleid) {
        this.roleId = roleid;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String rolename) {
        this.roleName = rolename;
    }

    public String getApplicationRoleName() {
        return this.applicationRoleName;
    }

    public void setApplicationRoleName(String applicationRoleName) {
        this.applicationRoleName = applicationRoleName;
    }

    public String getIsProcessOwner() {
        return this.isProcessOwner;
    }

    public void setProcessOwner(String isProcessOwner) {
        this.isProcessOwner = isProcessOwner;
    }

    public String getSystemString01() {
        return this.systemString01;
    }

    public void setSystemString01(String systemString01) {
        this.systemString01 = systemString01;
    }

    public List<CubeWorkload> getCubeWorkloadList() {
        return this.cubeWorkloadList;
    }

    public void setCubeWorkloadList(List<CubeWorkload> cubeWorkloadList) {
        this.cubeWorkloadList = cubeWorkloadList;
    }

    public CubeWorkload addCubeWorkload(CubeWorkload cubeWorkload) {
        this.getCubeWorkloadList().add(cubeWorkload);
        cubeWorkload.setCubeRole(this);
        return cubeWorkload;
    }

    public CubeWorkload removeCubeWorkload(CubeWorkload cubeWorkload) {
        this.getCubeWorkloadList().remove(cubeWorkload);
        cubeWorkload.setCubeRole(null);
        return cubeWorkload;
    }

    public List<CubeTaskPerformance> getCubeTaskPerformanceList() {
        return this.cubeTaskPerformanceList;
    }

    public void setCubeTaskPerformanceList(List<CubeTaskPerformance> cubeTaskPerformanceList) {
        this.cubeTaskPerformanceList = cubeTaskPerformanceList;
    }

    public CubeTaskPerformance addCubeTaskPerformance(CubeTaskPerformance cubeTaskPerformance) {
        this.getCubeTaskPerformanceList().add(cubeTaskPerformance);
        cubeTaskPerformance.setCubeRole(this);
        return cubeTaskPerformance;
    }

    public CubeTaskPerformance removeCubeTaskPerformance(CubeTaskPerformance cubeTaskPerformance) {
        this.getCubeTaskPerformanceList().remove(cubeTaskPerformance);
        cubeTaskPerformance.setCubeRole(null);
        return cubeTaskPerformance;
    }
}

