/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubePartnerService;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeProcessPartner.findAll", query="select o from CubeProcessPartner o")})
@Table(name="BPM_CUBE_PROCESS_PARTNER")
public class CubeProcessPartner
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="PARTNERID", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long partnerId;
    @Id
    @Column(name="PROCESSID", nullable=false, insertable=false, updatable=false)
    private Long processId;
    @Column(name="LINKTYPE", length=400)
    private String linkType;
    @Column(name="MYROLE", length=200)
    private String myRole;
    @Column(name="PARTNERNAME", length=256)
    private String partnerName;
    @Column(name="PARTNERROLE", length=200)
    private String partnerRole;
    @Column(name="PARTNERWSDL", length=500)
    private String partnerWsdl;
    @Column(name="SCOPEID")
    private Long scopeId;
    @ManyToOne
    @JoinColumn(name="PROCESSID")
    private CubeProcess cubeProcess;
    @OneToMany(mappedBy="cubeProcessPartner", targetEntity=CubePartnerService.class, cascade={CascadeType.REMOVE})
    private List<CubePartnerService> cubePartnerServiceList;

    public CubeProcessPartner() {
    }

    public CubeProcessPartner(CubeProcess cubeProcess, String linktype, String myrole, String partnerrole, String partnername, String partnerwsdl, Long scopeid) {
        this.linkType = linktype;
        this.myRole = myrole;
        this.partnerName = partnername;
        this.partnerRole = partnerrole;
        this.partnerWsdl = partnerwsdl;
        this.cubeProcess = cubeProcess;
        this.scopeId = scopeid;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linktype) {
        this.linkType = linktype;
    }

    public String getMyRole() {
        return this.myRole;
    }

    public void setMyRole(String myrole) {
        this.myRole = myrole;
    }

    public Long getPartnerId() {
        return this.partnerId;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public void setPartnerName(String partnername) {
        this.partnerName = partnername;
    }

    public String getPartnerRole() {
        return this.partnerRole;
    }

    public void setPartnerRole(String partnerrole) {
        this.partnerRole = partnerrole;
    }

    public String getPartnerWsdl() {
        return this.partnerWsdl;
    }

    public void setPartnerWsdl(String partnerwsdl) {
        this.partnerWsdl = partnerwsdl;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public Long getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(Long scopeid) {
        this.scopeId = scopeid;
    }

    public CubeProcess getCubeProcess() {
        return this.cubeProcess;
    }

    public void setCubeProcess(CubeProcess cubeProcess) {
        this.cubeProcess = cubeProcess;
        if (cubeProcess != null) {
            this.processId = cubeProcess.getProcessId();
        }
    }

    public List<CubePartnerService> getCubePartnerServiceList() {
        return this.cubePartnerServiceList;
    }

    public void setCubePartnerServiceList(List<CubePartnerService> cubePartnerServiceList) {
        this.cubePartnerServiceList = cubePartnerServiceList;
    }

    public CubePartnerService addCubePartnerService(CubePartnerService cubePartnerService) {
        this.getCubePartnerServiceList().add(cubePartnerService);
        cubePartnerService.setCubeProcessPartner(this);
        return cubePartnerService;
    }

    public CubePartnerService removeCubePartnerService(CubePartnerService cubePartnerService) {
        this.getCubePartnerServiceList().remove(cubePartnerService);
        cubePartnerService.setCubeProcessPartner(null);
        return cubePartnerService;
    }
}

