/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;
import oracle.bpm.analytics.cube.persistence.model.CubeGlobalCreateTask;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;
import oracle.bpm.analytics.cube.persistence.model.CubeOrganizationalUnit;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPartner;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeProcess.findAll", query="select o from CubeProcess o"), @NamedQuery(name="CubeProcess.findCubeProcess", query="select o   from CubeProcess o   where o.domainName = :domainName and        o.compositeName = :compositeName and        o.compositeRevision = :revision and        o.compositeLabel = :label and        o.processName = :processName and        o.processType = :processType"), @NamedQuery(name="CubeProcess.findCubeProcessesInComposite", query="select o   from CubeProcess o  where o.domainName = :domainName and        o.compositeName = :compositeName and        o.compositeRevision = :revision and        o.compositeLabel = :label and        o.processType = 'BPMN'"), @NamedQuery(name="CubeProcess.findCubeProcessesFromCompositeDN", query="select o   from CubeProcess o  where o.compositeDN = :compositeDN and        o.processType = 'BPMN'")})
@Table(name="BPM_CUBE_PROCESS")
public class CubeProcess
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="PROCESSID", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long processId;
    @Column(name="DOMAINNAME", nullable=false, length=100)
    private String domainName;
    @Column(name="COMPOSITEDN", nullable=false, length=500)
    private String compositeDN;
    @Column(name="COMPOSITENAME", nullable=false, length=100)
    private String compositeName;
    @Column(name="REVISION", nullable=false, length=50)
    private String compositeRevision;
    @Column(name="SCALABEL", nullable=false, length=100)
    private String compositeLabel;
    @Column(name="PROCESSNAME", nullable=false, length=100)
    private String processName;
    @Column(name="PROCESSTYPE", length=20)
    private String processType;
    @Column(name="TARGETNAMESPACE", length=400)
    private String targetNamespace;
    @Column(name="CREATIONDATE")
    private Timestamp creationDate;
    @Column(name="UNDEPLOYDATE")
    private Timestamp undeployDate;
    @Column(name="LABEL", nullable=false, length=500)
    private String label;
    @Column(name="STATUS")
    private Long status;
    @Column(name="ORGANIZATIONALUNITID", length=64)
    private String organizationalUnitId;
    @Column(name="HASGLOBALCREATIONTASKS", length=1)
    private String hasGlobalCreationTasks;
    @OneToMany(mappedBy="cubeProcess", targetEntity=CubeProcessPartner.class, cascade={CascadeType.REMOVE})
    private List<CubeProcessPartner> cubeProcessPartnerList = new ArrayList<CubeProcessPartner>();
    @OneToMany(mappedBy="cubeProcess", targetEntity=CubeGlobalCreateTask.class, cascade={CascadeType.REMOVE})
    private List<CubeGlobalCreateTask> cubeGlobalCreateTaskList = new ArrayList<CubeGlobalCreateTask>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="BPM_CUBE_ORGUNIT_ASSOC", joinColumns={@JoinColumn(name="PROCESSID")}, inverseJoinColumns={@JoinColumn(name="ORGUNITID")})
    private List<CubeOrganizationalUnit> cubeOrganizationalUnitList = new ArrayList<CubeOrganizationalUnit>();
    @OneToMany(mappedBy="cubeProcess", fetch=FetchType.EAGER, targetEntity=CubeNametab.class, cascade={CascadeType.REMOVE})
    private List<CubeNametab> cubeNametabList = new ArrayList<CubeNametab>();
    @OneToMany(mappedBy="cubeProcess", targetEntity=CubeActivity.class, cascade={CascadeType.REMOVE})
    private List<CubeActivity> cubeActivityList = new ArrayList<CubeActivity>();
    @OneToMany(mappedBy="cubeProcess", targetEntity=CubeRole.class, fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    private List<CubeRole> cubeRoleList = new ArrayList<CubeRole>();
    @OneToMany(mappedBy="cubeProcess", cascade={CascadeType.REMOVE})
    private List<CubeProcessPerformance> cubeProcessPerformanceList = new ArrayList<CubeProcessPerformance>();

    public CubeProcess() {
    }

    public CubeProcess(String compositeDN, String domainName, String compositename, String revision, String scalabel, String processname, String processtype, String label, Timestamp creationdate, String hasglobalcreationtasks, Long status, String targetnamespace, String organizationalunitid) {
        this.compositeDN = compositeDN;
        this.compositeName = compositename;
        this.creationDate = creationdate;
        this.domainName = domainName;
        this.hasGlobalCreationTasks = hasglobalcreationtasks;
        this.label = label;
        this.processName = processname;
        this.processType = processtype;
        this.compositeRevision = revision;
        this.compositeLabel = scalabel;
        this.status = status;
        this.targetNamespace = targetnamespace;
        this.organizationalUnitId = organizationalunitid;
    }

    public String getCompositeDN() {
        return this.compositeDN;
    }

    public void setCompositeDN(String compositeDN) {
        this.compositeDN = compositeDN;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public void setCompositeName(String compositename) {
        this.compositeName = compositename;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationdate) {
        this.creationDate = creationdate;
    }

    public Timestamp getUndeployDate() {
        return this.undeployDate;
    }

    public void setUndeployDate(Timestamp undeploydate) {
        this.undeployDate = undeploydate;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainname) {
        this.domainName = domainname;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processid) {
        this.processId = processid;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processname) {
        this.processName = processname;
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processtype) {
        this.processType = processtype;
    }

    public String getRevision() {
        return this.getCompositeRevision();
    }

    public void setRevision(String revision) {
        this.setCompositeRevision(revision);
    }

    public String getCompositeRevision() {
        return this.compositeRevision;
    }

    public void setCompositeRevision(String revision) {
        this.compositeRevision = revision;
    }

    public String getScaLabel() {
        return this.getCompositeLabel();
    }

    public void setScaLabel(String value) {
        this.setCompositeLabel(value);
    }

    public String getCompositeLabel() {
        return this.compositeLabel;
    }

    public void setCompositeLabel(String compositelabel) {
        this.compositeLabel = compositelabel;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetnamespace) {
        this.targetNamespace = targetnamespace;
    }

    public String getOrganizationalUnitId() {
        return this.organizationalUnitId;
    }

    public void setOrganizationalUnitId(String organizationalunitid) {
        this.organizationalUnitId = organizationalunitid;
    }

    public String getHasGlobalCreationTasks() {
        return this.hasGlobalCreationTasks;
    }

    public void setHasGlobalCreationTasks(String hasglobalcreationtasks) {
        this.hasGlobalCreationTasks = hasglobalcreationtasks;
    }

    public List<CubeProcessPartner> getCubeProcessPartnerList() {
        return this.cubeProcessPartnerList;
    }

    public void setCubeProcessPartnerList(List<CubeProcessPartner> cubeProcessPartnerList) {
        this.cubeProcessPartnerList = cubeProcessPartnerList;
    }

    public CubeProcessPartner addCubeProcessPartner(CubeProcessPartner cubeProcessPartner) {
        this.getCubeProcessPartnerList().add(cubeProcessPartner);
        cubeProcessPartner.setCubeProcess(this);
        return cubeProcessPartner;
    }

    public CubeProcessPartner removeCubeProcessPartner(CubeProcessPartner cubeProcessPartner) {
        this.getCubeProcessPartnerList().remove(cubeProcessPartner);
        cubeProcessPartner.setCubeProcess(null);
        return cubeProcessPartner;
    }

    public List<CubeGlobalCreateTask> getCubeGlobalCreateTaskList() {
        return this.cubeGlobalCreateTaskList;
    }

    public void setCubeGlobalCreateTaskList(List<CubeGlobalCreateTask> cubeGlobalCreateTaskList) {
        this.cubeGlobalCreateTaskList = cubeGlobalCreateTaskList;
    }

    public CubeGlobalCreateTask addCubeGlobalCreateTask(CubeGlobalCreateTask cubeGlobalCreateTask) {
        this.getCubeGlobalCreateTaskList().add(cubeGlobalCreateTask);
        cubeGlobalCreateTask.setCubeProcess(this);
        return cubeGlobalCreateTask;
    }

    public CubeGlobalCreateTask removeCubeGlobalCreateTask(CubeGlobalCreateTask cubeGlobalCreateTask) {
        this.getCubeGlobalCreateTaskList().remove(cubeGlobalCreateTask);
        cubeGlobalCreateTask.setCubeProcess(null);
        return cubeGlobalCreateTask;
    }

    public List<CubeOrganizationalUnit> getCubeOrganizationalUnitList() {
        return this.cubeOrganizationalUnitList;
    }

    public void setCubeOrganizationalUnitList(List<CubeOrganizationalUnit> cubeOrganizationalUnitList) {
        this.cubeOrganizationalUnitList = cubeOrganizationalUnitList;
    }

    public CubeOrganizationalUnit addCubeOrganizationalUnit(CubeOrganizationalUnit cubeOrganizationalUnit) {
        this.getCubeOrganizationalUnitList().add(cubeOrganizationalUnit);
        return cubeOrganizationalUnit;
    }

    public CubeOrganizationalUnit removeCubeOrganizationalUnit(CubeOrganizationalUnit cubeOrganizationalUnit) {
        this.getCubeOrganizationalUnitList().remove(cubeOrganizationalUnit);
        return cubeOrganizationalUnit;
    }

    public List<CubeActivity> getCubeActivityList() {
        return this.cubeActivityList;
    }

    public void setCubeActivityList(List<CubeActivity> cubeActivityList) {
        this.cubeActivityList = cubeActivityList;
    }

    public CubeActivity addCubeActivity(CubeActivity cubeActivity) {
        this.getCubeActivityList().add(cubeActivity);
        cubeActivity.setCubeProcess(this);
        return cubeActivity;
    }

    public CubeActivity removeCubeActivity(CubeActivity cubeActivity) {
        this.getCubeActivityList().remove(cubeActivity);
        cubeActivity.setCubeProcess(null);
        return cubeActivity;
    }

    public List<CubeRole> getCubeRoleList() {
        return this.cubeRoleList;
    }

    public void setCubeRoleList(List<CubeRole> cubeRoleList) {
        this.cubeRoleList = cubeRoleList;
    }

    public CubeRole addCubeRole(CubeRole cubeRole) {
        this.getCubeRoleList().add(cubeRole);
        cubeRole.setCubeProcess(this);
        return cubeRole;
    }

    public CubeRole removeCubeRole(CubeRole cubeRole) {
        this.getCubeRoleList().remove(cubeRole);
        cubeRole.setCubeProcess(this);
        return cubeRole;
    }

    public CubeNametab getCubeNametab() {
        if (this.cubeNametabList.size() > 0) {
            return this.cubeNametabList.get(0);
        }
        return null;
    }

    public void setCubeNametab(CubeNametab cubeNametab) {
        if (this.cubeNametabList.size() > 0) {
            this.cubeNametabList.set(0, cubeNametab);
        } else {
            this.cubeNametabList.add(cubeNametab);
        }
    }

    public List<CubeProcessPerformance> getCubeProcessPerformanceList() {
        return this.cubeProcessPerformanceList;
    }

    public void setCubeProcessPerformanceList(List<CubeProcessPerformance> cubeProcessPerformanceList) {
        this.cubeProcessPerformanceList = cubeProcessPerformanceList;
    }

    public CubeProcessPerformance addCubeProcessPerformance(CubeProcessPerformance cubeProcessPerformance) {
        this.getCubeProcessPerformanceList().add(cubeProcessPerformance);
        cubeProcessPerformance.setCubeProcess(this);
        return cubeProcessPerformance;
    }

    public CubeProcessPerformance removeCubeProcessPerformance(CubeProcessPerformance cubeProcessPerformance) {
        this.getCubeProcessPerformanceList().remove(cubeProcessPerformance);
        cubeProcessPerformance.setCubeProcess(null);
        return cubeProcessPerformance;
    }

    public String toString() {
        return "CubeProcess(domain:" + this.getDomainName() + ", composite:" + this.getCompositeName() + ", revision:" + this.getCompositeRevision() + ", name:" + this.getProcessName() + ", hasNametab:" + (this.getCubeNametab() != null) + ")";
    }
}

