/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeOrganizationalUnit.findAll", query="select o from CubeOrganizationalUnit o")})
@Table(name="BPM_CUBE_ORGUNIT")
public class CubeOrganizationalUnit
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="ORGUNITID", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long orgUnitId;
    @Column(name="ORGUNITNAME", nullable=false, length=200)
    private String orgUnitName;
    @Column(name="PARENTID")
    private Long parentId;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="BPM_CUBE_ORGUNIT_ASSOC", joinColumns={@JoinColumn(name="ORGUNITID")}, inverseJoinColumns={@JoinColumn(name="PROCESSID")})
    private List<CubeProcess> cubeProcessList = new ArrayList<CubeProcess>();

    public CubeOrganizationalUnit() {
    }

    public CubeOrganizationalUnit(Long orgunitid, String orgunitname, Long parentid) {
        this.orgUnitId = orgunitid;
        this.orgUnitName = orgunitname;
        this.parentId = parentid;
    }

    public Long getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(Long orgunitid) {
        this.orgUnitId = orgunitid;
    }

    public String getOrgUnitName() {
        return this.orgUnitName;
    }

    public void setOrgUnitName(String orgunitname) {
        this.orgUnitName = orgunitname;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentid) {
        this.parentId = parentid;
    }

    public List<CubeProcess> getCubeProcessList() {
        return this.cubeProcessList;
    }

    public void setCubeProcessList(List<CubeProcess> cubeProcessList) {
        this.cubeProcessList = cubeProcessList;
    }

    public CubeProcess addCubeProcess(CubeProcess cubeProcess) {
        this.getCubeProcessList().add(cubeProcess);
        return cubeProcess;
    }

    public CubeProcess removeCubeProcess(CubeProcess cubeProcess) {
        this.getCubeProcessList().remove(cubeProcess);
        return cubeProcess;
    }
}

