/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeNametabRange.findAll", query="select o from CubeNametabRange o"), @NamedQuery(name="CubeNametabRange.findRangeForIndicator", query="select o from CubeNametabRange o where o.indicatorName = :indicatorName")})
@Table(name="BPM_CUBE_NAMETAB_RANGE")
public class CubeNametabRange
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="RANGEID", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long rangeId;
    @Id
    @Column(name="NAMETABID", nullable=false, insertable=false, updatable=false)
    private Long nametabId;
    @Id
    @Column(name="EXTENSIONID", nullable=false)
    private Long extensionId;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="PROCESSID", referencedColumnName="PROCESSID"), @JoinColumn(name="NAMETABID", referencedColumnName="NAMETABID")})
    private CubeNametab cubeNametab;
    @Column(name="RANGENAME", length=200)
    private String rangeName;
    @Column(name="RANGEOPERATOR", length=100)
    private String rangeOperator;
    @Column(name="INDICATORNAME", length=200)
    private String indicatorName;
    @Column(name="NUMBERRANGESTART")
    private BigDecimal numberRangeStart;
    @Column(name="NUMBERRANGEEND")
    private BigDecimal numberRangeEnd;
    @Column(name="DATETIMERANGESTART")
    private Timestamp datetimeRangeStart;
    @Column(name="DATETIMERANGEEND")
    private Timestamp datetimeRangeEnd;

    public CubeNametabRange() {
    }

    public CubeNametabRange(CubeNametab cubeNametab, Long nametabId, String rangeName, String rangeOperator, String indicatorName, BigDecimal numberRangeStart, BigDecimal numberRangeEnd, Timestamp datetimeRangeStart, Timestamp datetimeRangeEnd) {
        this.nametabId = nametabId;
        this.extensionId = 0L;
        this.cubeNametab = cubeNametab;
        this.rangeName = rangeName;
        this.rangeOperator = rangeOperator;
        this.indicatorName = indicatorName;
        this.numberRangeStart = numberRangeStart;
        this.numberRangeEnd = numberRangeEnd;
        this.datetimeRangeStart = datetimeRangeStart;
        this.datetimeRangeEnd = datetimeRangeEnd;
    }

    public Long getRangeId() {
        return this.rangeId;
    }

    public void setRangeId(Long rangeId) {
        this.rangeId = rangeId;
    }

    public Long getNametabId() {
        return this.nametabId;
    }

    public void setNametabId(Long nametabId) {
        this.nametabId = nametabId;
    }

    public Long getExtensionId() {
        return this.extensionId;
    }

    public void setExtensionId(Long extensionId) {
        this.extensionId = extensionId;
    }

    public CubeNametab getCubeNametab() {
        return this.cubeNametab;
    }

    public void setCubeNametab(CubeNametab cubeNametab) {
        this.cubeNametab = cubeNametab;
        if (cubeNametab != null) {
            this.nametabId = cubeNametab.getNametabid();
        }
    }

    public String getRangeName() {
        return this.rangeName;
    }

    public void setRangeName(String rangeName) {
        this.rangeName = rangeName;
    }

    public String getRangeOperator() {
        return this.rangeOperator;
    }

    public void setRangeOperator(String rangeOperator) {
        this.rangeOperator = rangeOperator;
    }

    public String getIndicatorName() {
        return this.indicatorName;
    }

    public void setIndicatorName(String indicatorName) {
        this.indicatorName = indicatorName;
    }

    public BigDecimal getNumberRangeStart() {
        return this.numberRangeStart;
    }

    public void setNumberRangeStart(BigDecimal numberRangeStart) {
        this.numberRangeStart = numberRangeStart;
    }

    public BigDecimal getNumberRangeEnd() {
        return this.numberRangeEnd;
    }

    public void setNumberRangeEnd(BigDecimal numberRangeEnd) {
        this.numberRangeEnd = numberRangeEnd;
    }

    public Timestamp getDatetimeRangeStart() {
        return this.datetimeRangeStart;
    }

    public void setDatetimeRangeStart(Timestamp datetimeRangeStart) {
        this.datetimeRangeStart = datetimeRangeStart;
    }

    public Timestamp getDatetimeRangeEnd() {
        return this.datetimeRangeEnd;
    }

    public void setDatetimeRangeEnd(Timestamp datetimeRangeEnd) {
        this.datetimeRangeEnd = datetimeRangeEnd;
    }
}

