/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeActivitySequenceFlow.findAll", query="select o from CubeActivitySequenceFlow o")})
@Table(name="BPM_CUBE_ACTIVITY_SEQFLOW")
public class CubeActivitySequenceFlow
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="SEQUENCEFLOWID")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long sequenceFlowId;
    @Id
    @Column(name="PROCESSID", nullable=false)
    private Long processId;
    @Column(name="CONDITION", length=2000)
    private String condition;
    @Column(name="ISCONDITIONFLOW", length=1)
    private String isConditionFlow;
    @Column(name="ISEXCEPTIONFLOW", length=1)
    private String isExceptionFlow;
    @Column(name="ISNORMALFLOW", length=1)
    private String isNormalFlow;
    @Column(name="LABEL", length=500)
    private String label;
    @Column(name="SOURCEACTIVITYID", nullable=false)
    private Long sourceActivityId;
    @Column(name="TARGETACTIVITYID", nullable=false)
    private Long targetActivityId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="PROCESSID", referencedColumnName="PROCESSID", insertable=false, updatable=false, nullable=false), @JoinColumn(name="SOURCEACTIVITYID", referencedColumnName="ACTIVITYID", insertable=false, updatable=false, nullable=false)})
    private CubeActivity sourceCubeActivity;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="PROCESSID", referencedColumnName="PROCESSID", insertable=false, updatable=false, nullable=false), @JoinColumn(name="TARGETACTIVITYID", referencedColumnName="ACTIVITYID", insertable=false, updatable=false, nullable=false)})
    private CubeActivity targetCubeActivity;

    public CubeActivitySequenceFlow() {
    }

    public CubeActivitySequenceFlow(CubeActivity sourceCubeActivity, CubeActivity targetCubeActivity, String condition, String isconditionflow, String isexceptionflow, String isnormalflow, String label) {
        this.condition = condition;
        this.isConditionFlow = isconditionflow;
        this.isExceptionFlow = isexceptionflow;
        this.isNormalFlow = isnormalflow;
        this.label = label;
        this.processId = sourceCubeActivity.getProcessId();
        this.sourceCubeActivity = sourceCubeActivity;
        this.targetCubeActivity = targetCubeActivity;
        this.sourceActivityId = sourceCubeActivity.getActivityId();
        this.targetActivityId = targetCubeActivity.getActivityId();
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getIsConditionFlow() {
        return this.isConditionFlow;
    }

    public void setIsConditionFlow(String isconditionflow) {
        this.isConditionFlow = isconditionflow;
    }

    public String getIsExceptionFlow() {
        return this.isExceptionFlow;
    }

    public void setIsExceptionFlow(String isexceptionflow) {
        this.isExceptionFlow = isexceptionflow;
    }

    public String getIsNormalFlow() {
        return this.isNormalFlow;
    }

    public void setIsNormalFlow(String isnormalflow) {
        this.isNormalFlow = isnormalflow;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public Long getSourceActivityId() {
        return this.sourceActivityId;
    }

    public void setSourceActivityId(Long sourceactivityid) {
        this.sourceActivityId = sourceactivityid;
    }

    public Long getTargetActivityId() {
        return this.targetActivityId;
    }

    public void setTargetActivityId(Long targetactivityid) {
        this.targetActivityId = targetactivityid;
    }

    public Long getSequenceFlowId() {
        return this.sequenceFlowId;
    }

    public void setSequenceFlowId(Long sequenceflowid) {
        this.sequenceFlowId = sequenceflowid;
    }

    public CubeActivity getTargetCubeActivity() {
        return this.targetCubeActivity;
    }

    public CubeActivity getSourceCubeActivity() {
        return this.sourceCubeActivity;
    }

    public void setSourceCubeActivity(CubeActivity cubeActivity) {
        this.sourceCubeActivity = cubeActivity;
    }

    public void setTargetCubeActivity(CubeActivity cubeActivity) {
        this.targetCubeActivity = cubeActivity;
    }
}

