/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;

@Entity
@NamedQueries(value={@NamedQuery(name="CubeActivityProperty.findAll", query="select o from CubeActivityProperty o")})
@Table(name="BPM_CUBE_ACTIVITY_PROPERTY")
public class CubeActivityProperty
implements Serializable {
    public static final long serialVersionUID = 1L;
    @Id
    @Column(name="PROPERTYID", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CubeDefaultIdGenerator")
    private Long propertyId;
    @Id
    @Column(name="ACTIVITYID", nullable=false, insertable=false, updatable=false)
    private Long activityId;
    @Column(name="DEFAULTVALUE", length=2000)
    private String defaultValue;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @Column(name="PROPERTYNAME", length=256)
    private String propertyName;
    @Column(name="QNAME", length=400)
    private String qName;
    @Column(name="VALUETYPE", length=256)
    private String valueType;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="PROCESSID", referencedColumnName="PROCESSID"), @JoinColumn(name="ACTIVITYID", referencedColumnName="ACTIVITYID")})
    private CubeActivity cubeActivity;

    public CubeActivityProperty() {
    }

    public CubeActivityProperty(CubeActivity cubeActivity, String propertyname, String description, String defaultvalue, String qname, String valuetype) {
        this.defaultValue = defaultvalue;
        this.description = description;
        this.cubeActivity = cubeActivity;
        this.propertyName = propertyname;
        this.qName = qname;
        this.valueType = valuetype;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityid) {
        this.activityId = activityid;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultvalue) {
        this.defaultValue = defaultvalue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(Long propertyid) {
        this.propertyId = propertyid;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyname) {
        this.propertyName = propertyname;
    }

    public String getQName() {
        return this.qName;
    }

    public void setQName(String qname) {
        this.qName = qname;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valuetype) {
        this.valueType = valuetype;
    }

    public CubeActivity getCubeActivity() {
        return this.cubeActivity;
    }

    public void setCubeActivity(CubeActivity cubeActivity) {
        this.cubeActivity = cubeActivity;
        if (cubeActivity != null) {
            this.activityId = cubeActivity.getActivityId();
        }
    }
}

