/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryServiceLocal;
import oracle.bpm.analytics.cube.persistence.PersistenceService;
import oracle.bpm.analytics.cube.persistence.PersistenceServiceLocal;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;
import oracle.bpm.analytics.cube.persistence.model.CubeActivityProperty;
import oracle.bpm.analytics.cube.persistence.model.CubeActivitySequenceFlow;
import oracle.bpm.analytics.cube.persistence.model.CubeAuditInstance;
import oracle.bpm.analytics.cube.persistence.model.CubeGlobalCreateTask;
import oracle.bpm.analytics.cube.persistence.model.CubeLastSnapshot;
import oracle.bpm.analytics.cube.persistence.model.CubeLock;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;
import oracle.bpm.analytics.cube.persistence.model.CubeNametabRange;
import oracle.bpm.analytics.cube.persistence.model.CubeOrganizationalUnit;
import oracle.bpm.analytics.cube.persistence.model.CubePartnerService;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPartner;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeProcessPerformanceFlex01;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformanceFlex01;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkloadFlex01;
import org.jetbrains.annotations.NotNull;

@Stateless(name="PersistenceServiceBean", mappedName="BPMAnalytics")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class PersistenceServiceBean
implements PersistenceService,
PersistenceServiceLocal {
    private static final String CLASS_NAME = "PersistenceServiceBean";
    private static final int FLEX_DATE_TYPE = 1;
    private static final int FLEX_NUMBER_TYPE = 2;
    private static final int FLEX_STRING_TYPE = 3;
    private static final int FLEX_UNKNOWN = -1;
    private EntityManager m_em;
    private Logger m_logger = null;
    @EJB(beanName="PersistenceQueryServiceBean", beanInterface=PersistenceQueryServiceLocal.class)
    private PersistenceQueryService m_cube_query_service;

    public PersistenceServiceBean() {
        this.init();
    }

    @PostConstruct
    public void init() {
        this.m_logger = Logger.getLogger("oracle.bpm.analytics.cube.persistence");
    }

    @PersistenceContext(unitName="BPMAnalyticsPersistenceUnit")
    public void setEntityManager(EntityManager entityManager) {
        if (this.m_logger == null) {
            this.init();
        }
        this.m_em = entityManager;
    }

    public void setProcessPersistenceQueryService(PersistenceQueryService qs) {
        this.m_cube_query_service = qs;
    }

    @Override
    @NotNull
    public CubeLastSnapshot upsertLastSnapshot(@NotNull Calendar snapshotTime, @NotNull Long queryId) throws Exception {
        CubeLastSnapshot result;
        this.m_logger.entering(CLASS_NAME, "upsertLastSnapshot", "Query Id: " + queryId + ", snapshot " + snapshotTime);
        try {
            result = this.fetchLastSnapshot();
        }
        catch (NoResultException e) {
            result = null;
        }
        if (result == null) {
            result = new CubeLastSnapshot();
            result.setQueryId(queryId);
            result.setLastsnapshot(new Timestamp(snapshotTime.getTimeInMillis()));
            this.m_em.persist((Object)result);
        } else {
            result = (CubeLastSnapshot)this.m_em.merge((Object)result);
            result.setQueryId(queryId);
            result.setLastsnapshot(new Timestamp(snapshotTime.getTimeInMillis()));
        }
        this.m_logger.exiting(CLASS_NAME, "upsertLastSnapshot", queryId);
        return result;
    }

    @Override
    @NotNull
    public CubeOrganizationalUnit createOrganizationalUnit() throws Exception {
        CubeOrganizationalUnit result = new CubeOrganizationalUnit();
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeOrganizationalUnit createOrganizationalUnit(String name) throws Exception {
        CubeOrganizationalUnit result = new CubeOrganizationalUnit();
        result.setOrgUnitName(name);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeOrganizationalUnit cubeOrgUnit) throws Exception {
        CubeOrganizationalUnit mergedOrgUnit = (CubeOrganizationalUnit)this.m_em.merge((Object)cubeOrgUnit);
        this.m_em.remove((Object)mergedOrgUnit);
    }

    @Override
    @NotNull
    public CubeRole createRole(@NotNull CubeProcess cubeProcess) throws Exception {
        CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        CubeRole result = new CubeRole();
        result.setCubeProcess(process);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeRole createRole(@NotNull CubeProcess cubeProcess, @NotNull String roleName, String label) throws Exception {
        CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        CubeRole result = new CubeRole();
        result.setCubeProcess(process);
        result.setRoleName(roleName);
        result.setLabel(label);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeRole createRole(@NotNull CubeProcess cubeProcess, @NotNull String roleName, String roleLabel, String applicationRoleName, String isProcessOwner) throws Exception {
        CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        CubeRole result = new CubeRole();
        result.setCubeProcess(process);
        result.setRoleName(roleName);
        result.setLabel(roleLabel);
        result.setApplicationRoleName(applicationRoleName);
        result.setProcessOwner(isProcessOwner);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeRole cubeRole) throws Exception {
        CubeRole mergedRole = (CubeRole)this.m_em.merge((Object)cubeRole);
        this.m_em.remove((Object)mergedRole);
    }

    @Override
    @NotNull
    public CubeProcess createProcess() throws Exception {
        CubeProcess result = new CubeProcess();
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeProcess createProcess(@NotNull String compositeDN, @NotNull String compositename, Timestamp creationdate, @NotNull String domainname, String label, @NotNull String processname, String processtype, @NotNull String revision, @NotNull String compositelabel, Long status, String organizationalunitid) throws Exception {
        this.m_logger.entering(CLASS_NAME, "createProcess", compositeDN + "/" + processname);
        CubeProcess result = new CubeProcess();
        result.setCompositeDN(compositeDN);
        result.setCompositeName(compositename);
        result.setCreationDate(creationdate);
        result.setDomainName(domainname);
        result.setLabel(label);
        result.setProcessName(processname);
        result.setProcessType(processtype);
        result.setCompositeRevision(revision);
        result.setCompositeLabel(compositelabel);
        result.setStatus(status);
        result.setOrganizationalUnitId(organizationalunitid);
        this.m_em.persist((Object)result);
        this.m_logger.exiting(CLASS_NAME, "createProcess", processname);
        return result;
    }

    @Override
    public void updateProcess(@NotNull CubeProcess process) throws Exception {
        this.m_em.merge((Object)process);
    }

    @Override
    public void remove(@NotNull CubeProcess cubeProcess) throws Exception {
        CubeProcess mergedProcess = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        this.m_em.remove((Object)mergedProcess);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeAllFromComposite(@NotNull String compositeDN) throws Exception {
        String queryString = "delete from CubeProcess o where o.compositeDN =  :compositeDN";
        this.m_logger.entering(CLASS_NAME, "removeAllFromComposite", compositeDN);
        int numRemoved = this.m_em.createQuery(queryString).setParameter("compositeDN", (Object)compositeDN).executeUpdate();
        this.m_logger.exiting(CLASS_NAME, "removeAllFromComposite", "Removed " + numRemoved + " entities from " + compositeDN);
    }

    @Override
    @NotNull
    public CubeGlobalCreateTask createGlobalCreationTask(@NotNull CubeProcess cubeProcess) throws Exception {
        CubeGlobalCreateTask result = new CubeGlobalCreateTask();
        if (cubeProcess != null) {
            CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
            result.setCubeProcess(process);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeGlobalCreateTask createGlobalCreationTask(@NotNull CubeProcess cubeProcess, String activityName, String activityLabel, String role, String applicationContext) throws Exception {
        CubeGlobalCreateTask result = new CubeGlobalCreateTask();
        if (cubeProcess != null) {
            CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
            result.setCubeProcess(process);
            result.setActivityName(activityName);
            result.setActivityLabel(activityLabel);
            result.setRole(role);
            result.setApplicationContext(applicationContext);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeGlobalCreateTask createGlobalCreationTask(@NotNull CubeProcess cubeProcess, String activityName, String activityLabel, String role, String applicationContext, String systemString01, String systemString02, String systemString03) throws Exception {
        CubeGlobalCreateTask result = new CubeGlobalCreateTask();
        if (cubeProcess != null) {
            CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
            result.setCubeProcess(process);
            result.setActivityName(activityName);
            result.setActivityLabel(activityLabel);
            result.setRole(role);
            result.setApplicationContext(applicationContext);
            result.setSystemString01(systemString01);
            result.setSystemString02(systemString02);
            result.setSystemString03(systemString03);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeGlobalCreateTask cubeGlobalCreationTask) throws Exception {
        CubeGlobalCreateTask mergedGlobalCreationTask = (CubeGlobalCreateTask)this.m_em.merge((Object)cubeGlobalCreationTask);
        this.m_em.remove((Object)mergedGlobalCreationTask);
    }

    @Override
    @NotNull
    public CubeProcessPartner createProcessPartner(@NotNull CubeProcess cubeProcess) throws Exception {
        CubeProcessPartner result = new CubeProcessPartner();
        if (cubeProcess != null) {
            CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
            result.setCubeProcess(process);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeProcessPartner cubeProcessPartner) throws Exception {
        CubeProcessPartner mergedProcessPartner = (CubeProcessPartner)this.m_em.merge((Object)cubeProcessPartner);
        this.m_em.remove((Object)mergedProcessPartner);
    }

    @Override
    @NotNull
    public CubePartnerService createPartnerService(@NotNull CubeProcessPartner cubeProcessPartner) throws Exception {
        CubePartnerService result = new CubePartnerService();
        if (cubeProcessPartner != null) {
            CubeProcessPartner processPartner = (CubeProcessPartner)this.m_em.merge((Object)cubeProcessPartner);
            result.setCubeProcessPartner(processPartner);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubePartnerService cubePartnerService) throws Exception {
        CubePartnerService mergedPartnerService = (CubePartnerService)this.m_em.merge((Object)cubePartnerService);
        this.m_em.remove((Object)mergedPartnerService);
    }

    @Override
    @NotNull
    public CubeActivity createActivity(@NotNull CubeProcess cubeProcess) throws Exception {
        CubeActivity result = new CubeActivity();
        if (cubeProcess != null) {
            CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
            result.setCubeProcess(process);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeActivity createActivity(@NotNull CubeProcess cubeProcess, @NotNull String activityName, @NotNull String activityType, char[] sourceCode, String label) throws Exception {
        this.m_logger.entering(CLASS_NAME, "createActivity", cubeProcess.getProcessName() + ":" + activityName + ":" + activityType);
        CubeActivity result = new CubeActivity();
        if (cubeProcess != null) {
            CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
            result.setCubeProcess(process);
            result.setActivityName(activityName);
            result.setActivityType(activityType);
            result.setSourceCode(sourceCode);
            result.setLabel(label);
        }
        this.m_em.persist((Object)result);
        this.m_logger.exiting(CLASS_NAME, "createActivity", activityName);
        return result;
    }

    @Override
    public void remove(@NotNull CubeActivity cubeActivity) throws Exception {
        CubeActivity mergedActivity = (CubeActivity)this.m_em.merge((Object)cubeActivity);
        this.m_em.remove((Object)mergedActivity);
    }

    @Override
    @NotNull
    public CubeActivityProperty createActivityProperty(@NotNull CubeActivity cubeActivity) throws Exception {
        CubeActivityProperty result = new CubeActivityProperty();
        if (cubeActivity != null) {
            CubeActivity activity = (CubeActivity)this.m_em.merge((Object)cubeActivity);
            result.setCubeActivity(cubeActivity);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeActivityProperty cubeActivityProperty) throws Exception {
        CubeActivityProperty mergedActivityProperty = (CubeActivityProperty)this.m_em.merge((Object)cubeActivityProperty);
        this.m_em.remove((Object)mergedActivityProperty);
    }

    @Override
    @NotNull
    public CubeActivitySequenceFlow createActivitySequenceFlow(@NotNull CubeActivity sourceActivity, @NotNull CubeActivity targetActivity) throws Exception {
        CubeActivitySequenceFlow result = new CubeActivitySequenceFlow();
        if (sourceActivity == null || targetActivity == null) {
            throw new IllegalArgumentException("Source and Target Activity required.");
        }
        CubeActivity source = (CubeActivity)this.m_em.merge((Object)sourceActivity);
        CubeActivity target = (CubeActivity)this.m_em.merge((Object)targetActivity);
        result.setSourceCubeActivity(source);
        result.setTargetCubeActivity(target);
        source.addSourceCubeActivitySequenceFlow(result);
        target.addTargetCubeActivitySequenceFlow(result);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeActivitySequenceFlow createActivitySequenceFlow(@NotNull CubeActivity sourceActivity, @NotNull CubeActivity targetActivity, String label, String isNormalFlow, String isConditionFlow, String isExceptionFlow, String condition) throws Exception {
        this.m_logger.entering(CLASS_NAME, "createActivitySequenceFlow", "source activity: " + sourceActivity.getActivityName() + ", target activity: " + targetActivity.getActivityName());
        CubeActivity source = (CubeActivity)this.m_em.merge((Object)sourceActivity);
        CubeActivity target = (CubeActivity)this.m_em.merge((Object)targetActivity);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, CLASS_NAME, "createActivitySequenceFlow", "source activity id: " + source.getActivityId() + ", target activity id: " + target.getActivityId());
        }
        CubeActivitySequenceFlow result = new CubeActivitySequenceFlow(source, target, condition, isConditionFlow, isExceptionFlow, isNormalFlow, label);
        source.addSourceCubeActivitySequenceFlow(result);
        target.addTargetCubeActivitySequenceFlow(result);
        this.m_em.persist((Object)result);
        this.m_logger.entering(CLASS_NAME, "createActivitySequenceFlow");
        return result;
    }

    @Override
    public void remove(@NotNull CubeActivitySequenceFlow cubeActivitySequenceFlow) throws Exception {
        CubeActivitySequenceFlow mergedActivitySequenceFlow = (CubeActivitySequenceFlow)this.m_em.merge((Object)cubeActivitySequenceFlow);
        this.m_em.remove((Object)mergedActivitySequenceFlow);
    }

    @Override
    @NotNull
    public CubeNametab createNametab(@NotNull CubeProcess cubeProcess) throws Exception {
        CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        CubeNametab result = new CubeNametab();
        result.setCubeProcess(process);
        result.setExtensionId(0L);
        process.setCubeNametab(result);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeNametab cubeNametab) throws Exception {
        CubeNametab mergedNametab = (CubeNametab)this.m_em.merge((Object)cubeNametab);
        this.m_em.remove((Object)mergedNametab);
    }

    @Override
    @NotNull
    public CubeNametab createNametab(@NotNull CubeProcess cubeProcess, @NotNull Map<Integer, String[]> flexDateNameMap, @NotNull Map<Integer, String[]> flexNumberNameMap, @NotNull Map<Integer, String[]> flexStringNameMap) throws Exception {
        CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        CubeNametab result = new CubeNametab();
        result.setCubeProcess(process);
        result.setExtensionId(0L);
        if (flexDateNameMap != null) {
            for (Map.Entry<Integer, String[]> flexDateEntry : flexDateNameMap.entrySet()) {
                result.setFlexDateName(flexDateEntry.getKey(), flexDateEntry.getValue()[0]);
                result.setFlexDateType(flexDateEntry.getKey(), flexDateEntry.getValue()[1]);
            }
        }
        if (flexNumberNameMap != null) {
            for (Map.Entry<Integer, String[]> flexNumberEntry : flexNumberNameMap.entrySet()) {
                result.setFlexNumberName(flexNumberEntry.getKey(), flexNumberEntry.getValue()[0]);
                result.setFlexNumberType(flexNumberEntry.getKey(), flexNumberEntry.getValue()[1]);
            }
        }
        if (flexStringNameMap != null) {
            for (Map.Entry<Integer, String[]> flexStringEntry : flexStringNameMap.entrySet()) {
                result.setFlexStringName(flexStringEntry.getKey(), flexStringEntry.getValue()[0]);
                result.setFlexStringType(flexStringEntry.getKey(), flexStringEntry.getValue()[1]);
            }
        }
        process.setCubeNametab(result);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeNametabRange createNametabRange(@NotNull CubeNametab cubeNametab) throws Exception {
        CubeNametab nametab = (CubeNametab)this.m_em.merge((Object)cubeNametab);
        CubeNametabRange result = new CubeNametabRange();
        result.setCubeNametab(nametab);
        result.setExtensionId(0L);
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeNametabRange createNametabRange(@NotNull CubeNametab cubeNametab, @NotNull String rangeName, String rangeOperator, @NotNull String indicatorName, BigDecimal numberRangeStart, BigDecimal numberRangeEnd, Timestamp datetimeRangeStart, Timestamp datetimeRangeEnd) throws Exception {
        CubeNametab nametab = (CubeNametab)this.m_em.merge((Object)cubeNametab);
        CubeNametabRange result = new CubeNametabRange(nametab, nametab.getNametabid(), rangeName, rangeOperator, indicatorName, numberRangeStart, numberRangeEnd, datetimeRangeStart, datetimeRangeEnd);
        this.m_em.persist((Object)result);
        return result;
    }

    public void remove(@NotNull CubeNametabRange cubeNametabRange) throws Exception {
        CubeNametabRange mergedNametabRange = (CubeNametabRange)this.m_em.merge((Object)cubeNametabRange);
        this.m_em.remove((Object)mergedNametabRange);
    }

    @Override
    @NotNull
    public CubeWorkload createWorkload(@NotNull CubeActivity cubeActivity, CubeRole cubeRole, String participant, Timestamp snapshotTime, Long quantity, Long avgTaskTime, Long sumTaskTime, Long sqrSumTaskTime, Long medianTaskTime, Long avgProcessTime, Long sumProcessTime, Long sqrSumProcessTime, Long medianProcessTime, Map<String, Object> valueMap, Map<String, String> rangeMap) throws Exception {
        CubeWorkload result = new CubeWorkload();
        CubeActivity activity = (CubeActivity)this.m_em.merge((Object)cubeActivity);
        result.setCubeActivity(activity);
        if (cubeRole != null) {
            CubeRole role = (CubeRole)this.m_em.merge((Object)cubeRole);
            result.setCubeRole(role);
        }
        result.setActivityId(activity.getActivityId());
        result.setParticipant(participant);
        result.setSnapshotTime(snapshotTime);
        result.setQuantity(quantity);
        result.setAvgTimeTask(avgTaskTime);
        result.setSumTimeTask(sumTaskTime);
        result.setSqrSumTimeTask(sqrSumTaskTime);
        result.setMedianTimeTask(medianTaskTime);
        result.setAvgTimeProcess(avgProcessTime);
        result.setSumTimeProcess(sumProcessTime);
        result.setSqrSumTimeProcess(sqrSumProcessTime);
        result.setMedianTimeProcess(medianProcessTime);
        if (valueMap != null) {
            this.assignFlexValues(result, valueMap, rangeMap);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeWorkload createWorkload(@NotNull CubeActivity cubeActivity, CubeRole cubeRole, Timestamp snapshotTime, Long quantity, Long avgTaskTime, Long medianTaskTime, Long avgProcessTime, Long medianProcessTime) throws Exception {
        return this.createWorkload(cubeActivity, cubeRole, null, snapshotTime, quantity, avgTaskTime, null, null, medianTaskTime, avgProcessTime, null, null, medianProcessTime, null, null);
    }

    @Override
    @NotNull
    public CubeWorkload createWorkload(@NotNull CubeActivity cubeActivity, CubeRole cubeRole, String participant, Timestamp snapshotTime, Long quantity, Long avgTaskTime, Long sumTaskTime, Long sqrSumTaskTime, Long medianTaskTime, Long avgProcessTime, Long sumProcessTime, Long sqrSumProcessTime, Long medianProcessTime, Map<String, Object> flexColumnValueMap) throws Exception {
        CubeWorkload result = new CubeWorkload();
        CubeActivity activity = (CubeActivity)this.m_em.merge((Object)cubeActivity);
        result.setCubeActivity(activity);
        if (cubeRole != null) {
            CubeRole role = (CubeRole)this.m_em.merge((Object)cubeRole);
            result.setCubeRole(role);
        }
        result.setActivityId(activity.getActivityId());
        result.setParticipant(participant);
        result.setSnapshotTime(snapshotTime);
        result.setQuantity(quantity);
        result.setAvgTimeTask(avgTaskTime);
        result.setSumTimeTask(sumTaskTime);
        result.setSqrSumTimeTask(sqrSumTaskTime);
        result.setMedianTimeTask(medianTaskTime);
        result.setAvgTimeProcess(avgProcessTime);
        result.setSumTimeProcess(sumProcessTime);
        result.setSqrSumTimeProcess(sqrSumProcessTime);
        result.setMedianTimeProcess(medianProcessTime);
        if (flexColumnValueMap != null) {
            for (String flexColumnName : flexColumnValueMap.keySet()) {
                Object flexColumnValue;
                if (!flexColumnName.toUpperCase().startsWith("FLEX") || flexColumnName.toUpperCase().contains("RANGE") || (flexColumnValue = flexColumnValueMap.get(flexColumnName)) == null) continue;
                String rangeColumnName = flexColumnName.substring(0, flexColumnName.length() - 2) + "RANGE" + flexColumnName.substring(flexColumnName.length() - 2);
                String rangeValue = (String)flexColumnValueMap.get(rangeColumnName);
                this.setFlexValue(result, flexColumnName, flexColumnValue, rangeValue);
            }
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    public void remove(@NotNull CubeWorkload workload) throws Exception {
        CubeWorkload mergedWorkload = (CubeWorkload)this.m_em.merge((Object)workload);
        this.m_em.remove((Object)mergedWorkload);
    }

    public void removeWorkloadFlex01(@NotNull CubeWorkloadFlex01 workload) throws Exception {
        this.m_em.remove((Object)workload);
    }

    @Override
    @NotNull
    public CubeTaskPerformance createTaskPerformance(@NotNull CubeActivity cubeActivity, CubeRole cubeRole, String componentInstanceId, String participant, Timestamp creationDateTime, Timestamp completionDateTime, Long idleTime, Long taskTime, String discriminator, String scopeId, Long loopCount, Long instanceCount, Map<String, Object> valueMap, Map<String, String> rangeMap) throws Exception {
        CubeTaskPerformance result = new CubeTaskPerformance();
        CubeActivity activity = (CubeActivity)this.m_em.merge((Object)cubeActivity);
        result.setCubeActivity(activity);
        if (cubeRole != null) {
            CubeRole role = (CubeRole)this.m_em.merge((Object)cubeRole);
            result.setCubeRole(role);
        }
        result.setComponentInstanceId(componentInstanceId);
        result.setParticipant(participant);
        result.setCreationDateTime(creationDateTime);
        result.setCreationDate(this.stripTimeInfo(creationDateTime));
        result.setCompletionDateTime(completionDateTime);
        result.setCompletionDate(this.stripTimeInfo(completionDateTime));
        result.setIdleTime(idleTime);
        result.setTaskTime(taskTime);
        result.setDiscriminator(discriminator);
        result.setScopeId(scopeId);
        result.setLoopCount(loopCount);
        result.setInstanceCount(instanceCount);
        if (valueMap != null) {
            this.assignFlexValues(result, valueMap, rangeMap);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeTaskPerformance createTaskPerformance(@NotNull CubeActivity cubeActivity, CubeRole cubeRole, Timestamp completionDateTime, Long idleTime, Long taskTime) throws Exception {
        return this.createTaskPerformance(cubeActivity, cubeRole, null, null, null, completionDateTime, idleTime, taskTime, null, null, null, null, null, null);
    }

    @Override
    public void remove(@NotNull CubeTaskPerformance cubeTaskPerformance) throws Exception {
        CubeTaskPerformance mergedTaskPerformance = (CubeTaskPerformance)this.m_em.merge((Object)cubeTaskPerformance);
        this.m_em.remove((Object)mergedTaskPerformance);
    }

    public void removeTaskPerformanceFlex01(@NotNull CubeTaskPerformanceFlex01 cubeTaskPerformance) throws Exception {
        this.m_em.remove((Object)cubeTaskPerformance);
    }

    @Override
    @NotNull
    public CubeProcessPerformance createProcessPerformance(@NotNull CubeProcess cubeProcess, String componentInstanceId, Timestamp creationDateTime, Timestamp completionDateTime, Long taskTime, String discriminator, Map<String, Object> valueMap, Map<String, String> rangeMap) throws Exception {
        CubeProcessPerformance result = new CubeProcessPerformance();
        CubeProcess process = (CubeProcess)this.m_em.merge((Object)cubeProcess);
        result.setCubeProcess(process);
        result.setComponentInstanceId(componentInstanceId);
        result.setCreationDateTime(creationDateTime);
        result.setCreationDate(this.stripTimeInfo(creationDateTime));
        result.setCompletionDateTime(completionDateTime);
        result.setCompletionDate(this.stripTimeInfo(completionDateTime));
        result.setTaskTime(taskTime);
        result.setDiscriminator(discriminator);
        if (valueMap != null) {
            this.assignFlexValues(result, valueMap, rangeMap);
        }
        this.m_em.persist((Object)result);
        return result;
    }

    @Override
    @NotNull
    public CubeProcessPerformance createProcessPerformance(@NotNull CubeProcess cubeProcess, Timestamp completionDateTime, Long taskTime) throws Exception {
        return this.createProcessPerformance(cubeProcess, null, null, completionDateTime, taskTime, null, null, null);
    }

    @Override
    public void remove(@NotNull CubeProcessPerformance cubeProcessPerformance) throws Exception {
        CubeProcessPerformance mergedProcessPerformance = (CubeProcessPerformance)this.m_em.merge((Object)cubeProcessPerformance);
        this.m_em.remove((Object)mergedProcessPerformance);
    }

    public void remove(@NotNull CubeProcessPerformanceFlex01 cubeProcessPerformance) throws Exception {
        this.m_em.remove((Object)cubeProcessPerformance);
    }

    @Override
    @NotNull
    public CubeAuditInstance createCubeAuditInstance(String activityId, String componentInstanceId, String componentName, String processName, String invokedComponentName, String compositeDn, String activityName, String flowElementType, String faulted, String faultType, String recoverableFault, Long priority, Timestamp createTime, String operation, String participant, Long queryId, String roleId, Long threadId, Long loopCount, Long instanceCount, String scopeId, String businessIndicatorString, HashMap<String, Object> flexColumnValueMap) throws Exception {
        CubeAuditInstance cubeAuditInstance = new CubeAuditInstance(activityId, componentInstanceId, componentName, compositeDn, createTime, new Timestamp(System.currentTimeMillis()), operation, participant, queryId, roleId, threadId, "N", processName, loopCount, instanceCount, scopeId);
        cubeAuditInstance.setInvokedComponentName(invokedComponentName);
        cubeAuditInstance.setActivityName(activityName);
        cubeAuditInstance.setFlowElementType(flowElementType);
        cubeAuditInstance.setFaulted(faulted);
        cubeAuditInstance.setFaultType(faultType);
        cubeAuditInstance.setRecoverableFault(recoverableFault);
        cubeAuditInstance.setPriority(priority);
        if (businessIndicatorString != null) {
            cubeAuditInstance.setBusinessIndicators(businessIndicatorString);
        }
        if (flexColumnValueMap != null) {
            for (String flexColumnName : flexColumnValueMap.keySet()) {
                Object flexColumnValue;
                if (!flexColumnName.toUpperCase().startsWith("FLEX") || flexColumnName.toUpperCase().contains("RANGE") || (flexColumnValue = flexColumnValueMap.get(flexColumnName)) == null) continue;
                String rangeColumnName = flexColumnName.substring(0, flexColumnName.length() - 2) + "RANGE" + flexColumnName.substring(flexColumnName.length() - 2);
                String rangeValue = (String)flexColumnValueMap.get(rangeColumnName);
                this.setFlexValue(cubeAuditInstance, flexColumnName, flexColumnValue, rangeValue);
            }
        }
        this.m_em.persist((Object)cubeAuditInstance);
        return cubeAuditInstance;
    }

    @Override
    public void markCubeAuditInstanceProcessed(@NotNull CubeAuditInstance cubeAuditInstance) throws Exception {
        long currentTime = System.currentTimeMillis();
        cubeAuditInstance.setLastUpdated(new Timestamp(currentTime));
        cubeAuditInstance.setProcessedTime(new Timestamp(currentTime));
        cubeAuditInstance.setProcessed("Y");
        this.m_em.merge((Object)cubeAuditInstance);
    }

    @Override
    public void removeCubeAuditInstance(@NotNull CubeAuditInstance cubeAuditInstance) throws Exception {
        CubeAuditInstance mergedAuditInstance = (CubeAuditInstance)this.m_em.merge((Object)cubeAuditInstance);
        this.m_em.remove((Object)mergedAuditInstance);
    }

    @Override
    public void updateCubeLock(@NotNull CubeLock cubeLock) {
        this.m_em.merge((Object)cubeLock);
    }

    @Override
    public Integer executeUpdate(@NotNull String jpqlString, Map<String, Object> parameterMap) throws Exception {
        Query jpqlUpdateQuery = this.m_em.createQuery(jpqlString);
        if (parameterMap != null) {
            for (Map.Entry<String, Object> parameter : parameterMap.entrySet()) {
                jpqlUpdateQuery.setParameter(parameter.getKey(), parameter.getValue());
            }
        }
        int rows = jpqlUpdateQuery.executeUpdate();
        return new Integer(rows);
    }

    @Override
    public void beginTransaction() {
        this.m_em.getTransaction().begin();
    }

    @Override
    public void commitTransaction() {
        this.m_em.getTransaction().commit();
    }

    @Override
    public void rollbackTransaction() {
        this.m_em.getTransaction().rollback();
    }

    @Override
    public void clear() {
        this.m_em.clear();
    }

    private CubeLastSnapshot fetchLastSnapshot() throws Exception {
        return this.m_cube_query_service.selectLastSnapshot();
    }

    private void assignFlexValues(@NotNull CubeProcessPerformance factObject, Map<String, Object> valueMap, Map<String, String> rangeMap) throws Exception {
        CubeNametab nametab = factObject.getCubeProcess().getCubeNametab();
        if (rangeMap == null) {
            rangeMap = new HashMap<String, String>();
        }
        for (Map.Entry<String, Object> value : valueMap.entrySet()) {
            this.setFlexValue(factObject, nametab, value.getKey(), value.getValue(), rangeMap.get(value.getKey()));
        }
    }

    private void assignFlexValues(@NotNull CubeTaskPerformance factObject, Map<String, Object> valueMap, Map<String, String> rangeMap) throws Exception {
        CubeNametab nametab = factObject.getCubeActivity().getCubeProcess().getCubeNametab();
        if (rangeMap == null) {
            rangeMap = new HashMap<String, String>();
        }
        for (Map.Entry<String, Object> value : valueMap.entrySet()) {
            this.setFlexValue(factObject, nametab, value.getKey(), value.getValue(), rangeMap.get(value.getKey()));
        }
    }

    private void assignFlexValues(@NotNull CubeWorkload factObject, Map<String, Object> valueMap, Map<String, String> rangeMap) throws Exception {
        CubeNametab nametab = factObject.getCubeActivity().getCubeProcess().getCubeNametab();
        if (rangeMap == null) {
            rangeMap = new HashMap<String, String>();
        }
        for (Map.Entry<String, Object> value : valueMap.entrySet()) {
            this.setFlexValue(factObject, nametab, value.getKey(), value.getValue(), rangeMap.get(value.getKey()));
        }
    }

    private void setFlexValue(@NotNull CubeProcessPerformance factObject, @NotNull CubeNametab nametab, String indicatorName, Object indicatorValue, String rangeValue) throws IllegalArgumentException {
        if (indicatorName == null) {
            return;
        }
        if (indicatorName.equals(nametab.getFlexDateName01())) {
            factObject.setFlexDate01(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange01(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName02())) {
            factObject.setFlexDate02(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange02(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName03())) {
            factObject.setFlexDate03(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange03(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName04())) {
            factObject.setFlexDate04(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange04(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName05())) {
            factObject.setFlexDate05(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange05(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName06())) {
            factObject.setFlexDate06(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange06(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName07())) {
            factObject.setFlexDate07(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange07(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName08())) {
            factObject.setFlexDate08(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange08(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName09())) {
            factObject.setFlexDate09(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange09(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName10())) {
            factObject.setFlexDate10(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange10(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexStringName01())) {
            factObject.setFlexString01(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName02())) {
            factObject.setFlexString02(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName03())) {
            factObject.setFlexString03(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName04())) {
            factObject.setFlexString04(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName05())) {
            factObject.setFlexString05(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName06())) {
            factObject.setFlexString06(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName07())) {
            factObject.setFlexString07(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName08())) {
            factObject.setFlexString08(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName09())) {
            factObject.setFlexString09(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName10())) {
            factObject.setFlexString10(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName11())) {
            factObject.setFlexString11(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName12())) {
            factObject.setFlexString12(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName13())) {
            factObject.setFlexString13(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName14())) {
            factObject.setFlexString14(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName15())) {
            factObject.setFlexString15(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName16())) {
            factObject.setFlexString16(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName17())) {
            factObject.setFlexString17(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName18())) {
            factObject.setFlexString18(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName19())) {
            factObject.setFlexString19(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName20())) {
            factObject.setFlexString20(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexNumberName01())) {
            factObject.setFlexNumber01(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange01(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName02())) {
            factObject.setFlexNumber02(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange02(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName03())) {
            factObject.setFlexNumber03(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange03(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName04())) {
            factObject.setFlexNumber04(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange04(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName05())) {
            factObject.setFlexNumber05(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange05(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName06())) {
            factObject.setFlexNumber06(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange06(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName07())) {
            factObject.setFlexNumber07(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange07(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName08())) {
            factObject.setFlexNumber08(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange08(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName09())) {
            factObject.setFlexNumber09(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange09(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName10())) {
            factObject.setFlexNumber10(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange10(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName11())) {
            factObject.setFlexNumber11(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange11(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName12())) {
            factObject.setFlexNumber12(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange12(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName13())) {
            factObject.setFlexNumber13(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange13(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName14())) {
            factObject.setFlexNumber14(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange14(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName15())) {
            factObject.setFlexNumber15(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange15(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName16())) {
            factObject.setFlexNumber16(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange16(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName17())) {
            factObject.setFlexNumber17(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange17(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName18())) {
            factObject.setFlexNumber18(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange18(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName19())) {
            factObject.setFlexNumber19(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange19(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName20())) {
            factObject.setFlexNumber20(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange20(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName21())) {
            factObject.setFlexNumber21(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange21(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName22())) {
            factObject.setFlexNumber22(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange22(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName23())) {
            factObject.setFlexNumber23(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange23(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName24())) {
            factObject.setFlexNumber24(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange24(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName25())) {
            factObject.setFlexNumber25(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange25(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName26())) {
            factObject.setFlexNumber26(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange26(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName27())) {
            factObject.setFlexNumber27(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange27(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName28())) {
            factObject.setFlexNumber28(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange28(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName29())) {
            factObject.setFlexNumber29(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange29(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName30())) {
            factObject.setFlexNumber30(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange30(rangeValue);
            }
        }
    }

    private void setFlexValue(@NotNull CubeTaskPerformance factObject, @NotNull CubeNametab nametab, String indicatorName, Object indicatorValue, String rangeValue) throws IllegalArgumentException {
        if (indicatorName == null) {
            return;
        }
        if (indicatorName.equals(nametab.getFlexDateName01())) {
            factObject.setFlexDate01(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange01(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName02())) {
            factObject.setFlexDate02(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange02(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName03())) {
            factObject.setFlexDate03(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange03(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName04())) {
            factObject.setFlexDate04(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange04(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName05())) {
            factObject.setFlexDate05(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange05(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName06())) {
            factObject.setFlexDate06(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange06(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName07())) {
            factObject.setFlexDate07(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange07(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName08())) {
            factObject.setFlexDate08(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange08(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName09())) {
            factObject.setFlexDate09(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange09(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName10())) {
            factObject.setFlexDate10(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange10(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexStringName01())) {
            factObject.setFlexString01(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName02())) {
            factObject.setFlexString02(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName03())) {
            factObject.setFlexString03(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName04())) {
            factObject.setFlexString04(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName05())) {
            factObject.setFlexString05(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName06())) {
            factObject.setFlexString06(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName07())) {
            factObject.setFlexString07(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName08())) {
            factObject.setFlexString08(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName09())) {
            factObject.setFlexString09(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName10())) {
            factObject.setFlexString10(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName11())) {
            factObject.setFlexString11(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName12())) {
            factObject.setFlexString12(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName13())) {
            factObject.setFlexString13(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName14())) {
            factObject.setFlexString14(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName15())) {
            factObject.setFlexString15(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName16())) {
            factObject.setFlexString16(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName17())) {
            factObject.setFlexString17(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName18())) {
            factObject.setFlexString18(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName19())) {
            factObject.setFlexString19(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName20())) {
            factObject.setFlexString20(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexNumberName01())) {
            factObject.setFlexNumber01(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange01(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName02())) {
            factObject.setFlexNumber02(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange02(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName03())) {
            factObject.setFlexNumber03(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange03(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName04())) {
            factObject.setFlexNumber04(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange04(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName05())) {
            factObject.setFlexNumber05(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange05(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName06())) {
            factObject.setFlexNumber06(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange06(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName07())) {
            factObject.setFlexNumber07(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange07(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName08())) {
            factObject.setFlexNumber08(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange08(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName09())) {
            factObject.setFlexNumber09(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange09(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName10())) {
            factObject.setFlexNumber10(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange10(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName11())) {
            factObject.setFlexNumber11(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange11(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName12())) {
            factObject.setFlexNumber12(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange12(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName13())) {
            factObject.setFlexNumber13(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange13(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName14())) {
            factObject.setFlexNumber14(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange14(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName15())) {
            factObject.setFlexNumber15(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange15(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName16())) {
            factObject.setFlexNumber16(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange16(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName17())) {
            factObject.setFlexNumber17(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange17(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName18())) {
            factObject.setFlexNumber18(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange18(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName19())) {
            factObject.setFlexNumber19(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange19(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName20())) {
            factObject.setFlexNumber20(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange20(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName21())) {
            factObject.setFlexNumber21(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange21(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName22())) {
            factObject.setFlexNumber22(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange22(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName23())) {
            factObject.setFlexNumber23(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange23(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName24())) {
            factObject.setFlexNumber24(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange24(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName25())) {
            factObject.setFlexNumber25(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange25(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName26())) {
            factObject.setFlexNumber26(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange26(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName27())) {
            factObject.setFlexNumber27(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange27(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName28())) {
            factObject.setFlexNumber28(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange28(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName29())) {
            factObject.setFlexNumber29(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange29(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName30())) {
            factObject.setFlexNumber30(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange30(rangeValue);
            }
        }
    }

    private void setFlexValue(@NotNull CubeWorkload factObject, @NotNull CubeNametab nametab, String indicatorName, Object indicatorValue, String rangeValue) throws IllegalArgumentException {
        if (indicatorName == null) {
            return;
        }
        if (indicatorName.equals(nametab.getFlexDateName01())) {
            factObject.setFlexDate01(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange01(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName02())) {
            factObject.setFlexDate02(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange02(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName03())) {
            factObject.setFlexDate03(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange03(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName04())) {
            factObject.setFlexDate04(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange04(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName05())) {
            factObject.setFlexDate05(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange05(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName06())) {
            factObject.setFlexDate06(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange06(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName07())) {
            factObject.setFlexDate07(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange07(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName08())) {
            factObject.setFlexDate08(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange08(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName09())) {
            factObject.setFlexDate09(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange09(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexDateName10())) {
            factObject.setFlexDate10(this.toTimestamp(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange10(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexStringName01())) {
            factObject.setFlexString01(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName02())) {
            factObject.setFlexString02(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName03())) {
            factObject.setFlexString03(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName04())) {
            factObject.setFlexString04(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName05())) {
            factObject.setFlexString05(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName06())) {
            factObject.setFlexString06(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName07())) {
            factObject.setFlexString07(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName08())) {
            factObject.setFlexString08(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName09())) {
            factObject.setFlexString09(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName10())) {
            factObject.setFlexString10(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName11())) {
            factObject.setFlexString11(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName12())) {
            factObject.setFlexString12(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName13())) {
            factObject.setFlexString13(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName14())) {
            factObject.setFlexString14(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName15())) {
            factObject.setFlexString15(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName16())) {
            factObject.setFlexString16(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName17())) {
            factObject.setFlexString17(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName18())) {
            factObject.setFlexString18(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName19())) {
            factObject.setFlexString19(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexStringName20())) {
            factObject.setFlexString20(indicatorValue.toString());
        } else if (indicatorName.equals(nametab.getFlexNumberName01())) {
            factObject.setFlexNumber01(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange01(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName02())) {
            factObject.setFlexNumber02(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange02(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName03())) {
            factObject.setFlexNumber03(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange03(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName04())) {
            factObject.setFlexNumber04(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange04(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName05())) {
            factObject.setFlexNumber05(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange05(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName06())) {
            factObject.setFlexNumber06(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange06(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName07())) {
            factObject.setFlexNumber07(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange07(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName08())) {
            factObject.setFlexNumber08(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange08(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName09())) {
            factObject.setFlexNumber09(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange09(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName10())) {
            factObject.setFlexNumber10(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange10(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName11())) {
            factObject.setFlexNumber11(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange11(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName12())) {
            factObject.setFlexNumber12(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange12(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName13())) {
            factObject.setFlexNumber13(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange13(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName14())) {
            factObject.setFlexNumber14(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange14(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName15())) {
            factObject.setFlexNumber15(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange15(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName16())) {
            factObject.setFlexNumber16(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange16(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName17())) {
            factObject.setFlexNumber17(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange17(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName18())) {
            factObject.setFlexNumber18(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange18(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName19())) {
            factObject.setFlexNumber19(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange19(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName20())) {
            factObject.setFlexNumber20(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange20(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName21())) {
            factObject.setFlexNumber21(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange21(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName22())) {
            factObject.setFlexNumber22(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange22(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName23())) {
            factObject.setFlexNumber23(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange23(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName24())) {
            factObject.setFlexNumber24(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange24(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName25())) {
            factObject.setFlexNumber25(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange25(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName26())) {
            factObject.setFlexNumber26(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange26(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName27())) {
            factObject.setFlexNumber27(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange27(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName28())) {
            factObject.setFlexNumber28(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange28(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName29())) {
            factObject.setFlexNumber29(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange29(rangeValue);
            }
        } else if (indicatorName.equals(nametab.getFlexNumberName30())) {
            factObject.setFlexNumber30(this.toBigDecimal(indicatorValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange30(rangeValue);
            }
        }
    }

    private void setFlexValue(@NotNull CubeWorkload factObject, String flexColumnName, Object flexColumnValue, String rangeValue) throws IllegalArgumentException {
        if (flexColumnName == null) {
            return;
        }
        if ((flexColumnName = flexColumnName.toUpperCase()).equals("FLEXDATE01")) {
            factObject.setFlexDate01(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange01(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE02")) {
            factObject.setFlexDate02(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange02(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE03")) {
            factObject.setFlexDate03(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange03(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE04")) {
            factObject.setFlexDate04(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange04(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE05")) {
            factObject.setFlexDate05(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange05(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE06")) {
            factObject.setFlexDate06(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange06(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE07")) {
            factObject.setFlexDate07(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange07(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE08")) {
            factObject.setFlexDate08(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange08(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE09")) {
            factObject.setFlexDate09(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange09(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE10")) {
            factObject.setFlexDate10(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange10(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXSTRING01")) {
            factObject.setFlexString01(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING02")) {
            factObject.setFlexString02(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING03")) {
            factObject.setFlexString03(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING04")) {
            factObject.setFlexString04(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING05")) {
            factObject.setFlexString05(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING06")) {
            factObject.setFlexString06(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING07")) {
            factObject.setFlexString07(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING08")) {
            factObject.setFlexString08(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING09")) {
            factObject.setFlexString09(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING10")) {
            factObject.setFlexString10(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING11")) {
            factObject.setFlexString11(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING12")) {
            factObject.setFlexString12(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING13")) {
            factObject.setFlexString13(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING14")) {
            factObject.setFlexString14(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING15")) {
            factObject.setFlexString15(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING16")) {
            factObject.setFlexString16(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING17")) {
            factObject.setFlexString17(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING18")) {
            factObject.setFlexString18(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING19")) {
            factObject.setFlexString19(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING20")) {
            factObject.setFlexString20(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXNUMBER01")) {
            factObject.setFlexNumber01(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange01(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER02")) {
            factObject.setFlexNumber02(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange02(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER03")) {
            factObject.setFlexNumber03(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange03(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER04")) {
            factObject.setFlexNumber04(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange04(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER05")) {
            factObject.setFlexNumber05(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange05(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER06")) {
            factObject.setFlexNumber06(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange06(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER07")) {
            factObject.setFlexNumber07(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange07(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER08")) {
            factObject.setFlexNumber08(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange08(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER09")) {
            factObject.setFlexNumber09(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange09(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER10")) {
            factObject.setFlexNumber10(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange10(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER11")) {
            factObject.setFlexNumber11(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange11(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER12")) {
            factObject.setFlexNumber12(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange12(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER13")) {
            factObject.setFlexNumber13(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange13(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER14")) {
            factObject.setFlexNumber14(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange14(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER15")) {
            factObject.setFlexNumber15(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange15(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER16")) {
            factObject.setFlexNumber16(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange16(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER17")) {
            factObject.setFlexNumber17(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange17(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER18")) {
            factObject.setFlexNumber18(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange18(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER19")) {
            factObject.setFlexNumber19(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange19(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER20")) {
            factObject.setFlexNumber20(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange20(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER21")) {
            factObject.setFlexNumber21(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange21(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER22")) {
            factObject.setFlexNumber22(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange22(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER23")) {
            factObject.setFlexNumber23(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange23(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER24")) {
            factObject.setFlexNumber24(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange24(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER25")) {
            factObject.setFlexNumber25(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange25(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER26")) {
            factObject.setFlexNumber26(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange26(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER27")) {
            factObject.setFlexNumber27(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange27(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER28")) {
            factObject.setFlexNumber28(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange28(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER29")) {
            factObject.setFlexNumber29(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange29(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER30")) {
            factObject.setFlexNumber30(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange30(rangeValue);
            }
        }
    }

    private void setFlexValue(@NotNull CubeAuditInstance factObject, String flexColumnName, Object flexColumnValue, String rangeValue) throws IllegalArgumentException {
        if (flexColumnName == null) {
            return;
        }
        if ((flexColumnName = flexColumnName.toUpperCase()).equals("FLEXDATE01")) {
            factObject.setFlexDate01(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange01(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE02")) {
            factObject.setFlexDate02(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange02(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE03")) {
            factObject.setFlexDate03(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange03(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE04")) {
            factObject.setFlexDate04(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange04(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE05")) {
            factObject.setFlexDate05(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange05(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE06")) {
            factObject.setFlexDate06(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange06(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE07")) {
            factObject.setFlexDate07(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange07(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE08")) {
            factObject.setFlexDate08(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange08(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE09")) {
            factObject.setFlexDate09(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange09(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXDATE10")) {
            factObject.setFlexDate10(this.toTimestamp(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexDateRange10(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXSTRING01")) {
            factObject.setFlexString01(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING02")) {
            factObject.setFlexString02(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING03")) {
            factObject.setFlexString03(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING04")) {
            factObject.setFlexString04(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING05")) {
            factObject.setFlexString05(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING06")) {
            factObject.setFlexString06(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING07")) {
            factObject.setFlexString07(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING08")) {
            factObject.setFlexString08(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING09")) {
            factObject.setFlexString09(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING10")) {
            factObject.setFlexString10(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING11")) {
            factObject.setFlexString11(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING12")) {
            factObject.setFlexString12(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING13")) {
            factObject.setFlexString13(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING14")) {
            factObject.setFlexString14(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING15")) {
            factObject.setFlexString15(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING16")) {
            factObject.setFlexString16(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING17")) {
            factObject.setFlexString17(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING18")) {
            factObject.setFlexString18(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING19")) {
            factObject.setFlexString19(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXSTRING20")) {
            factObject.setFlexString20(flexColumnValue.toString());
        } else if (flexColumnName.equals("FLEXNUMBER01")) {
            factObject.setFlexNumber01(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange01(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER02")) {
            factObject.setFlexNumber02(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange02(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER03")) {
            factObject.setFlexNumber03(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange03(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER04")) {
            factObject.setFlexNumber04(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange04(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER05")) {
            factObject.setFlexNumber05(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange05(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER06")) {
            factObject.setFlexNumber06(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange06(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER07")) {
            factObject.setFlexNumber07(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange07(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER08")) {
            factObject.setFlexNumber08(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange08(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER09")) {
            factObject.setFlexNumber09(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange09(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER10")) {
            factObject.setFlexNumber10(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange10(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER11")) {
            factObject.setFlexNumber11(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange11(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER12")) {
            factObject.setFlexNumber12(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange12(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER13")) {
            factObject.setFlexNumber13(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange13(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER14")) {
            factObject.setFlexNumber14(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange14(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER15")) {
            factObject.setFlexNumber15(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange15(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER16")) {
            factObject.setFlexNumber16(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange16(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER17")) {
            factObject.setFlexNumber17(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange17(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER18")) {
            factObject.setFlexNumber18(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange18(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER19")) {
            factObject.setFlexNumber19(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange19(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER20")) {
            factObject.setFlexNumber20(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange20(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER21")) {
            factObject.setFlexNumber21(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange21(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER22")) {
            factObject.setFlexNumber22(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange22(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER23")) {
            factObject.setFlexNumber23(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange23(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER24")) {
            factObject.setFlexNumber24(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange24(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER25")) {
            factObject.setFlexNumber25(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange25(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER26")) {
            factObject.setFlexNumber26(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange26(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER27")) {
            factObject.setFlexNumber27(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange27(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER28")) {
            factObject.setFlexNumber28(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange28(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER29")) {
            factObject.setFlexNumber29(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange29(rangeValue);
            }
        } else if (flexColumnName.equals("FLEXNUMBER30")) {
            factObject.setFlexNumber30(this.toBigDecimal(flexColumnValue));
            if (rangeValue != null) {
                factObject.setFlexNumberRange30(rangeValue);
            }
        }
    }

    private Timestamp toTimestamp(Object value) {
        Timestamp timestamp = null;
        if (value instanceof Timestamp) {
            timestamp = (Timestamp)value;
        } else if (value instanceof Calendar) {
            timestamp = new Timestamp(((Calendar)value).getTimeInMillis());
        } else if (value instanceof Date) {
            timestamp = new Timestamp(((Date)value).getTime());
        }
        return timestamp;
    }

    private BigDecimal toBigDecimal(Object value) {
        BigDecimal bigdecimal = null;
        if (!(value instanceof BigDecimal)) {
            String strValue = value.toString();
            try {
                bigdecimal = new BigDecimal(strValue);
            }
            catch (NumberFormatException nfe) {
                bigdecimal = null;
            }
        } else {
            bigdecimal = (BigDecimal)value;
        }
        return bigdecimal;
    }

    private Timestamp stripTimeInfo(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }
}

