/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.cube.persistence.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryServiceLocal;
import oracle.bpm.analytics.cube.persistence.model.CubeAuditInstance;
import oracle.bpm.analytics.cube.persistence.model.CubeLastSnapshot;
import oracle.bpm.analytics.cube.persistence.model.CubeLock;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;
import oracle.bpm.analytics.cube.persistence.model.CubeNametabRange;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.cube.persistence.model.CubeRole;
import org.jetbrains.annotations.NotNull;

@Stateless(name="PersistenceQueryServiceBean", mappedName="BPMAnalytics")
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class PersistenceQueryServiceBean
implements PersistenceQueryService,
PersistenceQueryServiceLocal {
    private EntityManager m_em;
    private Logger m_logger;
    private static final String CLASS_NAME = "PersistenceQueryServiceBean";
    private static final String FLEXDATE_ATTR_PREFIX = "flexDate";
    private static final String FLEXDATERANGE_ATTR_PREFIX = "flexDateRange";
    private static final String FLEXNUMBER_ATTR_PREFIX = "flexNumber";
    private static final String FLEXNUMBERRANGE_ATTR_PREFIX = "flexNumberRange";
    private static final String FLEXSTRING_ATTR_PREFIX = "flexString";

    public PersistenceQueryServiceBean() {
        this.init();
    }

    @PostConstruct
    public void init() {
        this.m_logger = Logger.getLogger("oracle.bpm.analytics.cube.persistence");
    }

    @PersistenceContext(unitName="BPMAnalyticsPersistenceUnit")
    public void setEntityManager(EntityManager entityManager) {
        if (this.m_logger == null) {
            this.init();
        }
        this.m_logger.entering(CLASS_NAME, "setEntityManager");
        this.m_em = entityManager;
        this.m_logger.exiting(CLASS_NAME, "setEntityManager");
    }

    @Override
    public CubeLastSnapshot selectLastSnapshot() throws Exception {
        CubeLastSnapshot result = null;
        this.m_logger.entering(CLASS_NAME, "selectLastSnapshot");
        try {
            result = (CubeLastSnapshot)this.m_em.createNamedQuery("findLastSnapshotTime").getSingleResult();
        }
        catch (NoResultException nre) {
            result = null;
        }
        this.m_logger.exiting(CLASS_NAME, "selectLastSnapshot", result == null ? "null" : result.getLastsnapshot());
        return result;
    }

    @Override
    public CubeProcess selectCubeProcess(@NotNull String domainName, @NotNull String compositeName, @NotNull String revision, @NotNull String label, @NotNull String processName) throws Exception {
        return this.selectCubeProcess(domainName, compositeName, revision, label, processName, "BPMN");
    }

    @Override
    public CubeProcess selectCubeProcess(@NotNull String domainName, @NotNull String compositeName, @NotNull String revision, @NotNull String label, @NotNull String processName, @NotNull String processType) throws Exception {
        CubeProcess result;
        this.m_logger.entering(CLASS_NAME, "selectCubeProcess", processName);
        try {
            Query query = this.m_em.createNamedQuery("CubeProcess.findCubeProcess").setParameter("domainName", (Object)domainName).setParameter("compositeName", (Object)compositeName).setParameter("revision", (Object)revision).setParameter("label", (Object)label).setParameter("processName", (Object)processName).setParameter("processType", (Object)processType);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            result = (CubeProcess)query.getSingleResult();
        }
        catch (NoResultException nre) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, CLASS_NAME, "selectCubeProcess", "Process " + processName + " not found in composite " + compositeName + " revision " + revision + ", domain " + domainName);
            }
            result = null;
        }
        this.m_logger.exiting(CLASS_NAME, "selectCubeProcess", result == null ? "null" : result.toString());
        return result;
    }

    @Override
    public List<CubeProcess> selectCubeProcess(String domainName, String compositeName, String revision, String label) throws Exception {
        return this.selectCubeProcess(domainName, compositeName, revision, label, 0);
    }

    @Override
    public List<CubeProcess> selectCubeProcess(String compositeDN) throws Exception {
        List resultList;
        block2: {
            resultList = null;
            this.m_logger.entering(CLASS_NAME, "selectCubeProcess(compositeDN)", compositeDN);
            try {
                Query query = this.m_em.createNamedQuery("CubeProcess.findCubeProcessesFromCompositeDN").setParameter("compositeDN", (Object)compositeDN);
                resultList = query.getResultList();
            }
            catch (NoResultException nre) {
                if (!this.m_logger.isLoggable(Level.FINEST)) break block2;
                this.m_logger.logp(Level.FINEST, CLASS_NAME, "selectCubeProcess(compositeDN)", "No processes found in composite " + compositeDN);
            }
        }
        this.m_logger.exiting(CLASS_NAME, "selectCubeProcess(compositeDN)", "Number of processes found: " + (resultList != null ? resultList.size() : 0));
        return resultList;
    }

    @Override
    public CubeRole selectCubeRole(@NotNull Long processId, @NotNull String roleName) throws Exception {
        Object result;
        this.m_logger.entering(CLASS_NAME, "selectCubeRole", roleName);
        try {
            Query query = this.m_em.createNamedQuery("CubeRole.findByNameAndProcessId").setParameter("roleName", (Object)roleName).setParameter("processId", (Object)processId);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            result = (CubeRole)query.getSingleResult();
        }
        catch (NoResultException nre) {
            result = null;
        }
        this.m_logger.exiting(CLASS_NAME, "selectCubeRole", result == null ? "null" : result.toString());
        return result;
    }

    @Override
    public CubeAuditInstance selectCubeAuditInstance(@NotNull String activityId, @NotNull String componentInstanceId, @NotNull String operation, @NotNull Long threadId, Boolean processed, String scopeId) {
        StringBuffer jpqlBuf = new StringBuffer("select o from CubeAuditInstance o  where  o.componentInstanceId=:componentinstanceid and o.operation=:operation and  (o.operation in ('INSTANCE_CREATED', 'INSTANCE_TERMINATED', 'INSTANCE_ABORTED')     or (o.threadId=:threadid and o.activityId=:activityid ");
        if (scopeId != null) {
            jpqlBuf.append(" and o.scopeId=:scopeid ");
        }
        jpqlBuf.append("))");
        if (processed != null) {
            jpqlBuf.append(" and o.processed = :processed ");
        }
        Query query = this.m_em.createQuery(jpqlBuf.toString());
        query.setParameter("componentinstanceid", (Object)componentInstanceId).setParameter("operation", (Object)operation).setParameter("threadid", (Object)threadId).setParameter("activityid", (Object)activityId);
        if (scopeId != null) {
            query.setParameter("scopeid", (Object)scopeId);
        }
        if (processed != null) {
            query.setParameter("processed", (Object)(processed != false ? "Y" : "N"));
        }
        query.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
        query.setHint("eclipselink.query-type", (Object)"ReadObject");
        CubeAuditInstance cubeAuditInstance = null;
        try {
            cubeAuditInstance = (CubeAuditInstance)query.getSingleResult();
        }
        catch (NoResultException nre) {
            cubeAuditInstance = null;
        }
        return cubeAuditInstance;
    }

    @Override
    public List select(@NotNull String jpqlString, Map<String, Object> parameterMap) throws Exception {
        return this.select(jpqlString, parameterMap, -1, -1);
    }

    @Override
    public List select(@NotNull String jpqlString, Map<String, Object> parameterMap, int startPosition, int fetchSize) throws Exception {
        List resultList = null;
        this.m_logger.entering(CLASS_NAME, "select", "Query: " + jpqlString + "Binding Parameters: " + (parameterMap == null ? "None." : Integer.valueOf(parameterMap.size())));
        Query jpqlQuery = this.m_em.createQuery(jpqlString);
        if (parameterMap != null) {
            for (Map.Entry<String, Object> parameter : parameterMap.entrySet()) {
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, CLASS_NAME, "select", "Bind parameter " + parameter.getKey() + " to value " + parameter.getValue());
                }
                jpqlQuery.setParameter(parameter.getKey(), parameter.getValue());
            }
        }
        if (startPosition > 0) {
            jpqlQuery.setFirstResult(startPosition);
        }
        if (fetchSize > 0) {
            jpqlQuery.setMaxResults(fetchSize);
        }
        try {
            resultList = jpqlQuery.getResultList();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        this.m_logger.exiting(CLASS_NAME, "select", (resultList != null ? Integer.valueOf(resultList.size()) : "null") + " rows found.");
        return resultList;
    }

    @Override
    public List selectWithNativeQuery(@NotNull String nativeQuery, Map<Integer, Object> parameterMap) throws Exception {
        List resultList = null;
        this.m_logger.entering(CLASS_NAME, "select", "Query: " + nativeQuery + "Binding Parameters: " + (parameterMap == null ? "None." : Integer.valueOf(parameterMap.size())));
        Query query = this.m_em.createNativeQuery(nativeQuery);
        if (parameterMap != null) {
            for (Map.Entry<Integer, Object> parameter : parameterMap.entrySet()) {
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, CLASS_NAME, "selectWithNativeQuery", "Bind parameter " + parameter.getKey() + " to value " + parameter.getValue());
                }
                query.setParameter(parameter.getKey().intValue(), parameter.getValue());
            }
        }
        try {
            resultList = query.getResultList();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        this.m_logger.exiting(CLASS_NAME, "select", (resultList != null ? Integer.valueOf(resultList.size()) : "0") + " rows found.");
        return resultList;
    }

    @Override
    public List select(@NotNull String jpqlString) throws Exception {
        return this.select(jpqlString, null);
    }

    @Override
    public Object selectSingle(@NotNull String jpqlString, Map<String, Object> parameterMap) throws Exception {
        this.m_logger.entering(CLASS_NAME, "selectSingle", "Query: " + jpqlString + "Binding Parameters: " + (parameterMap == null ? "None." : Integer.valueOf(parameterMap.size())));
        Query jpqlQuery = this.m_em.createQuery(jpqlString);
        if (parameterMap != null) {
            for (Map.Entry<String, Object> parameter : parameterMap.entrySet()) {
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, CLASS_NAME, "selectSingle", "Bind parameter " + parameter.getKey() + " to value " + parameter.getValue());
                }
                jpqlQuery.setParameter(parameter.getKey(), parameter.getValue());
            }
        }
        jpqlQuery.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
        jpqlQuery.setHint("eclipselink.query-type", (Object)"ReadObject");
        try {
            Object result = jpqlQuery.getSingleResult();
            this.m_logger.exiting(CLASS_NAME, "selectSingle", result != null ? result.toString() : "null");
            return result;
        }
        catch (NoResultException nre) {
            this.m_logger.exiting(CLASS_NAME, "selectSingle", "null");
            return null;
        }
    }

    @Override
    public Object selectSingle(@NotNull String jpqlString) throws Exception {
        return this.selectSingle(jpqlString, null);
    }

    @Override
    public Object[] resolveFlexAttribute(@NotNull String domainName, @NotNull String compositeName, @NotNull String compositeRevision, @NotNull String compositeLabel, @NotNull String attribute) throws Exception {
        this.m_logger.entering(CLASS_NAME, "resolveFlexAttribute(composite)", domainName + "/" + compositeName + "!" + compositeRevision + "*" + compositeLabel + ", attribute: " + attribute);
        List<CubeProcess> cubeProcessList = this.selectCubeProcess(domainName, compositeName, compositeRevision, compositeLabel, 1);
        if (cubeProcessList != null && cubeProcessList.size() > 0) {
            this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute(composite)", attribute);
            return this.resolveFlexAttribute(cubeProcessList.get(0), attribute);
        }
        Object[] result = new Object[]{attribute, "String"};
        this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute(composite)", attribute);
        return result;
    }

    @Override
    public Object[] resolveFlexAttribute(@NotNull String compositeDN, @NotNull String attribute) throws Exception {
        return this.resolveFlexAttribute(compositeDN, attribute, false);
    }

    @Override
    public Object[] resolveFlexAttribute(@NotNull String compositeDN, @NotNull String attribute, boolean useRange) throws Exception {
        this.m_logger.entering(CLASS_NAME, "resolveFlexAttribute(compositeDN)", compositeDN);
        List<CubeProcess> cubeProcessList = this.selectCubeProcess(compositeDN);
        if (cubeProcessList != null && cubeProcessList.size() > 0) {
            this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute(compositeDN)", attribute);
            return this.resolveFlexAttribute(cubeProcessList.get(0), attribute, useRange);
        }
        Object[] result = new Object[]{attribute, "String"};
        this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute(compositeDN)", attribute);
        return result;
    }

    @Override
    public List<CubeNametabRange> getFlexAttributeRanges(@NotNull String compositeDN, @NotNull String attribute) throws Exception {
        CubeNametab nametab;
        ArrayList<CubeNametabRange> resultList = new ArrayList();
        this.m_logger.entering(CLASS_NAME, "getFlexAttributeRanges(compositeDN)", compositeDN);
        List<CubeProcess> cubeProcessList = this.selectCubeProcess(compositeDN);
        if (cubeProcessList != null && cubeProcessList.size() > 0 && (nametab = cubeProcessList.get(0).getCubeNametab()) != null) {
            resultList = nametab.getCubeNametabRangesForIndicator(attribute);
        }
        this.m_logger.exiting(CLASS_NAME, "getFlexAttributeRanges(compositeDN)", "No. ranges defined for " + attribute + ": " + resultList.size());
        return resultList;
    }

    @Override
    public Object[] resolveFlexAttribute(@NotNull CubeProcess cubeProcess, @NotNull String attribute) throws Exception {
        return this.resolveFlexAttribute(cubeProcess, attribute, false);
    }

    public Object[] resolveFlexAttribute(@NotNull CubeProcess cubeProcess, @NotNull String attribute, boolean useRange) throws Exception {
        Object[] result = new Object[3];
        CubeNametab nameTab = cubeProcess.getCubeNametab();
        boolean hasRange = false;
        this.m_logger.entering(CLASS_NAME, "resolveFlexAttribute", cubeProcess.toString() + ", attribute:" + attribute);
        if (nameTab != null) {
            int i;
            if (useRange) {
                hasRange = this.hasRange(nameTab, attribute);
            }
            for (i = 1; i <= 10; ++i) {
                if (nameTab.getFlexDateName(i) == null || !nameTab.getFlexDateName(i).equals(attribute)) continue;
                if (useRange && hasRange) {
                    result[0] = FLEXDATERANGE_ATTR_PREFIX + this.toTwoDigitNumber(i);
                    result[1] = "String";
                } else {
                    result[0] = FLEXDATE_ATTR_PREFIX + this.toTwoDigitNumber(i);
                    result[1] = "Timestamp";
                }
                result[2] = nameTab.getFlexDateType(i);
                this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute", result[0]);
                return result;
            }
            for (i = 1; i <= 30; ++i) {
                if (nameTab.getFlexNumberName(i) == null || !nameTab.getFlexNumberName(i).equals(attribute)) continue;
                if (useRange & hasRange) {
                    result[0] = FLEXNUMBERRANGE_ATTR_PREFIX + this.toTwoDigitNumber(i);
                    result[1] = "String";
                } else {
                    result[0] = FLEXNUMBER_ATTR_PREFIX + this.toTwoDigitNumber(i);
                    result[1] = "Number";
                }
                result[2] = nameTab.getFlexNumberType(i);
                this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute", result[0]);
                return result;
            }
            for (i = 1; i <= 20; ++i) {
                if (nameTab.getFlexStringName(i) == null || !nameTab.getFlexStringName(i).equals(attribute)) continue;
                result[0] = FLEXSTRING_ATTR_PREFIX + this.toTwoDigitNumber(i);
                result[1] = "String";
                result[2] = nameTab.getFlexStringType(i);
                this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute", result[0]);
                return result;
            }
        }
        result[0] = attribute;
        result[1] = "String";
        result[2] = "";
        this.m_logger.exiting(CLASS_NAME, "resolveFlexAttribute", result[0]);
        return result;
    }

    @Override
    public CubeLock selectCubeLockForUpdate(@NotNull String lockName) throws Exception {
        Query query = this.m_em.createNamedQuery("CubeLock.selectByLockName").setParameter("lockname", (Object)lockName);
        query.setHint("eclipselink.pessimistic-lock", (Object)"Lock");
        query.setHint("javax.persistence.lock.timeout", (Object)new Integer(60000));
        CubeLock cubeLock = null;
        try {
            cubeLock = (CubeLock)query.getSingleResult();
        }
        catch (Exception e) {
            cubeLock = null;
        }
        return cubeLock;
    }

    private boolean hasRange(CubeNametab nameTab, String attribute) {
        List<CubeNametabRange> nametabRangeList = nameTab.getCubeNametabRangeList();
        for (CubeNametabRange range : nametabRangeList) {
            if (!range.getIndicatorName().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    private String toTwoDigitNumber(int value) throws IllegalArgumentException {
        if (value < 10) {
            return "0" + Integer.toString(value);
        }
        if (value < 100) {
            return Integer.toString(value);
        }
        throw new IllegalArgumentException("Value is not two digits: " + value);
    }

    private List<CubeProcess> selectCubeProcess(@NotNull String domainName, @NotNull String compositeName, @NotNull String revision, @NotNull String label, int maxRows) throws Exception {
        List resultList;
        block3: {
            resultList = null;
            this.m_logger.entering(CLASS_NAME, "selectCubeProcess(composite)", domainName + "/" + compositeName + "!" + revision + "*" + label);
            try {
                Query query = this.m_em.createNamedQuery("CubeProcess.findCubeProcessesInComposite").setParameter("domainName", (Object)domainName).setParameter("compositeName", (Object)compositeName).setParameter("revision", (Object)revision).setParameter("label", (Object)label);
                if (maxRows > 0) {
                    query.setMaxResults(maxRows);
                }
                resultList = query.getResultList();
            }
            catch (NoResultException nre) {
                if (!this.m_logger.isLoggable(Level.FINEST)) break block3;
                this.m_logger.logp(Level.FINEST, CLASS_NAME, "selectCubeProcess(composite)", "No processes found in composite " + compositeName + " revision " + revision + ", domain " + domainName);
            }
        }
        this.m_logger.exiting(CLASS_NAME, "selectCubeProcess(composite)", "Number of processes found: " + (resultList != null ? resultList.size() : 0));
        return resultList;
    }
}

