/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action.persistence.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import oracle.bpm.analytics.action.persistence.ActionQueryService;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActionExceps;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActions;

@Stateless(name="ActionQueryServiceBean", mappedName="BPMAnalytics")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class ActionQueryServiceBean
implements ActionQueryService {
    @PersistenceContext(unitName="BPMAnalyticsPersistenceUnit")
    EntityManager em;

    @Override
    public List<BpmMeasurementActions> selectMeasurementActions(String actionName) throws Exception {
        ArrayList<BpmMeasurementActions> actionLogList = new ArrayList();
        actionLogList = this.em.createNamedQuery("BpmMeasurementActions.findByName").setParameter("actionName", (Object)actionName).getResultList();
        return actionLogList;
    }

    @Override
    public List<BpmMeasurementActions> selectMeasurementActions(String actionName, Long queryId) throws Exception {
        List actionLogList = null;
        try {
            actionLogList = this.em.createNamedQuery("BpmMeasurementActions.findByNameAndId").setParameter("actionName", (Object)actionName).setParameter("queryId", (Object)queryId).getResultList();
        }
        catch (NoResultException nre) {
            actionLogList = null;
        }
        return actionLogList;
    }

    @Override
    public List<BpmMeasurementActions> selectMeasurementActions(String actionName, int start, int size) throws Exception {
        List actionLogList = null;
        try {
            actionLogList = this.em.createNamedQuery("BpmMeasurementActions.findByName").setParameter("actionName", (Object)actionName).setFirstResult(start).setMaxResults(size).getResultList();
        }
        catch (NoResultException nre) {
            actionLogList = null;
        }
        return actionLogList;
    }

    @Override
    public List<BpmMeasurementActionExceps> selectMeasurementActionExceptions(String actionName) throws Exception {
        List actionExceptionLogList = null;
        try {
            actionExceptionLogList = this.em.createNamedQuery("BpmMeasurementActionExceps.findByName").setParameter("actionName", (Object)actionName).getResultList();
        }
        catch (Exception e) {
            actionExceptionLogList = null;
        }
        return actionExceptionLogList;
    }

    @Override
    public List<BpmMeasurementActionExceps> selectMeasurementActionExceptions(String actionName, int start, int size) throws Exception {
        List actionExceptionLogList = null;
        try {
            actionExceptionLogList = this.em.createNamedQuery("BpmMeasurementActionExceps.findByName").setParameter("actionName", (Object)actionName).setFirstResult(start).setMaxResults(size).getResultList();
        }
        catch (Exception e) {
            actionExceptionLogList = null;
        }
        return actionExceptionLogList;
    }

    @Override
    public List select(String jpqlString) throws Exception {
        Query jpqlQuery = this.em.createQuery(jpqlString);
        return jpqlQuery.getResultList();
    }

    @Override
    public List select(String jpqlString, Map<String, Object> parameterMap) throws Exception {
        Query jpqlQuery = this.em.createQuery(jpqlString);
        if (parameterMap != null) {
            for (Map.Entry<String, Object> parameter : parameterMap.entrySet()) {
                jpqlQuery.setParameter(parameter.getKey(), parameter.getValue());
            }
        }
        return jpqlQuery.getResultList();
    }
}

