/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.action.persistence.impl;

import java.sql.Timestamp;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import oracle.bpm.analytics.action.persistence.ActionPersistenceService;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActionExceps;
import oracle.bpm.analytics.action.persistence.model.BpmMeasurementActions;

@Stateless(name="ActionPersistenceServiceBean", mappedName="BPMAnalytics")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class ActionPersistenceServiceBean
implements ActionPersistenceService {
    @PersistenceContext(unitName="BPMAnalyticsPersistenceUnit")
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Override
    public BpmMeasurementActions createMeasurementAction(String actionName, Long queryId, Timestamp auditInstanceTime) throws Exception {
        BpmMeasurementActions actionLog = new BpmMeasurementActions();
        actionLog.setActionName(actionName);
        actionLog.setQueryId(queryId);
        actionLog.setAuditQueryTime(auditInstanceTime);
        this.em.persist((Object)actionLog);
        return actionLog;
    }

    @Override
    public void remove(BpmMeasurementActions measurementAction) throws Exception {
        BpmMeasurementActions mergedObj = (BpmMeasurementActions)this.em.merge((Object)measurementAction);
        this.em.remove((Object)mergedObj);
    }

    @Override
    public int removeActionForQuery(Long queryId, String actionName) throws Exception {
        Query query = this.em.createQuery("delete from BpmMeasurementActions bpma where bpma.queryId = :queryId and bpma.actionName = :actionName");
        query.setParameter("queryId", (Object)queryId);
        query.setParameter("actionName", (Object)actionName);
        int deleted = query.executeUpdate();
        return deleted;
    }

    @Override
    public BpmMeasurementActionExceps createMeasurementActionException(String name, String message, Timestamp time, String actionName, Long queryId, String status) throws Exception {
        BpmMeasurementActionExceps actionExceptionLog = new BpmMeasurementActionExceps();
        actionExceptionLog.setActionExceptionName(name);
        if (message != null && message.length() > 4000) {
            message = message.substring(0, 4000);
        }
        actionExceptionLog.setMessage(message);
        actionExceptionLog.setActionName(actionName);
        actionExceptionLog.setQueryId(queryId);
        actionExceptionLog.setActionExceptionTimestamp(time);
        actionExceptionLog.setStatus(status);
        this.em.persist((Object)actionExceptionLog);
        return actionExceptionLog;
    }

    @Override
    public void remove(BpmMeasurementActionExceps actionException) throws Exception {
        BpmMeasurementActionExceps mergedObj = (BpmMeasurementActionExceps)this.em.merge((Object)actionException);
        this.em.remove((Object)mergedObj);
    }
}

