/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util.ant;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskInvoker {
    private static final String ANT_FILE = "ant.file";
    private static final String ANT_PROJECT_HELPER = "ant.projectHelper";

    public static void doInvoke(@NotNull File antFile, @NotNull String targetName, @Nullable Map properties) throws Exception {
        if (antFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/ant/TaskInvoker.doInvoke must not be null");
        }
        if (targetName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/ant/TaskInvoker.doInvoke must not be null");
        }
        Project project = new Project();
        String baseDir = antFile.getParentFile().getAbsolutePath();
        project.setBasedir(baseDir);
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DefaultLogger listener = new DefaultLogger();
            listener.setMessageOutputLevel(3);
            listener.setErrorPrintStream(new PrintStream(new BufferedOutputStream(errorStream)));
            listener.setOutputPrintStream(new PrintStream(new BufferedOutputStream(outputStream)));
            project.setProjectReference((Object)listener);
            project.addBuildListener((BuildListener)listener);
            project.fireBuildStarted();
            project.init();
            if (properties != null && !properties.isEmpty()) {
                Set stringSet = properties.keySet();
                for (Object key : stringSet) {
                    project.setProperty((String)key, (String)properties.get(key));
                }
            }
            project.setUserProperty(ANT_FILE, antFile.getAbsolutePath());
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            project.addReference(ANT_PROJECT_HELPER, (Object)helper);
            helper.parse(project, (Object)antFile);
            project.executeTarget(targetName);
            project.fireBuildFinished(null);
        }
        catch (BuildException e) {
            project.fireBuildFinished((Throwable)e);
            throw new Exception(errorStream.toString(), e);
        }
    }
}

