/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Time;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.pml.service.util.DeployedCompositeService;
import oracle.bpm.pml.service.util.DeployedProjectUtil;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.fabric.blocks.DeployedCompositeModel;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.CompositeNameModel;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;

public final class DeployedProjectHelper {
    private DeployedCompositeService deployedCompositeService;
    private MdDomain mdDomain;

    public DeployedProjectHelper(@NotNull MdDomain mdDomain, @NotNull MDSInstance soaInfraMdsInstance) {
        if (mdDomain == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/DeployedProjectHelper.<init> must not be null");
        }
        if (soaInfraMdsInstance == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/DeployedProjectHelper.<init> must not be null");
        }
        this.deployedCompositeService = null;
        this.mdDomain = null;
        this.deployedCompositeService = new DeployedCompositeService(soaInfraMdsInstance);
        this.mdDomain = mdDomain;
    }

    public Collection<LocalRef<DeployedProject>> getDeployedProjects() throws MetadataException {
        ArrayList<LocalRef<DeployedProject>> publishedProjectList = new ArrayList<LocalRef<DeployedProject>>();
        List<DeployedCompositeModel> deployedCompositeModelList = this.deployedCompositeService.getDeployedComposites();
        for (DeployedCompositeModel deployedCompositeModel : deployedCompositeModelList) {
            LocalRef<DeployedProject> deployedProject;
            if (deployedCompositeModel == null || "retired".equals(deployedCompositeModel.getMode()) || (deployedProject = this.getDeployedProject(deployedCompositeModel)) == null) continue;
            publishedProjectList.add(deployedProject);
        }
        return publishedProjectList;
    }

    public LocalRef<DeployedProject> getDeployedProject(@NotNull CompositeDN compositeDN) throws MetadataException {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/DeployedProjectHelper.getDeployedProject must not be null");
        }
        DeployedCompositeModel compositeModel = this.deployedCompositeService.getDeployedComposite(compositeDN);
        LocalRef<DeployedProject> result = null;
        if (compositeModel != null) {
            result = this.getDeployedProject(compositeModel);
        }
        return result;
    }

    public String getLastDeployedVersion(@NotNull String projectName) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/DeployedProjectHelper.getLastDeployedVersion must not be null");
        }
        List<DeployedCompositeModel> deployedCompositeModelList = this.deployedCompositeService.getDeployedComposites();
        String lastVersion = null;
        Time lastDate = null;
        for (DeployedCompositeModel deployedCompositeModel : deployedCompositeModelList) {
            CompositeNameModel nameModel = deployedCompositeModel.getNameModel();
            if (!projectName.equals(nameModel.getCompositeName())) continue;
            Time time = Time.valueOf((String)deployedCompositeModel.getDeployedTime());
            long microSeconds = time.getMicroSeconds();
            if (lastDate != null && (long)time.getMicroSecond() >= microSeconds) continue;
            lastDate = time;
            lastVersion = nameModel.getRevision();
        }
        return lastVersion == null ? "1.0" : lastVersion;
    }

    private LocalRef<DeployedProject> getDeployedProject(@NotNull DeployedCompositeModel compositeModel) throws MetadataException {
        if (compositeModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/DeployedProjectHelper.getDeployedProject must not be null");
        }
        String dn = compositeModel.getDn();
        CompositeNameModel nameModel = compositeModel.getNameModel();
        String compositeName = nameModel.getCompositeName();
        String location = dn.substring(0, dn.indexOf(compositeName));
        String projectId = DeployedProjectUtil.buildDeployedCompositeName(compositeName, nameModel.getRevision());
        LocalRef<DeployedProject> result = null;
        try {
            result = this.mdDomain.getDeployedProject(location + "/" + projectId);
            if (this.isBpmnProject(result)) {
                DeployedProject deployedProject = result.get();
                deployedProject.setState(compositeModel.getState());
                deployedProject.setCompositeDN(compositeModel.getDn());
                deployedProject.setVersion(nameModel.getRevision());
            } else {
                result = null;
            }
        }
        catch (ProjectNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    private boolean isBpmnProject(@NotNull LocalRef<DeployedProject> result) throws MetadataException {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/DeployedProjectHelper.isBpmnProject must not be null");
        }
        try {
            DeployedProject deployedProject = result.get();
            Project project = deployedProject.getProject().get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            VFileSystem system = loader.getProjectFileSystem().getDataFileSystem();
            return system.createFile("default.bpmn").exists();
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }
}

