/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.security;

import java.util.EnumSet;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.pml.service.security.AbstractRole;
import oracle.bpm.pml.service.security.Privilege;
import org.jetbrains.annotations.NotNull;

public final class SecurityContext {
    private EnumSet<AbstractRole> assignedRoles;
    private EnumSet<Privilege> grantedPrivileges;
    private String principal;
    private String roleName;
    private static final String PLUS = "+";

    public SecurityContext(@NotNull String principal) {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.<init> must not be null");
        }
        this.init(principal, EnumSet.allOf(AbstractRole.class));
    }

    public SecurityContext(@NotNull String principal, @NotNull EnumSet<AbstractRole> roles) {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.<init> must not be null");
        }
        if (roles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.<init> must not be null");
        }
        this.init(principal, roles);
    }

    public EnumSet<AbstractRole> getGlobalRoles() {
        return this.assignedRoles;
    }

    public EnumSet<Privilege> getGrantedPrivileges() {
        return this.grantedPrivileges;
    }

    public boolean hasPrivilege(@NotNull Privilege privilege) {
        if (privilege == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.hasPrivilege must not be null");
        }
        return this.grantedPrivileges.contains(privilege);
    }

    public boolean hasPrivilege(@NotNull EnumSet<Privilege> privileges) {
        if (privileges == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.hasPrivilege must not be null");
        }
        return this.grantedPrivileges.containsAll(privileges);
    }

    public boolean hasRole(@NotNull AbstractRole role) {
        if (role == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.hasRole must not be null");
        }
        return this.assignedRoles.contains(role);
    }

    public void assertPrivilege(@NotNull Privilege privilege) throws MetadataException {
        if (privilege == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.assertPrivilege must not be null");
        }
        if (!this.hasPrivilege(privilege)) {
            throw new MetadataException(MetadataMsg.PERMISSION_DENIED);
        }
    }

    public void assertPrivilege(@NotNull EnumSet<Privilege> privileges) throws MetadataException {
        if (privileges == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.assertPrivilege must not be null");
        }
        if (!this.hasPrivilege(privileges)) {
            throw new MetadataException(MetadataMsg.PERMISSION_DENIED);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPrincipal() {
        String string = this.principal;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/pml/service/security/SecurityContext.getPrincipal must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getRoleName() {
        String string = this.roleName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/pml/service/security/SecurityContext.getRoleName must not return null");
        }
        return string;
    }

    private void init(@NotNull String principalUser, @NotNull EnumSet<AbstractRole> roles) {
        if (principalUser == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.init must not be null");
        }
        if (roles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityContext.init must not be null");
        }
        this.principal = principalUser;
        this.assignedRoles = roles;
        this.grantedPrivileges = EnumSet.noneOf(Privilege.class);
        this.roleName = "";
        for (AbstractRole role : this.assignedRoles) {
            this.grantedPrivileges.addAll(role.getGrantedPrivileges());
            if (this.roleName.length() > 0) {
                this.roleName = this.roleName + PLUS;
            }
            this.roleName = this.roleName + role.name();
        }
    }
}

