/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.pml.service.DeployedProjectService;
import oracle.bpm.pml.service.impl.BaseMetadataService;
import oracle.bpm.pml.service.util.DeployedProjectHelper;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.CompositeDN;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import org.jetbrains.annotations.NotNull;

public final class DeployedProjectServiceImpl
extends BaseMetadataService
implements DeployedProjectService {
    private DeployedProjectHelper deployedProjectHelper;

    @Deprecated
    public DeployedProjectServiceImpl() throws MetadataException {
    }

    public DeployedProjectServiceImpl(@NotNull MDSInstance mdsInstance) throws MetadataException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.<init> must not be null");
        }
        super(mdsInstance);
        this.deployedProjectHelper = new DeployedProjectHelper(this.mdDomain, mdsInstance);
    }

    public DeployedProjectServiceImpl(@NotNull String instanceName) throws MetadataException {
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.<init> must not be null");
        }
        this(MDSInstance.getInstance((String)instanceName));
        this.deployedProjectHelper = new DeployedProjectHelper(this.mdDomain, MDSInstance.getInstance((String)instanceName));
    }

    public DeployedProjectServiceImpl(@NotNull URL mdsConfig) throws MetadataException, MalformedURLException, MDSException {
        if (mdsConfig == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.<init> must not be null");
        }
        this(MdsInstanceInitializer.getMDSInstance(mdsConfig));
        this.deployedProjectHelper = new DeployedProjectHelper(this.mdDomain, MdsInstanceInitializer.getMDSInstance(mdsConfig));
    }

    @Override
    @Deprecated
    public Process findProcess(@NotNull String projectsFolder, @NotNull String projectName, @NotNull String processName) throws MetadataException {
        if (projectsFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        if (processName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        FileProjectRepository repo = new FileProjectRepository();
        repo.setReadOnly(true);
        try {
            File folder = new File(projectsFolder);
            Project project = repo.create(folder.toURI(), projectName);
            repo.open(project);
            Process process = project.findProcess(processName);
            if (process == null) {
                throw MetadataExceptionFactory.createProcessNotFoundException(processName);
            }
            return process;
        }
        catch (ProjectException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Process findProcess(@NotNull String projectLocation, @NotNull String processName) throws MetadataException {
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        if (processName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        LocalRef<DeployedProject> projectLocalRef = this.mdDomain.getDeployedProject(projectLocation);
        DeployedProject deployedProject = projectLocalRef.get();
        Project project = deployedProject.getProject().get();
        Process process = project.findProcess(processName);
        if (process == null) {
            throw MetadataExceptionFactory.createProcessNotFoundException(processName);
        }
        return process;
    }

    @Override
    public Collection<LocalRef<DeployedProject>> getDeployedProjects() throws MetadataException {
        return this.deployedProjectHelper.getDeployedProjects();
    }

    @Override
    public LocalRef<DeployedProject> getDeployedProject(@NotNull CompositeDN compositeDN) throws MetadataException {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.getDeployedProject must not be null");
        }
        return this.deployedProjectHelper.getDeployedProject(compositeDN);
    }

    @Override
    public void releaseCachedProject(@NotNull String projectName) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.releaseCachedProject must not be null");
        }
        this.mdDomain.releaseFromCache(DeployedProject.class, projectName);
    }
}

