/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.deployment;

import java.util.EnumMap;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.NotNull;

public final class DeploymentFault {
    private Throwable exception;
    private EnumMap<FaultTag, String> values;

    DeploymentFault() {
        this.values = new EnumMap(FaultTag.class);
    }

    DeploymentFault(@NotNull Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault.<init> must not be null");
        }
        this();
        this.setException(exception);
    }

    public EnumMap<FaultTag, String> getFaults() {
        return this.values;
    }

    public void setFaultValue(@NotNull FaultTag fault, @NotNull String value) {
        if (fault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault.setFaultValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault.setFaultValue must not be null");
        }
        this.values.put(fault, value);
    }

    public void setException(@NotNull Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault.setException must not be null");
        }
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getFaultValue(@NotNull FaultTag fault) {
        if (fault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault.getFaultValue must not be null");
        }
        return this.values.get((Object)fault);
    }

    public boolean isWarning() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.WARNING.toString().equals(severity);
    }

    public boolean isError() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.ERROR.toString().equals(severity);
    }

    public boolean isFatal() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.FATAL_ERROR.toString().equals(severity);
    }

    public SeverityType getSeverity() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return severity != null ? SeverityType.valueOf(severity) : null;
    }

    public static enum SeverityType {
        FATAL_ERROR,
        ERROR,
        WARNING,
        INFO;

    }

    public static enum FaultTag {
        SEVERITY(new QName("severity")),
        LOCATION(new QName("loc")),
        LINE(new QName("line")),
        COLUMN(new QName("col")),
        FILE(new QName("file")),
        MESSAGE(new QName("msg"));

        private QName tagName;

        private FaultTag(QName name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault$FaultTag.<init> must not be null");
            }
            this.tagName = name;
        }

        QName getTagName() {
            return this.tagName;
        }

        public static FaultTag valueOfId(@NotNull QName name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentFault$FaultTag.valueOfId must not be null");
            }
            FaultTag result = null;
            for (FaultTag tag : FaultTag.values()) {
                if (!tag.getTagName().equals(name)) continue;
                result = tag;
                break;
            }
            return result;
        }
    }
}

