/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.ProjectToDeploy;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.deployment.DeploymentResult;
import oracle.bpm.pml.service.security.SecurityContext;
import oracle.fabric.composite.CompositeDN;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComposerMetadataService {
    public SecurityContext getSecurityContext();

    public <K extends MdProject> MdTree browse(@NotNull Class<K> var1, Predicate<K> var2) throws MetadataException;

    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> var1, @NotNull String var2, boolean var3) throws MetadataException;

    public LocalRef<DraftProject> loadDraft(@NotNull String var1, boolean var2) throws MetadataException;

    public PublicShareProject createPublicShare(@NotNull ProjectFolder var1, @NotNull PublicShareProject var2, @NotNull TemplateProject var3, boolean var4) throws MetadataException;

    public PublicShareProject createProjectFromScratch(@NotNull ProjectFolder var1, @NotNull PublicShareProject var2, boolean var3) throws MetadataException;

    public DraftProject createDraft(@NotNull PublicShareProject var1) throws MetadataException;

    public void updateDraft(@NotNull DraftProject var1) throws MetadataException;

    public void releaseDraft(@NotNull DraftProject var1) throws MetadataException;

    public void deletePublicShare(@NotNull PublicShareProject var1) throws MetadataException;

    public void commitDraft(@NotNull DraftProject var1) throws MetadataException;

    public <T extends MdProject> void createFolder(@NotNull Class<T> var1, @NotNull ProjectFolder var2) throws MetadataException;

    public <T extends MdProject> void deleteFolder(@NotNull Class<T> var1, @NotNull ProjectFolder var2, boolean var3) throws MetadataException;

    public void prepareProjectToDeploy(@NotNull PublicShareProject var1, @NotNull String var2) throws MetadataException;

    public void releaseProjectPendingForDeploy(@NotNull ProjectToDeploy var1) throws MetadataException;

    public MdTree getProjectsPendingForDeploy(@Nullable Predicate<ProjectToDeploy> var1) throws MetadataException;

    public LocalRef<ProjectToDeploy> loadProjectPendingForDeploy(@NotNull String var1, @NotNull String var2) throws MetadataException;

    public DeploymentResult deployProject(@NotNull URL var1, @NotNull String var2, @NotNull String var3, boolean var4, boolean var5, @NotNull ProjectToDeploy var6);

    public DeploymentResult generateSarFile(@NotNull PublicShareProject var1, @NotNull String var2);

    public InputStream getSarFile(@NotNull MdProject var1, @NotNull String var2) throws MetadataException;

    public Collection<LocalRef<DeployedProject>> getDeployedProjects() throws MetadataException;

    public LocalRef<DeployedProject> getDeployedProject(@NotNull CompositeDN var1) throws MetadataException;

    public void releaseLock(@NotNull PublicShareProject var1) throws MetadataException;

    public void acquireLock(@NotNull PublicShareProject var1, @NotNull String var2) throws MetadataException;

    public void updatePublicShareProperties(@NotNull String var1, boolean var2, @Nullable String var3, @Nullable List<String> var4) throws MetadataException;

    public String getLastDeployedVersion(@NotNull String var1) throws MetadataException;
}

