/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.model;

import fuego.papi.Activity;
import fuego.papi.Process;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.bam.model.ActivityProxy;
import oracle.bpm.bam.model.ProcessProxy;
import oracle.bpm.bam.model.SimulationPhotoModel;
import oracle.bpm.bamdata.BAMActivityInfo;
import oracle.bpm.bamdata.BAMProcessInfo;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Time;

public class SimulationDataModel {
    private Map<String, String> consolidatedProcessesByLabel = new HashMap<String, String>();
    private Map<String, List<Process>> deployedProcessesByConsolidatedId = new HashMap<String, List<Process>>();
    private List<Process> papiProcesses = new ArrayList<Process>();
    private Map<String, List<Time>> processesTimesByConsolidatedId = new HashMap<String, List<Time>>();
    private SimulationPhotoModel simulationPhotoModel;

    private SimulationDataModel(SimulationPhotoModel simulationPhotoModel) {
        this.simulationPhotoModel = simulationPhotoModel;
        this.initProcesses(simulationPhotoModel);
    }

    public static SimulationDataModel createSimulationDataModel(SimulationPhotoModel simulationPhotoModel) {
        return new SimulationDataModel(simulationPhotoModel);
    }

    @Deprecated
    public List<BAMProcessInfo> getHistoricalProcessInfo(String consolidatedId, List<Time> times) {
        return Collections.emptyList();
    }

    public Map<String, String> getLabelsForActivitiesForProcess(String processId, List<String> selectedActivitiesIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Activity processesActivity : this.getProcessesActivities(processId)) {
            ActivityProxy activity = (ActivityProxy)processesActivity;
            if (selectedActivitiesIds != null && !selectedActivitiesIds.contains(activity.getActivityName())) continue;
            String activityLabel = activity.getLabel(this.getLocale());
            if (activityLabel == null || activityLabel.equals("")) {
                activityLabel = activity.getDefaultLabel();
            }
            result.put(activity.getActivityName(), activityLabel);
        }
        return result;
    }

    public StringList getProcessActivitiesIds(String processId) {
        List<Activity> processesActivities = this.getProcessesActivities(processId);
        StringList result = StringList.create(processesActivities.size());
        for (Activity activity : processesActivities) {
            result.add(activity.getActivityName());
        }
        return result;
    }

    public BAMProcessInfo getProcessInfo(String processId) {
        assert (processId != null) : "the process cannot be null";
        List<Process> processes = this.getProcesses(processId);
        BAMProcessInfo bamRuntimeTotal = null;
        for (int i = 0; i < processes.size(); ++i) {
            Process process = processes.get(i);
            BAMProcessInfo bamRuntime = (BAMProcessInfo)this.getSimulationPhotoModel().getProcessRuntimeInfoMap().get(process.getId());
            assert (bamRuntime != null);
            if (bamRuntimeTotal == null) {
                bamRuntimeTotal = bamRuntime;
                continue;
            }
            bamRuntime.consolidate((BAMActivityInfo)bamRuntimeTotal);
        }
        return bamRuntimeTotal;
    }

    public String getProcessLabel(String processId) {
        return this.getProcess(processId).getLabelWithOU(this.getLocale());
    }

    public Collection<oracle.bpm.project.model.processes.Process> getProcesses() {
        return this.simulationPhotoModel.getProcessContentInfoMap().values();
    }

    public List<Activity> getProcessesActivities(String processId) {
        ArrayList<Activity> result = new ArrayList<Activity>();
        ArrayList<String> activityIds = new ArrayList<String>();
        for (Process process : this.getProcesses(processId)) {
            for (Activity activity : process.getActivities()) {
                if (activityIds.contains(activity.getActivityName())) continue;
                activityIds.add(activity.getActivityName());
                result.add(activity);
            }
        }
        return result;
    }

    public void setSimulationPhotoModel(SimulationPhotoModel simulationPhotoModel) {
        this.simulationPhotoModel = simulationPhotoModel;
    }

    public SimulationPhotoModel getSimulationPhotoModel() {
        return this.simulationPhotoModel;
    }

    public List<Process> getActiveProcesses() {
        ArrayList<Process> result = new ArrayList<Process>(this.papiProcesses.size());
        for (int i = 0; i < this.papiProcesses.size(); ++i) {
            Process process = this.papiProcesses.get(i);
            if (!process.isActive()) continue;
            result.add(process);
        }
        return result;
    }

    public String getActivityLabel(String processId, String activityId) {
        return this.getActivity(processId, activityId).getLabel(this.getLocale());
    }

    public Map<String, List<Time>> getTimesByProcessId() {
        return Collections.unmodifiableMap(this.processesTimesByConsolidatedId);
    }

    public void addProcess(Process process) {
        this.papiProcesses.add(process);
        String consolidatedId = process.getConsolidatedId();
        this.consolidatedProcessesByLabel.put(process.getLabelWithOU(this.getLocale()), consolidatedId);
        List<Process> deployedProcesses = this.deployedProcessesByConsolidatedId.get(consolidatedId);
        if (deployedProcesses == null) {
            deployedProcesses = new ArrayList<Process>();
            this.deployedProcessesByConsolidatedId.put(consolidatedId, deployedProcesses);
        }
        deployedProcesses.add(process);
        List<Time> processTimes = this.processesTimesByConsolidatedId.get(consolidatedId);
        if (processTimes == null) {
            processTimes = new ArrayList<Time>();
            this.processesTimesByConsolidatedId.put(consolidatedId, processTimes);
        }
    }

    private Activity getActivity(String processId, String activityId) {
        for (Activity processesActivity : this.getProcessesActivities(processId)) {
            if (!processesActivity.getActivityName().equals(activityId)) continue;
            return processesActivity;
        }
        return null;
    }

    private Locale getLocale() {
        oracle.bpm.project.model.processes.Process model = CollectionUtils.first(this.getSimulationPhotoModel().getProcessContentInfoMap().values());
        Locale language = model != null ? model.getProject().getDefaultLanguage() : Locale.getDefault();
        return language;
    }

    private Process getProcess(String processId) {
        List<Process> processes = this.getProcesses(processId);
        return CollectionUtils.first(processes);
    }

    private Time[] getProcessTimes(Process process) {
        return null;
    }

    private List<Process> getProcesses(String consolidatedProcessId) {
        return this.deployedProcessesByConsolidatedId.get(consolidatedProcessId);
    }

    private void initProcesses(SimulationPhotoModel simulationPhotoModel) {
        Map<String, ProcessProxy> processProxyMap = simulationPhotoModel.getProcessProxyMap();
        for (ProcessProxy processProxy : processProxyMap.values()) {
            this.addProcess(processProxy);
        }
    }
}

