/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.model;

import fuego.papi.Activity;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.bam.model.ProcessProxy;
import oracle.bpm.bamdata.BAMProcessInfo;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.processes.Process;

public class PhotoModel {
    private HashMap consolidatedProcessesByLabel;
    private HashMap deployedProcessesByConsolidatedId;
    private ArrayList papiProcesses;
    private final Process process;
    private HashMap processesTimesByConsolidatedId;
    private List processHistoricalInfoList;
    private List processHistoricalInfoTimeList;
    private final ProcessInfo processInfo;
    private final ProcessServiceSession processServiceSession;
    private long timeStamp;

    private PhotoModel(long timeStamp, ProcessServiceSession processServiceSession, Process process, ProcessInfo processInfo) {
        this.timeStamp = timeStamp;
        this.processHistoricalInfoList = new ArrayList();
        this.processHistoricalInfoTimeList = new ArrayList();
        this.papiProcesses = new ArrayList();
        this.consolidatedProcessesByLabel = new HashMap();
        this.processServiceSession = processServiceSession;
        this.process = process;
        this.processInfo = processInfo;
        this.deployedProcessesByConsolidatedId = new HashMap();
        this.processesTimesByConsolidatedId = new HashMap();
    }

    public static PhotoModel createForBAM(ProcessServiceSession processServiceSession) {
        PhotoModel photoModel = new PhotoModel(0L, processServiceSession, null, null);
        return photoModel;
    }

    public static PhotoModel createForSimulation(Process process, ProcessInfo processInfo) {
        assert (process != null);
        assert (processInfo != null);
        PhotoModel photoModel = new PhotoModel(0L, null, process, processInfo);
        ProcessProxy processProxy = new ProcessProxy(process);
        photoModel.addProcess(processProxy);
        return photoModel;
    }

    public ArrayList getActiveProcesses() {
        ArrayList<fuego.papi.Process> result = new ArrayList<fuego.papi.Process>(this.papiProcesses.size());
        for (int i = 0; i < this.papiProcesses.size(); ++i) {
            fuego.papi.Process process = (fuego.papi.Process)this.papiProcesses.get(i);
            if (!process.isActive()) continue;
            result.add(process);
        }
        return result;
    }

    public String getActivityIdByLabel(String processId, String activityLabel) {
        List processesActivities = this.getProcessesActivities(processId);
        for (int i = 0; i < processesActivities.size(); ++i) {
            Activity activity = (Activity)processesActivities.get(i);
            if (!activity.getLabel(this.getLocale()).equals(activityLabel)) continue;
            return activity.getActivityName();
        }
        return null;
    }

    public String getActivityLabel(String processId, String activityId) {
        return this.getActivity(processId, activityId).getLabel(this.getLocale());
    }

    public ArrayList getActivityLabelsForProcess(String processId, List selectedActivitiesIds) {
        ArrayList<String> result = new ArrayList<String>();
        List processesActivities = this.getProcessesActivities(processId);
        for (int i = 0; i < processesActivities.size(); ++i) {
            Activity activity = (Activity)processesActivities.get(i);
            if (selectedActivitiesIds != null && !selectedActivitiesIds.contains(activity.getActivityName())) continue;
            result.add(activity.getLabel(this.getLocale()));
        }
        return result;
    }

    public Map getAllTimes(String consolidatedProcessId) {
        HashMap years = null;
        HashMap months = null;
        HashMap days = null;
        HashMap<String, String> intradays = null;
        long lastTime = 0L;
        int lastYear = 0;
        int lastMonth = 0;
        int lastDay = 0;
        String lastIntradayFormated = "";
        List times = (List)this.getTimesByProcessId().get(consolidatedProcessId);
        int i = 0;
        Time time = (Time)times.get(i);
        years = new HashMap();
        while (i < times.size()) {
            lastYear = time.getYear();
            months = new HashMap();
            while (i < times.size() && time.getYear() == lastYear) {
                lastMonth = time.getMonth();
                days = new HashMap();
                while (i < times.size() && time.getYear() == lastYear && time.getMonth() == lastMonth) {
                    lastDay = time.getDay();
                    intradays = new HashMap<String, String>();
                    while (i < times.size() && time.getYear() == lastYear && time.getMonth() == lastMonth && time.getDay() == lastDay) {
                        String hour = time.getHourOfDay() < 10 ? "0" + time.getHourOfDay() : String.valueOf(time.getHourOfDay());
                        String minute = time.getMinute() < 10 ? "0" + time.getMinute() : String.valueOf(time.getMinute());
                        String second = time.getSecond() < 10 ? "0" + time.getSecond() : String.valueOf(time.getSecond());
                        lastIntradayFormated = hour + ":" + minute + ":" + second;
                        lastTime = time.getMicroSeconds();
                        while (i < times.size() && time.getYear() == lastYear && time.getMonth() == lastMonth && time.getDay() == lastDay && time.getMicroSeconds() == lastTime) {
                            if (++i >= times.size()) continue;
                            time = (Time)times.get(i);
                        }
                        intradays.put(lastIntradayFormated, String.valueOf(lastTime));
                    }
                    days.put(String.valueOf(lastDay), intradays);
                }
                months.put(String.valueOf(lastMonth), days);
            }
            years.put(String.valueOf(lastYear), months);
        }
        return years;
    }

    public String getConsolidatedProcessIdByLabel(String processLabel) {
        return (String)this.consolidatedProcessesByLabel.get(processLabel);
    }

    public List getHistoricalProcessInfo(String consolidatedId, List times) {
        System.out.println("PhotoModel.getHistoricalProcessInfo");
        System.out.println("isSimulation() = " + this.isSimulation());
        System.out.println("consolidatedId = " + consolidatedId);
        System.out.println("times.size() = " + times.size());
        ArrayList result = new ArrayList(times.size());
        if (this.isSimulation() || times.size() == 0) {
            return result;
        }
        System.out.println("result.size() = " + result.size());
        return result;
    }

    public HashMap getLabelsForActivitiesForProcess(String processId, List selectedActivitiesIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        List processesActivities = this.getProcessesActivities(processId);
        for (int i = 0; i < processesActivities.size(); ++i) {
            Activity activity = (Activity)processesActivities.get(i);
            if (selectedActivitiesIds != null && !selectedActivitiesIds.contains(activity.getActivityName())) continue;
            result.put(activity.getActivityName(), activity.getLabel(this.getLocale()));
        }
        return result;
    }

    public List getProcessActivitiesIds(String processId) {
        ArrayList<String> result = new ArrayList<String>();
        List processesActivities = this.getProcessesActivities(processId);
        for (int i = 0; i < processesActivities.size(); ++i) {
            Activity activity = (Activity)processesActivities.get(i);
            result.add(activity.getActivityName());
        }
        return result;
    }

    public List getProcessHistoricalInfoList() {
        return this.processHistoricalInfoList;
    }

    public List getProcessHistoricalInfoTimeList() {
        return this.processHistoricalInfoTimeList;
    }

    public BAMProcessInfo getProcessInfo(String processId) {
        assert (processId != null) : "the process cannot be null";
        if (this.isSimulation()) {
            assert (processId.equals(this.process.getId())) : "this id " + processId + " differs from the process " + this.process.getId();
            return this.processInfo;
        }
        throw new UnsupportedOperationException("BAM NOT SUPPORTED");
    }

    public String getProcessLabel(String processId) {
        return this.getProcess(processId).getLabelWithOU(this.getLocale());
    }

    public ArrayList getProcessLabelsForSelection(List selectedConsolidatedProcessIds) {
        ArrayList<String> result = new ArrayList<String>(this.papiProcesses.size());
        for (int i = 0; i < this.papiProcesses.size(); ++i) {
            fuego.papi.Process process = (fuego.papi.Process)this.papiProcesses.get(i);
            if (!selectedConsolidatedProcessIds.contains(process.getConsolidatedId())) continue;
            result.add(process.getLabel(this.getLocale()));
        }
        return result;
    }

    public List getProcessSnapshotTimes(String processId) {
        List list = (List)this.processesTimesByConsolidatedId.get(processId);
        return list == null ? new ArrayList() : list;
    }

    public ArrayList getProcessesForSelection(List selectedConsolidatedProcessIds) {
        ArrayList<fuego.papi.Process> result = new ArrayList<fuego.papi.Process>(this.papiProcesses.size());
        for (int i = 0; i < this.papiProcesses.size(); ++i) {
            fuego.papi.Process process = (fuego.papi.Process)this.papiProcesses.get(i);
            if (!selectedConsolidatedProcessIds.contains(process.getConsolidatedId())) continue;
            result.add(process);
        }
        return result;
    }

    public List getProcessesLabels() {
        ArrayList<String> result = new ArrayList<String>(this.papiProcesses.size());
        for (int i = 0; i < this.papiProcesses.size(); ++i) {
            fuego.papi.Process process = (fuego.papi.Process)this.papiProcesses.get(i);
            result.add(process.getLabel(this.getLocale()));
        }
        return result;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Map getTimesByProcessId() {
        return Collections.unmodifiableMap(this.processesTimesByConsolidatedId);
    }

    public void addProcess(fuego.papi.Process process) {
        System.out.println("PhotoModel.addProcess");
        System.out.println("process.getId() = " + process.getId());
        this.papiProcesses.add(process);
        String consolidatedId = process.getConsolidatedId();
        this.consolidatedProcessesByLabel.put(process.getLabelWithOU(this.getLocale()), consolidatedId);
        ArrayList<fuego.papi.Process> deployedProcesses = (ArrayList<fuego.papi.Process>)this.deployedProcessesByConsolidatedId.get(consolidatedId);
        if (deployedProcesses == null) {
            deployedProcesses = new ArrayList<fuego.papi.Process>();
            this.deployedProcessesByConsolidatedId.put(consolidatedId, deployedProcesses);
        }
        deployedProcesses.add(process);
        if (this.isSimulation()) {
            return;
        }
        ArrayList<Time> processTimes = (ArrayList<Time>)this.processesTimesByConsolidatedId.get(consolidatedId);
        if (processTimes == null) {
            processTimes = new ArrayList<Time>();
            this.processesTimesByConsolidatedId.put(consolidatedId, processTimes);
        }
        try {
            Time[] bamSnapshotTimes = this.getProcessTimes(process);
            if (bamSnapshotTimes != null) {
                for (int i = 0; i < bamSnapshotTimes.length; ++i) {
                    Time bamSnapshotTime = bamSnapshotTimes[i];
                    System.out.println("bamSnapshotTime = " + bamSnapshotTime);
                    if (processTimes.contains(bamSnapshotTime)) continue;
                    processTimes.add(bamSnapshotTime);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Activity getActivity(String processId, String activityId) {
        List processesActivities = this.getProcessesActivities(processId);
        for (int i = 0; i < processesActivities.size(); ++i) {
            Activity activity = (Activity)processesActivities.get(i);
            if (!activity.getActivityName().equals(activityId)) continue;
            return activity;
        }
        return null;
    }

    private Locale getLocale() {
        if (this.isSimulation()) {
            return this.getProcessContent().getProject().getDefaultLanguage();
        }
        try {
            return this.getPAPISession().participantLocale();
        }
        catch (OperationException e) {
            Log.logWarning(e);
            return Locale.getDefault();
        }
    }

    private ProcessServiceSession getPAPISession() {
        assert (this.processServiceSession != null) : "should only be used on a BAM instance";
        return this.processServiceSession;
    }

    private fuego.papi.Process getProcess(String processId) {
        List processes = this.getProcesses(processId);
        return processes != null && processes.size() > 0 ? (fuego.papi.Process)processes.get(0) : null;
    }

    private Process getProcessContent() {
        assert (this.process != null) : "should only be used on a simulation instance";
        return this.process;
    }

    private Time[] getProcessTimes(fuego.papi.Process process) {
        throw new UnsupportedOperationException("BAM NOT SUPPORTED");
    }

    private List getProcesses(String consolidatedProcessId) {
        return (ArrayList)this.deployedProcessesByConsolidatedId.get(consolidatedProcessId);
    }

    private List getProcessesActivities(String processId) {
        ArrayList<Activity> result = new ArrayList<Activity>();
        ArrayList<String> activityIds = new ArrayList<String>();
        List processes = this.getProcesses(processId);
        for (int i = 0; i < processes.size(); ++i) {
            fuego.papi.Process process = (fuego.papi.Process)processes.get(i);
            Activity[] activities = process.getActivities();
            for (int j = 0; j < activities.length; ++j) {
                Activity activity = activities[j];
                if (activityIds.contains(activity.getActivityName())) continue;
                activityIds.add(activity.getActivityName());
                result.add(activity);
            }
        }
        return result;
    }

    private boolean isSimulation() {
        return this.process != null;
    }
}

