/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import fuego.simulation.SimulationResourceImpl;
import java.util.List;
import oracle.bpm.bam.chartviewer.ResourceCheckTree;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class ResourceCheckTreeNode
extends CheckTreeNode {
    private boolean isRoot;

    public ResourceCheckTreeNode(Object value, Image icon, ResourceCheckTree tree) {
        super(value);
        super.setIcon(icon);
        this.setTree((Tree)tree);
    }

    public static ResourceCheckTreeNode createRootNode(Object value, Image icon, ResourceCheckTree tree) {
        ResourceCheckTreeNode resourceCheckTreeNode = new ResourceCheckTreeNode(value, icon, tree);
        resourceCheckTreeNode.isRoot = true;
        return resourceCheckTreeNode;
    }

    public void setSelected(TreeNode.Selection selection) {
        super.setSelected(selection);
        if (this.isRoot) {
            if (selection == TreeNode.Selection.ALL) {
                this.getTree().selectAllResources();
            } else if (selection == TreeNode.Selection.NONE) {
                this.getTree().getSelectedResources().clear();
            }
        } else if (this.getUserObject() instanceof SimulationResourceImpl) {
            List<SimulationResource> selectedResources = this.getTree().getSelectedResources();
            if (selection == TreeNode.Selection.ALL) {
                if (!selectedResources.contains(this.getUserObject())) {
                    selectedResources.add((SimulationResource)this.getUserObject());
                }
            } else if (selection == TreeNode.Selection.NONE) {
                selectedResources.remove(this.getUserObject());
            }
        }
    }

    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof SimulationResource) {
            SimulationResource simulationResource = (SimulationResource)userObject;
            return simulationResource.getId();
        }
        return userObject.toString();
    }

    public ResourceCheckTree getTree() {
        return (ResourceCheckTree)super.getTree();
    }
}

