/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import oracle.bpm.bam.chartviewer.Chart;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.print.PageFormat;
import oracle.bpm.print.Printable;
import oracle.bpm.print.PrinterException;
import oracle.bpm.ui.UiManager;

public class ReportPrinter
implements Printable {
    private ChartManager chartManager;

    public ReportPrinter(ChartManager chartManager) {
        this.chartManager = chartManager;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        double iPageW = pageFormat.getImageableWidth();
        double iPageH = pageFormat.getImageableHeight();
        if (pageIndex == 0) {
            this.printFitGraphics(iPageW, iPageH, graphics, pageFormat);
        }
        if (pageIndex == 1) {
            this.printFitTable(iPageW, iPageH, graphics, pageFormat);
        }
        return pageIndex == 0 || pageIndex == 1 ? 0 : 1;
    }

    private int getColMaxString(ChartManager chartManager, FontMetrics fontMetrics) {
        int m = 0;
        for (int i = 0; i < chartManager.getTableModel().getColumnCount(); ++i) {
            int current = fontMetrics.stringWidth(chartManager.getTableModel().getColumnName(i));
            if (current <= m) continue;
            m = current;
        }
        return m;
    }

    private int getTitleMaxString(ChartManager chartManager, FontMetrics fontMetrics) {
        int m = 0;
        for (int i = 0; i < chartManager.getTableModel().getRowCount(); ++i) {
            int current = fontMetrics.stringWidth(chartManager.getTableModel().getFormatedValueAt(i, 0).toString());
            if (current <= m) continue;
            m = current;
        }
        return m;
    }

    private void printFitGraphics(Double iPageW, Double iPageH, Graphics g, PageFormat pageFormat) {
        Font fontTitle = UiManager.font((String)"Table.font").bold().scale(1.5f);
        g.setFont(fontTitle);
        g.setForeground(Color.BLACK);
        String title = this.chartManager.getChart().getTitleTopMsg().getString() + " ( " + BamMsg.CHART_TYPE + ": " + this.chartManager.getChartType().getMsg().getString() + " )";
        int titleH = g.getFontMetrics().getHeight();
        int titleW = g.getFontMetrics().stringWidth(title);
        g.drawString(title, (int)((iPageW - (double)titleW) / 2.0), titleH + 5);
        g.translate(0, titleH + 10);
        ((Chart)this.chartManager.getChart()).paintCanvas(g, Dimension.valueOf((int)pageFormat.getWidth(), (int)pageFormat.getHeight() - titleH * 2));
    }

    private void printFitTable(double iPageW, double iPageH, Graphics g, PageFormat pageFormat) {
        Font tableFont = UiManager.font((String)"Table.font");
        Font fontPlain = tableFont.plain();
        Font fontBold = tableFont.bold();
        g.setFont(fontBold);
        g.setForeground(Color.BLACK);
        int fontH = g.getFontMetrics().getHeight();
        Font fontTitle = fontBold.scale(1.5f);
        g.setFont(fontTitle);
        String title = this.chartManager.getChart().getTitleTopMsg().getString();
        int titleH = g.getFontMetrics().getHeight();
        int titleW = g.getFontMetrics().stringWidth(title);
        g.drawString(title, (int)((iPageW - (double)titleW) / 2.0), titleH + 5);
        g.translate(0, titleH + 10);
        int x = 0;
        int y = -2;
        for (int r = 0; r < this.chartManager.getTableModel().getColumnCount(); ++r) {
            g.setFont(fontBold);
            g.drawString(this.chartManager.getTableModel().getColumnName(r), x, y += fontH + 3);
        }
        x = this.getColMaxString(this.chartManager, g.getFontMetrics());
        y = -2;
        g.setFont(fontPlain);
        int maxTitleSize = this.getTitleMaxString(this.chartManager, g.getFontMetrics());
        for (int i = 0; i < this.chartManager.getTableModel().getRowCount(); ++i) {
            for (int j = 0; j < this.chartManager.getTableModel().getColumnCount(); ++j) {
                Object value = this.chartManager.getTableModel().getFormatedValueAt(i, j);
                int deltaX = maxTitleSize + 5 - g.getFontMetrics().stringWidth(value.toString()) - 3;
                g.drawString(value.toString(), x + deltaX, y += fontH + 3);
            }
            y = -2;
            x += maxTitleSize + 5;
        }
    }
}

