/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import oracle.bpm.bam.chartviewer.MatrixEvaluator;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.CostIndicator;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.bamdata.TimeIndicator;
import oracle.bpm.bamdata.UnitIndicator;
import oracle.bpm.lang.Interval;

abstract class MatrixEvaluatorImpl
implements MatrixEvaluator {
    MatrixEvaluatorImpl() {
    }

    public void sort(String indicatorLabel) {
    }

    @Override
    public boolean isEquivalentTo(MatrixEvaluator matrixEvaluator) {
        return this.getColumnCount() == matrixEvaluator.getColumnCount() && this.getRowCount() == matrixEvaluator.getRowCount() && this.sameHeaders(matrixEvaluator);
    }

    protected int compare(Indicator indicator, RunningInfo a, RunningInfo b) {
        if (indicator instanceof UnitIndicator || indicator instanceof CostIndicator) {
            if (indicator.get((BAMRunningInfo)a) instanceof Double) {
                return ((Double)indicator.get((BAMRunningInfo)a)).compareTo((Double)indicator.get((BAMRunningInfo)b));
            }
            return ((Long)indicator.get((BAMRunningInfo)a)).compareTo((Long)indicator.get((BAMRunningInfo)b));
        }
        if (indicator instanceof TimeIndicator) {
            return ((Interval)indicator.get((BAMRunningInfo)a)).compareTo((Interval)indicator.get((BAMRunningInfo)b));
        }
        return 0;
    }

    private boolean sameHeaders(MatrixEvaluator matrixEvaluator) {
        int col = this.getColumnCount();
        for (int i = 0; i < col; ++i) {
            Object thisVal = this.getValueAt(0, i);
            Object otherVal = matrixEvaluator.getValueAt(0, i);
            if (thisVal == null || thisVal.equals(otherVal)) continue;
            return false;
        }
        return true;
    }
}

