/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.List;
import java.util.Map;
import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class LocalizedActivityCheckTreeNode
extends CheckTreeNode {
    private String consolidatedProcessId;

    public LocalizedActivityCheckTreeNode(Map.Entry<String, String> value, Image icon, ActivityCheckTree tree) {
        this(null, value, icon, tree);
    }

    public LocalizedActivityCheckTreeNode(String consolidatedProcessId, Map.Entry<String, String> value, Image icon, ActivityCheckTree tree) {
        super(value);
        this.setIcon(icon);
        this.setTree((Tree)tree);
        this.consolidatedProcessId = consolidatedProcessId;
    }

    public void setSelected(TreeNode.Selection selection) {
        super.setSelected(selection);
        if (this.consolidatedProcessId != null) {
            List<String> selectedActivities = this.getTree().getSelectedActivities(this.consolidatedProcessId);
            Object mapEntry = this.getUserObject();
            if (mapEntry != null) {
                String activityId = (String)mapEntry.getKey();
                if (selection == TreeNode.Selection.ALL) {
                    if (!selectedActivities.contains(activityId)) {
                        selectedActivities.add(activityId);
                    }
                } else if (selection == TreeNode.Selection.NONE) {
                    selectedActivities.remove(activityId);
                }
            }
        }
    }

    public String getText() {
        return (String)this.getUserObject().getValue();
    }

    public void setUserObject(Object userObject) {
        if (!(userObject instanceof Map.Entry)) {
            throw new ClassCastException(userObject.getClass().getName());
        }
        super.setUserObject(userObject);
    }

    public Map.Entry<String, String> getUserObject() {
        return (Map.Entry)super.getUserObject();
    }

    public ActivityCheckTree getTree() {
        return (ActivityCheckTree)super.getTree();
    }
}

