/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bamdata.CostIndicator;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.TimeIndicator;
import oracle.bpm.bamdata.UnitIndicator;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class IndicatorSelections {
    private Map<UnitType, List<Indicator>> selectedIndicators = new HashMap<UnitType, List<Indicator>>();

    public IndicatorSelections() {
        this.initIndicators();
    }

    public IndicatorSelections(@NotNull UnitType unitType) {
        this.initIndicators(unitType);
    }

    public boolean hasSelectedIndicators() {
        for (UnitType unit : UnitType.values()) {
            if (!this.hasSelectedIndicators(unit)) continue;
            return true;
        }
        return false;
    }

    public UnitType getSelectedUnitType() {
        UnitType retVal = UnitType.UNITS;
        for (UnitType unit : UnitType.values()) {
            if (!this.hasSelectedIndicators(unit)) continue;
            retVal = unit;
            break;
        }
        return retVal;
    }

    public List<Indicator> getSelectedIndicators() {
        List<Indicator> retVal = this.getSelectedIndicators(UnitType.UNITS);
        for (UnitType unit : UnitType.values()) {
            List<Indicator> selectedIndicatorsForType = this.getSelectedIndicators(unit);
            if (selectedIndicatorsForType.isEmpty()) continue;
            retVal = selectedIndicatorsForType;
            break;
        }
        return retVal;
    }

    public boolean isSelected(Indicator indicator) {
        return this.getSelectedIndicators(indicator.getUnitType()).contains(indicator);
    }

    public void select(@NotNull Indicator indicator) {
        List<Indicator> selectedIndicators = this.getSelectedIndicators(indicator.getUnitType());
        this.selectIndicator(selectedIndicators, indicator);
    }

    public void selectUnique(@NotNull Indicator indicator) {
        this.resetIndicators();
        this.select(indicator);
    }

    public void unSelect(Indicator indicator) {
        this.getSelectedIndicators(indicator.getUnitType()).remove(indicator);
    }

    public IndicatorSelections clone() {
        IndicatorSelections copy = new IndicatorSelections();
        copy.resetIndicators();
        for (UnitType unitType : UnitType.values()) {
            List<Indicator> selectedIndicatorsForType = this.getSelectedIndicators(unitType);
            copy.selectAllIndicatorsForType(selectedIndicatorsForType, unitType);
        }
        return copy;
    }

    protected void selectAll(@NotNull Collection<? extends Indicator> indicators) {
        UnitType unitType = CollectionUtils.first(indicators).getUnitType();
        this.selectAllIndicatorsForType(indicators, unitType);
    }

    protected void initIndicators() {
        UnitType[] types;
        for (UnitType type : types = UnitType.values()) {
            this.initIndicators(type);
        }
    }

    protected void initIndicators(@NotNull UnitType unitType) {
        switch (unitType) {
            case TIME: {
                this.selectAll(TimeIndicator.DEFAULT_INDICATORS);
                break;
            }
            case UNITS: {
                this.selectAll(UnitIndicator.DEFAULT_INDICATORS);
                break;
            }
            case COST: {
                this.selectAll(CostIndicator.DEFAULT_INDICATORS);
            }
        }
    }

    private List<Indicator> getSelectedIndicators(UnitType indicatorClass) {
        List<Indicator> result = this.selectedIndicators.get(indicatorClass);
        if (result == null) {
            result = new ArrayList<Indicator>();
            this.selectedIndicators.put(indicatorClass, result);
        }
        return result;
    }

    private boolean hasSelectedIndicators(UnitType indicatorClass) {
        return !this.getSelectedIndicators(indicatorClass).isEmpty();
    }

    private void resetIndicators() {
        for (List<Indicator> indicators : this.selectedIndicators.values()) {
            indicators.clear();
        }
    }

    private void selectAllIndicatorsForType(@NotNull Collection<? extends Indicator> indicators, @NotNull UnitType unitType) {
        List<Indicator> selectedIndicators = this.getSelectedIndicators(unitType);
        for (Indicator indicator : indicators) {
            this.selectIndicator(selectedIndicators, indicator);
        }
    }

    private void selectIndicator(@NotNull List<Indicator> selectedIndicators, @NotNull Indicator indicator) {
        if (!selectedIndicators.contains(indicator)) {
            selectedIndicators.add(indicator);
        }
    }
}

