/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.Iterator;
import java.util.List;
import oracle.bpm.bam.chartviewer.MatrixEvaluatorImpl;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.resources.Msg;

class IndicatorMatrixEvaluator
extends MatrixEvaluatorImpl {
    private List columns;
    private boolean rotate;
    private String[] rowNames;
    private RunningInfo[] rows;
    private Msg title;

    public IndicatorMatrixEvaluator(RunningInfo[] shown, Msg title, String[] rowNames, List selectedIndicators, boolean rotate) {
        this.title = title;
        this.rowNames = rowNames;
        this.rows = shown;
        this.columns = selectedIndicators;
        this.rotate = rotate;
    }

    @Override
    public int getColumnCount() {
        if (this.rotate) {
            return this.rows.length + 1;
        }
        return this.columns.size() + 1;
    }

    @Override
    public int getRowCount() {
        if (this.rotate) {
            return this.columns.size() + 1;
        }
        return this.rows.length + 1;
    }

    @Override
    public Object getValueAt(int row, int colum) {
        if (this.rotate && colum > this.rows.length) {
            return this.title;
        }
        if (row == 0 && colum == 0) {
            return this.title;
        }
        if (row == 0) {
            if (this.rotate) {
                return this.rowNames[colum - 1];
            }
            return ((Indicator)this.columns.get(colum - 1)).getString();
        }
        if (colum == 0) {
            if (this.rotate) {
                return ((Indicator)this.columns.get(row - 1)).getString();
            }
            return this.rowNames[row - 1];
        }
        if (this.rotate) {
            return ((Indicator)this.columns.get(row - 1)).get((BAMRunningInfo)this.rows[colum - 1]);
        }
        return ((Indicator)this.columns.get(colum - 1)).get((BAMRunningInfo)this.rows[row - 1]);
    }

    @Override
    public List getSelectedIndicators() {
        return this.columns;
    }

    @Override
    public void sort(String indicatorLabel) {
        if (indicatorLabel != null) {
            Iterator it = this.columns.iterator();
            Indicator indicator = null;
            while (it.hasNext()) {
                Indicator candidate = (Indicator)it.next();
                if (!candidate.getString().equals(indicatorLabel)) continue;
                indicator = candidate;
                break;
            }
            this.sort(indicator);
        }
    }

    private void sort(Indicator indicator) {
        int i = this.rows.length;
        while (--i >= 0) {
            boolean flipped = false;
            for (int j = 0; j < i; ++j) {
                if (this.compare(indicator, this.rows[j], this.rows[j + 1]) >= 0) continue;
                RunningInfo a = this.rows[j];
                String aName = this.rowNames[j];
                this.rows[j] = this.rows[j + 1];
                this.rowNames[j] = this.rowNames[j + 1];
                this.rows[j + 1] = a;
                this.rowNames[j + 1] = aName;
                flipped = true;
            }
            if (flipped) continue;
            return;
        }
    }
}

