/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.Iterator;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.IndicatorsCheckTree;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class IndicatorCheckTreeNode
extends CheckTreeNode {
    private IndicatorSelections indicatorSelections = null;
    private boolean isAllRoot;
    private boolean isUnitRoot;

    public IndicatorCheckTreeNode(Object value, Image icon, IndicatorSelections indicatorSelections, IndicatorsCheckTree tree) {
        super(value);
        super.setIcon(icon);
        this.setTree((Tree)tree);
        this.indicatorSelections = indicatorSelections;
    }

    public IndicatorCheckTreeNode(Object value, Image icon, IndicatorSelections indicatorSelections, IndicatorsCheckTree tree, boolean selected) {
        this(value, icon, indicatorSelections, tree);
        super.setSelected(selected ? TreeNode.Selection.ALL : TreeNode.Selection.NONE);
    }

    public static IndicatorCheckTreeNode createAllRootNode(IndicatorSelections indSelections, IndicatorsCheckTree tree) {
        IndicatorCheckTreeNode unitNode = new IndicatorCheckTreeNode(" ", null, indSelections, tree);
        unitNode.isAllRoot = true;
        return unitNode;
    }

    public static IndicatorCheckTreeNode createUnitRootNode(UnitType unitType, IndicatorSelections indSelections, IndicatorsCheckTree tree) {
        IndicatorCheckTreeNode unitNode = new IndicatorCheckTreeNode(unitType, null, indSelections, tree, false);
        unitNode.isUnitRoot = true;
        return unitNode;
    }

    public void setSelected(TreeNode.Selection selection) {
        if (selection != this.getSelected()) {
            this.getTree().setSelectionReady(false);
            super.setSelected(selection);
            Object userObject = this.getUserObject();
            if (!this.isAllRoot) {
                if (this.isUnitRoot) {
                    if (this.isFullSelected()) {
                        this.addChildren();
                        this.collapseUnits((TreeNode)this);
                    } else if (selection == TreeNode.Selection.NONE) {
                        this.removeChildren();
                    }
                } else if (selection == TreeNode.Selection.ALL) {
                    if (!this.indicatorSelections.isSelected((Indicator)userObject)) {
                        this.indicatorSelections.select((Indicator)userObject);
                        this.collapseUnits((TreeNode)this.getParent());
                    }
                } else if (selection == TreeNode.Selection.NONE) {
                    this.indicatorSelections.unSelect((Indicator)userObject);
                }
                this.getTree().setSelectionReady(true);
            } else if (userObject instanceof UnitType) {
                if (this.isFullSelected()) {
                    this.addChildren();
                    this.collapseUnits((TreeNode)this);
                } else if (selection == TreeNode.Selection.NONE) {
                    this.removeChildren();
                }
            }
        }
    }

    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof Indicator) {
            return ((Indicator)userObject).getString();
        }
        if (userObject instanceof UnitType) {
            return ((UnitType)userObject).getMsg().getString();
        }
        return super.toString();
    }

    public IndicatorsCheckTree getTree() {
        return (IndicatorsCheckTree)super.getTree();
    }

    private void addChildren() {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            TreeNode o = (TreeNode)i$.next();
            IndicatorCheckTreeNode node = (IndicatorCheckTreeNode)o;
            Object userObject = node.getUserObject();
            this.indicatorSelections.select((Indicator)userObject);
        }
    }

    private void removeChildren() {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            TreeNode o = (TreeNode)i$.next();
            IndicatorCheckTreeNode node = (IndicatorCheckTreeNode)o;
            Object userObject = node.getUserObject();
            this.indicatorSelections.unSelect((Indicator)userObject);
        }
    }

    private void collapseUnits(TreeNode treeNode) {
        Tree tree = treeNode.getTree();
        if (!tree.isMultipleSelection()) {
            for (TreeNode node : tree.getRoot()) {
                if (node == treeNode) continue;
                node.setSelected(TreeNode.Selection.NONE);
            }
        }
    }
}

