/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.bam.chartviewer.Chart;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.ChartViewerUtils;
import oracle.bpm.bam.chartviewer.CheckTreePanel;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.ReportPrinter;
import oracle.bpm.bam.chartviewer.ResourceIndicatorSelections;
import oracle.bpm.bam.model.SimulationDataModel;
import oracle.bpm.bam.model.SimulationPhotoModel;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.chart.ChartTypeLabelProvider;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.chart.shared.events.UltraChartEvent;
import oracle.bpm.chart.shared.events.UltraChartEventListener;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.print.PageFormat;
import oracle.bpm.print.Printable;
import oracle.bpm.print.PrinterException;
import oracle.bpm.print.PrinterManager;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBoxMenuItem;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.CheckSelectionChangedEvent;
import oracle.bpm.ui.event.CheckSelectionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionAdapter;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ChartViewer
extends Panel
implements Printable {
    private ActivityDrillButton activityDrillButton;
    private CardLayout cardVisualizationPanelLayout;
    private ChartManager chartManager;
    private Panel chartVisualizationPanel;
    private IndicatorSelections currentIndicatorProvider;
    private ToolBarItem currentXAxis;
    private ToolBarItem currentZAxis;
    private ToolBarItem defaultActivitiesCompositeButton;
    private IndicatorSelections defaultIndicatorProvider;
    private ComboBox drawingTypeCombo;
    private boolean isControlDown;
    private int previousX = -1;
    private ReportPrinter reportPrinter;
    private ResourceIndicatorSelections resourceIndicatorProvider;
    private BaseAction resourcesAxisAction;
    private Label resourcesLabel;
    private UnitType selectedIndicatorType = UnitType.UNITS;
    private BaseAction selectResourcesAction;
    private Table table;
    private ToolBar toolBar;
    private final CheckSelectionListener treeListener = new CheckSelectionListener(){

        public void checkedSelectionChanged(CheckSelectionChangedEvent useless) {
            ChartViewer.this.refresh();
        }
    };
    private static int popUpSeparation = 18;
    private static Dimension popupDimension = Dimension.valueOf(50, 100);
    private static final double ZOOM_IN = 1.1;
    private static final double ZOOM_OUT = 0.9;
    private static final String CARD_CHART = "chart";
    private static final String CARD_TABLE = "table";
    public static final Set<ChartType> CHART_TYPES = EnumSet.of(ChartType.COLUMN_CHART, ChartType.COLUMN_CHART_3D, ChartType.BAR_CHART, ChartType.BAR_CHART_3D, ChartType.HEAT_MAP_CHART_3D);

    public ChartViewer(UiContainer parent) {
        super(parent);
        this.init();
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    public IndicatorSelections getCurrentIndicatorProvider() {
        return this.currentIndicatorProvider;
    }

    public IndicatorSelections getDefaultIndicatorProvider() {
        return this.defaultIndicatorProvider;
    }

    public ResourceIndicatorSelections getResourceIndicatorProvider() {
        return this.resourceIndicatorProvider;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.getReportPrinter().print(graphics, pageFormat, pageIndex);
    }

    public void refresh() {
        this.draw();
    }

    public void setPhotoModel(SimulationPhotoModel simulationPhotoModel) {
        if (simulationPhotoModel == null) {
            return;
        }
        SimulationDataModel simulationDataModel = SimulationDataModel.createSimulationDataModel(simulationPhotoModel);
        this.chartManager.initSelections(simulationDataModel);
        this.chartManager.drill(false);
        this.updateDrillButtons();
    }

    public void setResources(Collection<SimulationResource> resources) {
        this.chartManager.setResources(resources);
    }

    public void simulationStarted() {
        if (!this.toolBar.isEnabled()) {
            this.toolBar.setEnabled(true);
        }
        if (!ChartViewerUtils.areResourcesDefined(this.chartManager)) {
            this.setResourcesToolbarEnabled(false);
            if (this.chartManager.isResourceView()) {
                this.chartManager.setAxis(2, 0);
                this.currentXAxis = this.defaultActivitiesCompositeButton;
                this.currentZAxis = null;
                this.chartManager.setAxis(4, 2);
                this.setCurrentIndicatorProvider();
            }
        } else {
            this.setResourcesToolbarEnabled(true);
        }
    }

    UnitType getVisualizationOption() {
        return this.selectedIndicatorType != null ? this.selectedIndicatorType : UnitType.UNITS;
    }

    private void setResourcesToolbarEnabled(boolean enabled) {
        this.resourcesLabel.setEnabled(enabled);
        this.resourcesAxisAction.setEnabled(enabled);
        this.selectResourcesAction.setEnabled(enabled);
    }

    private ReportPrinter getReportPrinter() {
        if (this.reportPrinter == null) {
            this.reportPrinter = new ReportPrinter(this.chartManager);
        }
        return this.reportPrinter;
    }

    private void init() {
        this.defaultIndicatorProvider = ChartViewerUtils.createDefaultIndicatorSelections();
        this.resourceIndicatorProvider = ChartViewerUtils.createResourceIndicatorSelections();
        this.currentIndicatorProvider = this.defaultIndicatorProvider;
        this.setLayout((Layout)new BorderLayout());
        Panel mainPanel = new Panel((UiContainer)this);
        mainPanel.setLayout((Layout)new BorderLayout());
        this.chartVisualizationPanel = new Panel((UiContainer)mainPanel);
        this.cardVisualizationPanelLayout = new CardLayout();
        this.chartVisualizationPanel.setLayout((Layout)this.cardVisualizationPanelLayout);
        ScrollPane scrollPane = new ScrollPane((UiContainer)this.chartVisualizationPanel);
        Chart chart = new Chart((UiContainer)scrollPane);
        chart.setVisible(false);
        this.chartManager = ChartManager.createForSimulation(chart);
        this.initChartManager();
        chart.setSize(DefaultConstants.D_CHART_SIZE.getWidth(), DefaultConstants.D_CHART_SIZE.getHeight());
        scrollPane.setView((UiComponent)chart);
        this.chartManager.setIndicatorProvider(this.currentIndicatorProvider);
        this.chartManager.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ((Chart)ChartViewer.this.chartManager.getChart()).revalidate();
            }
        });
        this.chartManager.initAxes();
        this.toolBar = this.buildToolBar((UiContainer)mainPanel);
        this.table = new Table((UiContainer)this.chartVisualizationPanel, (TableModel)this.chartManager.getRawTableModel());
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(AutoResizeMode.OFF);
        this.table.setDefaultLabelProvider(Long.class, (LabelProvider)new ValueRenderer());
        this.table.setDefaultLabelProvider(Double.class, (LabelProvider)new ValueRenderer());
        this.table.setDefaultLabelProvider(Interval.class, (LabelProvider)new ValueRenderer());
        this.table.setDefaultColorProvider(Object.class, (ColorProvider)new FlatColorProvider());
        this.table.freezeFirstColumn();
        this.chartVisualizationPanel.add((UiComponent)scrollPane, (Object)CARD_CHART);
        this.chartVisualizationPanel.add((UiComponent)this.table, (Object)CARD_TABLE);
        this.cardVisualizationPanelLayout.show((UiContainer)this.chartVisualizationPanel, CARD_CHART);
        mainPanel.add((UiComponent)this.toolBar, (Object)"North");
        mainPanel.add((UiComponent)this.chartVisualizationPanel, (Object)"Center");
        this.add((UiComponent)mainPanel, "Center");
    }

    private ToolBar buildToolBar(UiContainer parent) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add((UiComponent)this.buildDrawingTypeCombo((UiContainer)toolBar));
        toolBar.addSeparator();
        BaseAction processActivityAxisAction = new BaseAction(BamMsg.CHOOSE_X_AXIS){

            public void actionPerformed(ActionEvent e) {
                ToolBarItem source = (ToolBarItem)e.getSource();
                int view = ChartViewer.this.getChartManager().getChartLevel() == 0 ? 3 : 2;
                PopupMenu popup = ChartViewer.this.createAxisPopup(source.getOwnerWindow(), view, source);
                popup.show((UiComponent)source, 0, source.getHeight());
            }
        };
        BaseAction selectActivitiesAction = new BaseAction(BamMsg.ACTIVITIES_SELECTION){

            public void actionPerformed(ActionEvent e) {
                ToolBarItem source = (ToolBarItem)e.getSource();
                PopUpWindow popup = new PopUpWindow(source.getOwnerWindow());
                CheckTreePanel activitiesCheckTreePanel = ChartViewerUtils.createActivityCheckTreePanel((UiContainer)popup, ChartViewer.this.chartManager, ChartViewer.this.treeListener);
                ChartViewer.this.locatePopUpWindow(source, popup, activitiesCheckTreePanel);
            }
        };
        toolBar.add((UiComponent)Label.create((UiContainer)toolBar, (Msg)BamMsg.ACTIVITIES));
        this.currentXAxis = this.defaultActivitiesCompositeButton = toolBar.add(processActivityAxisAction);
        this.currentXAxis.setToolTipText(BamMsg.CHOOSE_AXIS);
        toolBar.add(selectActivitiesAction);
        toolBar.add((UiComponent)this.initActivityDrillButton((UiContainer)toolBar));
        this.resourcesAxisAction = new BaseAction(BamMsg.CHOOSE_AXIS){

            public void actionPerformed(ActionEvent e) {
                ToolBarItem source = (ToolBarItem)e.getSource();
                PopupMenu popup = ChartViewer.this.createAxisPopup(source.getOwnerWindow(), 1, source);
                popup.show((UiComponent)source, 0, source.getHeight());
            }
        };
        this.selectResourcesAction = new BaseAction(BamMsg.RESOURCES_SELECTION){

            public void actionPerformed(ActionEvent e) {
                ToolBarItem source = (ToolBarItem)e.getSource();
                PopUpWindow popup = new PopUpWindow(source.getOwnerWindow());
                if (!ChartViewerUtils.areResourcesDefined(ChartViewer.this.chartManager)) {
                    MessageDialog.showNotice((Msg)BamMsg.NO_RESOURCES_DEFINED);
                    return;
                }
                CheckTreePanel resourcesCheckTreePanel = ChartViewerUtils.createResourcesCheckTreePanel((UiContainer)popup, ChartViewer.this.chartManager, ChartViewer.this.treeListener);
                popup.add((UiComponent)resourcesCheckTreePanel);
                popup.setSize(popupDimension);
                popup.show(source.getLocationOnScreen().getX(), source.getLocationOnScreen().getY() + popUpSeparation);
            }
        };
        toolBar.addSeparator();
        this.resourcesLabel = Label.create((UiContainer)toolBar, (Msg)BamMsg.RESOURCES);
        toolBar.add((UiComponent)this.resourcesLabel);
        toolBar.add(this.resourcesAxisAction).setToolTipText(BamMsg.CHOOSE_AXIS);
        toolBar.add(this.selectResourcesAction);
        BaseAction selectIndicatorsAction = new BaseAction(BamMsg.INDICATORS_SELECTION){

            public void actionPerformed(ActionEvent e) {
                ToolBarItem source = (ToolBarItem)e.getSource();
                PopUpWindow popup = new PopUpWindow(source.getOwnerWindow());
                CheckSelectionListener treeListener = new CheckSelectionListener(){

                    public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
                        ChartViewer.this.selectedIndicatorType = ChartViewer.this.currentIndicatorProvider.getSelectedUnitType();
                        ChartViewer.this.treeListener.checkedSelectionChanged(event);
                    }
                };
                CheckTreePanel indicatorsCheckTreePanel = ChartViewerUtils.createIndicatorsCheckTreePanel((UiContainer)popup, ChartViewer.this.currentIndicatorProvider, ChartViewer.this.chartManager.isResourceView(), treeListener);
                ChartViewer.this.locatePopUpWindow(source, popup, indicatorsCheckTreePanel);
            }
        };
        toolBar.addSeparator();
        toolBar.add((UiComponent)Label.create((UiContainer)toolBar, (Msg)BamMsg.INDICATORS));
        toolBar.add(selectIndicatorsAction);
        BaseAction printAction = new BaseAction(UIMsg.PRINT){

            public void run() {
                PrinterManager printerManager = new PrinterManager();
                PageFormat pf = printerManager.defaultPage();
                printerManager.setPrintable((Printable)ChartViewer.this, pf);
                if (printerManager.printDialog()) {
                    try {
                        if (ChartViewer.this.chartManager.getChart().getTitleTopMsg() != null) {
                            printerManager.print();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        toolBar.setEnabled(false);
        return toolBar;
    }

    private void locatePopUpWindow(ToolBarItem source, PopUpWindow popup, CheckTreePanel checkTreePanel) {
        popup.setSize(popupDimension);
        popup.add((UiComponent)checkTreePanel);
        popup.show(source.getLocationOnScreen().getX(), source.getLocationOnScreen().getY() + popUpSeparation);
    }

    private PopupMenu createAxisPopup(UiWindow parent, final int type, final ToolBarItem button) {
        PopupMenu popup = new PopupMenu((UiContainer)parent);
        final CheckBoxMenuItem xMenuItem = new CheckBoxMenuItem((UiContainer)popup, BamMsg.CHOOSE_X_AXIS);
        BaseAction xAction = new BaseAction(){

            public void run() {
                if (xMenuItem.isSelected()) {
                    ChartViewer.this.chartManager.setAxis(type, 0);
                    ChartViewer.this.currentXAxis = button;
                    ChartViewer.this.currentZAxis = null;
                    ChartViewer.this.chartManager.setAxis(4, 2);
                    ChartViewer.this.setCurrentIndicatorProvider();
                    ChartViewer.this.refresh();
                    ChartViewer.this.updateDrillButtons();
                }
            }
        };
        xMenuItem.setAction(xAction);
        final CheckBoxMenuItem zMenuItem = new CheckBoxMenuItem((UiContainer)popup, BamMsg.CHOOSE_Z_AXIS);
        BaseAction zAction = new BaseAction(){

            public void run() {
                if (zMenuItem.isSelected()) {
                    ChartViewer.this.chartManager.setAxis(type, 2);
                    ChartViewer.this.currentZAxis = button;
                    ChartViewer.this.currentXAxis = null;
                    ChartViewer.this.chartManager.setAxis(4, 0);
                    ChartViewer.this.setCurrentIndicatorProvider();
                    ChartViewer.this.refresh();
                    ChartViewer.this.updateDrillButtons();
                }
            }
        };
        zMenuItem.setAction(zAction);
        if (this.currentXAxis == null && this.currentZAxis != null && this.currentZAxis == button) {
            xMenuItem.setSelected(false);
            zMenuItem.setSelected(true);
        } else if (this.currentZAxis == null && this.currentXAxis != null && this.currentXAxis == button) {
            xMenuItem.setSelected(true);
            zMenuItem.setSelected(false);
        }
        popup.add((MenuItem)xMenuItem);
        popup.add((MenuItem)zMenuItem);
        return popup;
    }

    private synchronized void draw() {
        Object object = this.drawingTypeCombo.getSelectedItem();
        boolean isChart = object instanceof ChartType;
        if (isChart) {
            ChartType type = (ChartType)object;
            ChartType oldChartType = this.chartManager.getChartType();
            if (oldChartType != type && type.is3D()) {
                this.chartManager.getChart().getTransform3D().setXRotation(62);
                this.chartManager.getChart().getTransform3D().setYRotation(146);
                this.chartManager.getChart().getTransform3D().setZRotation(314);
            }
            ((Chart)this.chartManager.getChart()).setVisible(true);
            this.chartManager.setChartType(type);
            this.cardVisualizationPanelLayout.show((UiContainer)this.chartVisualizationPanel, CARD_CHART);
            this.chartManager.draw();
            this.repaint();
        } else {
            this.chartManager.draw();
            this.repaintTable();
        }
    }

    private void generalUpdate() {
        this.refresh();
        this.updateDrillButtons();
    }

    private void initChartManager() {
        ((Chart)this.chartManager.getChart()).addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int lastX = e.getX();
                if (ChartViewer.this.previousX != -1 && e.isControlDown()) {
                    UiComponent chart = UiComponent.get((Object)ChartViewer.this.chartManager.getChart());
                    Dimension chartSize = chart.getSize();
                    Dimension dim = lastX > ChartViewer.this.previousX ? Dimension.valueOf((int)((double)chartSize.getWidth() * 1.01), (int)((double)chartSize.getHeight() * 1.01)) : Dimension.valueOf((int)((double)chartSize.getWidth() * 0.99), (int)((double)chartSize.getHeight() * 0.99));
                    chart.setSize(dim);
                }
                ChartViewer.this.previousX = lastX;
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ChartViewer.this.isControlDown = e.isControlDown();
                if (ChartViewer.this.isControlDown) {
                    ChartViewer.this.chartManager.drill(false);
                    ChartViewer.this.generalUpdate();
                }
            }
        };
        ((Chart)this.chartManager.getChart()).addMouseListener((MouseListener)mouseAdapter);
        ((Chart)this.chartManager.getChart()).addChartEventListener(new UltraChartEventListener(){

            public void chartDataClicked(UltraChartEvent event) {
                int chartRow = event.getDataPoint().getDataRow();
                int chartColumn = event.getDataPoint().getDataColumn();
                if (ChartViewer.this.isControlDown) {
                    ChartViewer.this.chartManager.drill(false);
                } else if (chartRow == -1) {
                    ChartViewer.this.chartManager.setSort((String)event.getDataPoint().getDataValue());
                } else {
                    if (ChartViewer.this.chartManager.getChartLevel() == 0) {
                        String processId = null;
                        if (ChartViewer.this.chartManager.getAxisForView(3) == 0) {
                            processId = ChartViewer.this.chartManager.getSelectedProcesses().get(chartRow);
                        } else if (ChartViewer.this.chartManager.getAxisForView(3) == 2) {
                            processId = ChartViewer.this.chartManager.getSelectedProcesses().get(chartColumn - 1);
                        }
                        if (processId != null) {
                            ChartViewer.this.chartManager.setCurrentProcess(processId);
                        }
                    }
                    ChartViewer.this.chartManager.drill(true);
                }
                ChartViewer.this.generalUpdate();
            }

            public void chartDataMouseOver(UltraChartEvent e) {
            }

            public void chartDataMouseOut(UltraChartEvent e) {
            }
        });
    }

    private ComboBox buildDrawingTypeCombo(UiContainer parent) {
        ArrayList<ChartType> chartTypes = new ArrayList<ChartType>(CHART_TYPES);
        this.drawingTypeCombo = UiFactory.createMutableComboBox((UiContainer)parent, chartTypes);
        this.drawingTypeCombo.addItem((Object)BamMsg.TABLE);
        this.drawingTypeCombo.setSelectedIndex(0);
        this.drawingTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    ChartViewer.this.refresh();
                    Object object = ChartViewer.this.drawingTypeCombo.getSelectedItem();
                    if (object instanceof ChartType) {
                        ChartType type = (ChartType)object;
                        ((Chart)ChartViewer.this.chartManager.getChart()).setChartType(type);
                        ChartViewer.this.cardVisualizationPanelLayout.show((UiContainer)ChartViewer.this.chartVisualizationPanel, ChartViewer.CARD_CHART);
                        ChartViewer.this.refresh();
                    } else {
                        ChartViewer.this.repaintTable();
                    }
                }
            }
        });
        this.drawingTypeCombo.setToolTipText(BamMsg.CHOOSE_CHART_TYPE);
        this.drawingTypeCombo.setLabelProvider((LabelProvider)new ChartTypeLabelProvider(Image.create((Msg)BamMsg.COLUMN)));
        return this.drawingTypeCombo;
    }

    private void repaintTable() {
        this.chartManager.getTableModel().setInverColumnNames(false);
        this.cardVisualizationPanelLayout.show((UiContainer)this.chartVisualizationPanel, CARD_TABLE);
        this.table.repaint();
    }

    private ActivityDrillButton initActivityDrillButton(UiContainer parent) {
        this.activityDrillButton = new ActivityDrillButton(parent);
        return this.activityDrillButton;
    }

    private BaseAction buildZoomAction(Msg msg, final double factor) {
        return new BaseAction(msg){

            public void run() {
                View3DAppearance view = ChartViewer.this.chartManager.getChart().getTransform3D();
                view.setScale(view.getScale() * (float)factor);
                ChartViewer.this.repaint();
            }
        };
    }

    private void setCurrentIndicatorProvider() {
        IndicatorSelections prevProvider = this.currentIndicatorProvider;
        this.currentIndicatorProvider = this.chartManager.isResourceView() ? this.resourceIndicatorProvider : this.defaultIndicatorProvider;
        this.selectedIndicatorType = this.currentIndicatorProvider.getSelectedUnitType();
        this.chartManager.setIndicatorProvider(this.currentIndicatorProvider);
        if (prevProvider != this.currentIndicatorProvider) {
            this.refresh();
        }
    }

    private void updateDrillButtons() {
        this.activityDrillButton.updateButtons();
    }

    private final class ProcessMenuItem
    extends MenuItem {
        @NotNull
        private final String processId;

        public ProcessMenuItem(@NotNull UiContainer parent, String processId) {
            super(parent, ChartViewer.this.chartManager.getProcessLabelById(processId));
            this.processId = processId;
        }

        @NotNull
        String getProcessId() {
            return this.processId;
        }
    }

    private class ActivityDrillButton
    extends Panel {
        private Button down;
        private Button up;

        public ActivityDrillButton(UiContainer parent) {
            super(parent);
            this.init();
        }

        public void updateButtons() {
            if (ChartViewer.this.chartManager.isFreeDimension(2) && ChartViewer.this.chartManager.isFreeDimension(3)) {
                this.up.setEnabled(false);
                this.down.setEnabled(false);
            } else if (ChartViewer.this.chartManager.getChartLevel() == 0 && !ChartViewer.this.chartManager.isFreeDimension(3)) {
                this.up.setEnabled(false);
                this.down.setEnabled(true);
            } else if (ChartViewer.this.chartManager.getChartLevel() == 1 && !ChartViewer.this.chartManager.isFreeDimension(2)) {
                this.up.setEnabled(true);
                this.down.setEnabled(false);
            } else {
                this.up.setEnabled(false);
                this.down.setEnabled(false);
            }
        }

        private void init() {
            BoxLayout bl = new BoxLayout((UiContainer)this, 0);
            this.setLayout((Layout)bl);
            this.up = new Button((UiContainer)this, BamMsg.DRILLUP, ToolBar.OPTIONS);
            this.down = new Button((UiContainer)this, BamMsg.DRILLDOWN, ToolBar.OPTIONS);
            this.up.setToolTipText(BamMsg.DRILLUP);
            this.down.setToolTipText(BamMsg.DRILLDOWN);
            this.up.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChartViewer.this.chartManager.drill(false);
                    ChartViewer.this.generalUpdate();
                }
            });
            this.down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<String> selectedProcesses = ChartViewer.this.chartManager.getSelectedProcesses();
                    if (selectedProcesses.size() == 1) {
                        ActivityDrillButton.this.drillDown(selectedProcesses.get(0));
                    } else {
                        PopupMenu popup = new PopupMenu((UiContainer)ActivityDrillButton.this.down);
                        for (String processId : selectedProcesses) {
                            final ProcessMenuItem item = new ProcessMenuItem((UiContainer)popup, processId);
                            item.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    ActivityDrillButton.this.drillDown(item.getProcessId());
                                }
                            });
                        }
                        popup.show(e.getSource(), 0, e.getSource().getHeight());
                    }
                }
            });
            this.up.setPreferredSize(Dimension.valueOf(14, 10));
            this.down.setPreferredSize(Dimension.valueOf(14, 10));
            this.up.setBorderPainted(false);
            this.down.setBorderPainted(false);
            this.up.setFocusPainted(false);
            this.down.setFocusPainted(false);
            this.up.setFocusable(false);
            this.down.setFocusable(false);
            this.updateButtons();
            this.add((UiComponent)this.up);
            this.add((UiComponent)this.down);
        }

        private void drillDown(String processId) {
            ChartViewer.this.chartManager.setCurrentProcess(processId);
            ChartViewer.this.chartManager.drill(true);
            ChartViewer.this.generalUpdate();
        }
    }

    private static class ValueRenderer
    extends LabelProvider.Default {
        private ValueRenderer() {
        }

        public String getText(Object element) {
            String text = element.toString();
            if (element instanceof Double) {
                Double dValue = (Double)element;
                element = (double)((int)(dValue * 100.0 + 0.5)) / 100.0;
                text = element.toString();
            } else if (element instanceof Interval) {
                Interval iValue = (Interval)element;
                text = iValue.format(IntervalUnit.YEARS, IntervalUnit.SECONDS);
            }
            return text;
        }
    }

    private static class FlatColorProvider
    extends ColorProvider.Default {
        private FlatColorProvider() {
        }

        public Color getBackground(Object element) {
            return Color.FUEGO_LIGHT_BLUE;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }
}

