/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import fuego.simulation.SimulationResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.bam.chartviewer.ChartConfiguration;
import oracle.bpm.bam.chartviewer.ChartConstants;
import oracle.bpm.bam.chartviewer.ChartInterface;
import oracle.bpm.bam.chartviewer.ChartTableModel;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.MatrixEvaluatorImpl;
import oracle.bpm.bam.chartviewer.NumericTableModel;
import oracle.bpm.bam.model.SimulationDataModel;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bamdata.BAMActivityInfo;
import oracle.bpm.bamdata.BAMProcessInfo;
import oracle.bpm.bamdata.BAMResourceInfo;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.DummyResourceRunningInfo;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.ResourceRunningInfo;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.project.Priority;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class ChartManager
extends ChartConstants {
    private List<Priority> categories;
    private ChartInterface chart;
    private ChartConfiguration chartConfig;
    private int chartLevel = 0;
    private ChartType chartType = ChartType.COLUMN_CHART;
    private int currentAxis = 2;
    private String currentProcessId;
    private int[] currentView = new int[3];
    private SimulationDataModel dataModel;
    private IndicatorSelections indicatorProvider;
    private String indicatorSortLabel;
    private Msg[] labelsBottom;
    private Msg[] labelsTop;
    private ChartTableModel rawTableModel;
    private Collection<SimulationResource> resources = new ArrayList<SimulationResource>();
    private Map<String, List<String>> selectedActivitiesByProcess = new HashMap<String, List<String>>();
    private List<Priority> selectedCategories;
    private Indicator selectedIndicator;
    private List<String> selectedProcesses = new ArrayList<String>();
    private List<SimulationResource> selectedResources = new ArrayList<SimulationResource>();
    private Map<String, List<Time>> selectedTimesByProcessId = new HashMap<String, List<Time>>();
    private ChartTableModel tableModel;
    private int timeLevel = 3;
    private static final String PROCESS_NAME_FOR_ROOT = "ALL";

    private ChartManager(ChartInterface chartInterface) {
        this.chart = chartInterface;
        this.init();
    }

    public static ChartManager createForSimulation(ChartInterface chartInterface) {
        return new ChartManager(chartInterface);
    }

    public List<String> getActivities() {
        return this.dataModel.getProcessActivitiesIds(this.getCurrentProcessId());
    }

    public Map<String, Map<String, String>> getLocalizedActivitiesByProcess() {
        HashMap<String, Map<String, String>> activitiesByProcess = new HashMap<String, Map<String, String>>();
        if (this.dataModel != null) {
            for (Process process : this.dataModel.getProcesses()) {
                String consolidatedId = process.getId();
                Map<String, String> labelsForActivities = this.dataModel.getLabelsForActivitiesForProcess(consolidatedId, null);
                activitiesByProcess.put(consolidatedId, labelsForActivities);
            }
        }
        return activitiesByProcess;
    }

    public Map<String, List<String>> getSelectedActivities() {
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        returnMap.putAll(this.selectedActivitiesByProcess);
        return returnMap;
    }

    public int getAxisForView(int view) {
        for (int i = 0; i < this.currentView.length; ++i) {
            if (this.currentView[i] != view) continue;
            return i;
        }
        return -1;
    }

    public List<Priority> getCategories() {
        if (this.categories == null) {
            Priority[] categoriesValues = Priority.values();
            this.categories = new ArrayList<Priority>(Arrays.asList(categoriesValues));
        }
        return this.categories;
    }

    public ChartInterface getChart() {
        return this.chart;
    }

    public int getChartLevel() {
        return this.chartLevel;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public String getCurrentProcessId() {
        assert (this.dataModel != null);
        if (this.getChartLevel() == 1 && !Str.isEmpty(this.currentProcessId)) {
            return this.currentProcessId;
        }
        if (this.selectedProcesses != null && !this.selectedProcesses.isEmpty()) {
            return this.selectedProcesses.get(0);
        }
        List<fuego.papi.Process> activeProcesses = this.dataModel.getActiveProcesses();
        if (!activeProcesses.isEmpty()) {
            return activeProcesses.get(0).getConsolidatedId();
        }
        return null;
    }

    public SimulationDataModel getDataModel() {
        return this.dataModel;
    }

    @Deprecated
    public List<BAMProcessInfo> getHistoricalProcessInfo(String processId, int timeLevel) {
        StringList processActivities = this.dataModel.getProcessActivitiesIds(processId);
        List<Time> selectedTimes = this.getSelectedHistoricalProcessesTimesByProcessId(processId);
        List<BAMProcessInfo> historicalInfoList = this.dataModel.getHistoricalProcessInfo(processId, selectedTimes);
        BAMProcessInfo consolidatedProcessInfo = null;
        long lastTime = 0L;
        ArrayList<BAMProcessInfo> result = new ArrayList<BAMProcessInfo>();
        for (BAMProcessInfo processInfo : historicalInfoList) {
            switch (timeLevel) {
                case 0: {
                    if (Time.valueOf(processInfo.getFinishTime()).getYear() == Time.valueOf(lastTime).getYear()) break;
                    if (lastTime != 0L) {
                        result.add(consolidatedProcessInfo);
                        consolidatedProcessInfo = null;
                    }
                    lastTime = processInfo.getFinishTime();
                    break;
                }
                case 1: {
                    if (Time.valueOf(processInfo.getFinishTime()).getYear() == Time.valueOf(lastTime).getYear() && Time.valueOf(processInfo.getFinishTime()).getMonth() == Time.valueOf(lastTime).getMonth()) break;
                    if (lastTime != 0L) {
                        result.add(consolidatedProcessInfo);
                        consolidatedProcessInfo = null;
                    }
                    lastTime = processInfo.getFinishTime();
                    break;
                }
                case 2: {
                    if (Time.valueOf(processInfo.getFinishTime()).getYear() == Time.valueOf(lastTime).getYear() && Time.valueOf(processInfo.getFinishTime()).getMonth() == Time.valueOf(lastTime).getMonth() && Time.valueOf(processInfo.getFinishTime()).getDayOfMonth() == Time.valueOf(lastTime).getDayOfMonth()) break;
                    if (lastTime != 0L) {
                        result.add(consolidatedProcessInfo);
                        consolidatedProcessInfo = null;
                    }
                    lastTime = processInfo.getFinishTime();
                    break;
                }
                case 3: {
                    if (lastTime != 0L) {
                        result.add(consolidatedProcessInfo);
                        consolidatedProcessInfo = null;
                    }
                    lastTime = processInfo.getFinishTime();
                }
            }
            consolidatedProcessInfo = processInfo.consolidate(consolidatedProcessInfo, (List)processActivities);
        }
        if (consolidatedProcessInfo != null) {
            result.add(consolidatedProcessInfo);
        }
        return result;
    }

    public IndicatorSelections getIndicatorProvider() {
        return this.indicatorProvider;
    }

    public String getProcessLabelById(String consolidatedProcessId) {
        return this.dataModel.getProcessLabel(consolidatedProcessId);
    }

    public ChartTableModel getRawTableModel() {
        return this.rawTableModel;
    }

    public Collection<SimulationResource> getResources() {
        return this.resources;
    }

    public List<String> getSelectedActivitiesByProcess(String consolidatedProcessId) {
        assert (this.selectedActivitiesByProcess != null) : "selectedActivitiesByProcess is null";
        List<String> list = this.selectedActivitiesByProcess.get(consolidatedProcessId);
        if (list == null) {
            list = new ArrayList<String>();
            this.selectedActivitiesByProcess.put(consolidatedProcessId, list);
        }
        return list;
    }

    public List<String> getSelectedActivitiesOfSelectedProcess() {
        String selectedConsolidatedProcessId = this.getCurrentProcessId();
        if (selectedConsolidatedProcessId != null) {
            return this.getSelectedActivitiesByProcess(selectedConsolidatedProcessId);
        }
        return null;
    }

    public String getSelectedActivityId() {
        List<String> activities = this.getSelectedActivitiesOfSelectedProcess();
        if (activities == null) {
            activities = this.getActivities();
        }
        return CollectionUtils.first(activities);
    }

    public List<Priority> getSelectedCategories() {
        return this.selectedCategories;
    }

    public List<BAMProcessInfo> getSelectedHistoricalProcessConsolidatedByTimeLevel() {
        return this.getHistoricalProcessInfo(this.getCurrentProcessId(), this.timeLevel);
    }

    public List<Time> getSelectedHistoricalProcessesTimesByProcessId(String processId) {
        List<Time> list = this.selectedTimesByProcessId.get(processId);
        if (list == null) {
            list = new ArrayList<Time>();
            this.selectedTimesByProcessId.put(processId, list);
        }
        return list;
    }

    public Indicator getSelectedIndicator() {
        return this.selectedIndicator != null ? this.selectedIndicator : CollectionUtils.first(this.getSelectedIndicators());
    }

    public List<String> getSelectedProcesses() {
        return this.selectedProcesses;
    }

    public List<SimulationResource> getSelectedResources() {
        return this.selectedResources;
    }

    public ChartTableModel getTableModel() {
        return this.tableModel;
    }

    public int getViewForAxis(int axis) {
        return this.currentView[axis];
    }

    public UnitType getSelectedUnitType() {
        return this.indicatorProvider.getSelectedUnitType();
    }

    public void draw() {
        if (this.dataModel != null) {
            int option = this.getSelectedUnitType().ordinal();
            this.chartConfig.setFormatString(axisFormatStrings[option], toolTipFormatStrings[option]);
            this.initLabels();
            this.setUpModel();
            this.sort();
            this.chartConfig.configChart(this.chartType, this.tableModel, this.labelsTop[this.chartLevel], this.labelsBottom[this.timeLevel], this.currentAxis);
        }
    }

    public void drill(boolean drillDown) {
        if (this.currentView[0] == 3 || this.currentView[2] == 3) {
            if (!drillDown) {
                if (this.chartLevel > 0) {
                    --this.chartLevel;
                }
            } else {
                if (this.chartLevel < 1) {
                    ++this.chartLevel;
                }
                if (this.currentView[0] == 3) {
                    this.currentView[0] = 2;
                } else {
                    this.currentView[2] = 2;
                }
            }
        } else if (this.currentView[0] == 2 || this.currentView[2] == 2) {
            if (!drillDown) {
                if (this.chartLevel > 0) {
                    --this.chartLevel;
                }
                if (this.currentView[0] == 2) {
                    this.currentView[0] = 3;
                } else {
                    this.currentView[2] = 3;
                }
            } else if (this.chartLevel < 1) {
                ++this.chartLevel;
            }
        }
    }

    public void initAxes() {
        this.initXAxis();
        this.initYAxis();
        this.initZAxis();
        this.selectedResources = new ArrayList<SimulationResource>();
        this.selectedCategories = Arrays.asList(Priority.values());
        this.selectedProcesses = new ArrayList<String>();
    }

    public void setUpAxesFrom(@NotNull ChartManager sourceChartManager) {
        this.setAxis(sourceChartManager.getViewForAxis(0), 0);
        this.setAxis(sourceChartManager.getViewForAxis(1), 1);
        this.setAxis(sourceChartManager.getViewForAxis(2), 2);
    }

    public void initResourcesFrom(@NotNull ChartManager sourceChartManager) {
        this.setResources(sourceChartManager.getResources());
    }

    public void setUpSelectionsFrom(@NotNull ChartManager sourceChartManager) {
        this.setSelectedResources(new ArrayList<SimulationResource>(sourceChartManager.getSelectedResources()));
        this.setSelectedCategories(new ArrayList<Priority>(sourceChartManager.getSelectedCategories()));
        this.setSelection(sourceChartManager.getSelectedActivities());
    }

    public void initSelections(SimulationDataModel dataModel) {
        assert (dataModel != null) : "dataModel cannot be null";
        this.dataModel = dataModel;
        List<fuego.papi.Process> activeProcesses = dataModel.getActiveProcesses();
        Map<String, List<String>> selection = CollectionUtils.hashMap(activeProcesses.size());
        for (fuego.papi.Process process : activeProcesses) {
            String consolidatedId = process.getConsolidatedId();
            StringList allActivities = dataModel.getProcessActivitiesIds(consolidatedId);
            selection.put(consolidatedId, allActivities);
        }
        this.setSelection(selection);
        ArrayList<SimulationResource> initialSelectedResources = new ArrayList<SimulationResource>();
        for (SimulationResource resource : this.getResources()) {
            initialSelectedResources.add(resource);
        }
        this.setSelectedResources(initialSelectedResources);
        this.setSelectedCategories(this.getCategories());
        this.setSelectedAllHistoricalProcessesTimes();
    }

    public boolean isFreeDimension(int dimension) {
        int xAxisDim = this.getViewForAxis(0);
        int zAxisDim = this.getViewForAxis(2);
        return xAxisDim != dimension && zAxisDim != dimension;
    }

    public boolean isResourceView() {
        return this.currentView[0] == 1 || this.currentView[2] == 1;
    }

    public void setAxis(int selectedView, int axis) {
        this.currentView[axis] = selectedView;
        this.currentAxis = axis;
    }

    public void setCurrentProcess(String currentProcessId) {
        this.currentProcessId = currentProcessId;
    }

    public void setIndicatorProvider(IndicatorSelections indicatorProvider) {
        this.indicatorProvider = indicatorProvider;
    }

    public void setPhotoModel(SimulationDataModel photoModel) {
        this.dataModel = photoModel;
    }

    public void setResources(Collection<SimulationResource> resources) {
        this.resources = resources != null ? resources : new ArrayList();
    }

    public void setSelectedActivities(List<String> selectedActivities) {
        assert (this.selectedProcesses.size() == 1) : "you can use this method when there is only one process selected";
        String selectedConsolidatedProcessId = this.getCurrentProcessId();
        HashMap<String, List<String>> selection = new HashMap<String, List<String>>();
        selection.put(selectedConsolidatedProcessId, selectedActivities != null ? selectedActivities : new ArrayList());
        this.setSelection(selection);
    }

    public void setSelectedCategories(List<Priority> selectedCategories) {
        if (selectedCategories == null) {
            selectedCategories = new ArrayList<Priority>();
        }
        this.selectedCategories = selectedCategories;
    }

    public void setSelectedIndicator(Indicator indicator) {
        this.selectedIndicator = indicator;
    }

    public void setSelectedProcesses(List<String> selectedProcesses) {
        assert (selectedProcesses != null);
        this.selectedProcesses.clear();
        this.selectedProcesses.addAll(selectedProcesses);
    }

    public void setSelectedResources(String[] selectedResources) {
        if (selectedResources != null) {
            Collection<SimulationResource> resourcesList = this.getResources();
            ArrayList<SimulationResource> resourcesToSelect = new ArrayList<SimulationResource>();
            block0: for (SimulationResource resourceModel : resourcesList) {
                for (String selectedResource : selectedResources) {
                    if (!resourceModel.getId().equals(selectedResource)) continue;
                    resourcesToSelect.add(resourceModel);
                    continue block0;
                }
            }
            this.setSelectedResources(resourcesToSelect);
        } else {
            this.setSelectedResources(new ArrayList<SimulationResource>());
        }
    }

    public void setSelectedResources(List<SimulationResource> selectedResources) {
        this.selectedResources = selectedResources != null ? selectedResources : new ArrayList();
    }

    public void setSelection(Map<String, List<String>> selection) {
        this.selectedActivitiesByProcess.clear();
        this.selectedActivitiesByProcess.putAll(selection);
        this.selectedProcesses.clear();
        this.selectedProcesses.addAll(selection.keySet());
    }

    public void setSort(String indicatorLabel) {
        this.indicatorSortLabel = indicatorLabel;
    }

    public void timeLevelDrill(boolean drillDown) {
        if (!drillDown) {
            if (this.timeLevel > 0) {
                --this.timeLevel;
            }
        } else if (this.timeLevel < 3) {
            ++this.timeLevel;
        }
    }

    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    private static String[] getCategoriesLabels(List<Priority> categories) {
        ArrayList<String> result = new ArrayList<String>();
        for (Priority category : categories) {
            result.add(category.getString());
        }
        return result.toArray(new String[result.size()]);
    }

    private String getActivityLabelByProcessId(String consolidatedProcessId, String activity) {
        Map<String, String> activityLabelsForProcess = this.dataModel.getLabelsForActivitiesForProcess(consolidatedProcessId, null);
        return activityLabelsForProcess.get(activity);
    }

    private BAMProcessInfo getBAMProcessInfo(String consolidatedProcessId) {
        return this.dataModel.getProcessInfo(consolidatedProcessId);
    }

    private int getCategoryIndex(Priority categoryName) {
        return this.getCategories().indexOf(categoryName);
    }

    private String[] getCurrentCategoriesLabels() {
        return ChartManager.getCategoriesLabels(this.selectedCategories);
    }

    private List<Indicator> getSelectedIndicators() {
        return this.indicatorProvider.getSelectedIndicators();
    }

    private void setSelectedAllHistoricalProcessesTimes() {
        Map<String, List<Time>> timesByProcessId = this.dataModel.getTimesByProcessId();
        this.selectedTimesByProcessId.clear();
        for (Map.Entry<String, List<Time>> entry : timesByProcessId.entrySet()) {
            this.selectedTimesByProcessId.put(entry.getKey(), entry.getValue());
        }
    }

    private void setUpModel() {
        assert (this.dataModel != null);
        switch (this.currentView[0]) {
            case 3: {
                this.setXProcesses();
                break;
            }
            case 2: {
                this.setXActivities();
                break;
            }
            case 0: {
                this.setXCategories();
                break;
            }
            case 1: {
                this.setXResources();
                break;
            }
            case 4: {
                this.setXIndicators();
                break;
            }
            case 6: {
                this.setXTime(false);
            }
        }
        this.tableModel.setUnitView(this.getSelectedUnitType());
    }

    private void setXActivities() {
        switch (this.currentView[2]) {
            case 4: {
                this.setXActivitiesZIndicators(false);
                break;
            }
            case 0: {
                this.setXActivitiesZCategories(false);
                break;
            }
            case 1: {
                this.setXActivitiesZResources(false);
            }
        }
    }

    private void setXActivitiesTimeZCategories(boolean rotate) {
        if (this.isResourceView()) {
            this.tableModel.reset();
            return;
        }
        String processId = this.getCurrentProcessId();
        String processLabel = this.dataModel.getProcessLabel(processId);
        if (processId == null || processId.isEmpty() || this.selectedCategories.isEmpty()) {
            this.tableModel.reset();
            return;
        }
        List<BAMProcessInfo> list = this.getSelectedHistoricalProcessConsolidatedByTimeLevel();
        BAMProcessInfo[] processHistoryInfo = list.toArray(new BAMProcessInfo[list.size()]);
        if (processHistoryInfo.length >= 0) {
            RunningInfo[][] runningInfoArray = new RunningInfo[processHistoryInfo.length][0];
            Object[] processNameArray = new String[processHistoryInfo.length];
            ArrayList<String> names = new ArrayList<String>();
            String activityName = "";
            for (int i = 0; i < processHistoryInfo.length; ++i) {
                String date = this.formatDateByTimeLevel(processHistoryInfo[i].getFinishTime());
                ArrayList<RunningInfo> infos = new ArrayList<RunningInfo>();
                for (Priority selectedCategory : this.selectedCategories) {
                    RunningInfo consolidatedProcessInfo = this.createConsolidatedActivityInfo((BAMActivityInfo)processHistoryInfo[i]);
                    activityName = this.getSelectedActivityId();
                    BAMActivityInfo activityInfo = processHistoryInfo[i].getActivity(activityName);
                    List<Priority> prevCategories = this.selectedCategories;
                    this.selectedCategories = new ArrayList<Priority>();
                    this.selectedCategories.add(selectedCategory);
                    this.applyCategoryAndResourceFilter(activityInfo).consolidate((BAMRunningInfo)consolidatedProcessInfo);
                    this.selectedCategories = prevCategories;
                    infos.add(consolidatedProcessInfo);
                    if (names.contains(selectedCategory.getString())) continue;
                    names.add(selectedCategory.getString());
                }
                runningInfoArray[i] = infos.toArray(new RunningInfo[0]);
                processNameArray[i] = date;
            }
            Indicator ind = this.getSelectedIndicator();
            this.labelsTop[this.chartLevel] = BamMsg.PROCESS_ACTIVITY_INDICATOR_TITLE(processLabel, activityName, ind.getString());
            this.tableModel.createMatrix(runningInfoArray, BamMsg.ACTIVITIES, processNameArray, names.toArray(new String[0]), ind, rotate);
        }
    }

    private void setXActivitiesTimeZIndicators(boolean rotate) {
        if (this.isResourceView()) {
            this.tableModel.reset();
            return;
        }
        String processId = this.getCurrentProcessId();
        String processLabel = this.dataModel.getProcessLabel(processId);
        if (processId == null || processId.isEmpty()) {
            this.tableModel.reset();
            return;
        }
        List<BAMProcessInfo> list = this.getSelectedHistoricalProcessConsolidatedByTimeLevel();
        BAMProcessInfo[] processHistoryInfo = list.toArray(new BAMProcessInfo[list.size()]);
        if (processHistoryInfo.length >= 0) {
            RunningInfo[] runningInfoArray = new RunningInfo[processHistoryInfo.length];
            String[] processNameArray = new String[processHistoryInfo.length];
            String activityName = "";
            for (int i = 0; i < processHistoryInfo.length; ++i) {
                String date = this.formatDateByTimeLevel(processHistoryInfo[i].getFinishTime());
                RunningInfo consolidatedProcessInfo = this.createConsolidatedActivityInfo((BAMActivityInfo)processHistoryInfo[i]);
                activityName = this.getSelectedActivityId();
                BAMActivityInfo activityInfo = processHistoryInfo[i].getActivity(activityName);
                this.applyCategoryAndResourceFilter(activityInfo).consolidate((BAMRunningInfo)consolidatedProcessInfo);
                runningInfoArray[i] = consolidatedProcessInfo;
                processNameArray[i] = date;
            }
            this.labelsTop[this.chartLevel] = BamMsg.PROCESS_ACTIVITY_TITLE(processLabel, activityName);
            this.tableModel.createMatrix(runningInfoArray, BamMsg.ACTIVITIES, processNameArray, this.getSelectedIndicators(), rotate);
        }
    }

    private void setXActivitiesZCategories(boolean rotate) {
        RunningInfo[][] runningInfoArray = new RunningInfo[this.getSelectedActivitiesOfSelectedProcess().size()][0];
        Object[] activityNameArray = new String[this.getSelectedActivitiesOfSelectedProcess().size()];
        String processId = this.getCurrentProcessId();
        String processLabel = this.dataModel.getProcessLabel(processId);
        BAMProcessInfo processModel = this.getBAMProcessInfo(processId);
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> it = this.getSelectedActivitiesOfSelectedProcess().iterator();
        int i = 0;
        while (it.hasNext()) {
            String activityId = it.next();
            activityNameArray[i] = this.dataModel.getActivityLabel(processId, activityId);
            ArrayList<RunningInfo> infos = new ArrayList<RunningInfo>();
            for (Priority selectedCategory : this.selectedCategories) {
                List<Priority> prevCategories = this.selectedCategories;
                this.selectedCategories = new ArrayList<Priority>();
                this.selectedCategories.add(selectedCategory);
                BAMActivityInfo activityInfo = processModel.getActivity(activityId);
                RunningInfo runningInfo = this.applyCategoryAndResourceFilter(activityInfo);
                runningInfo.setInstancesCompletedCount(activityInfo.getDataByCategory()[this.getCategoryIndex(selectedCategory)].getInstancesCompletedCount());
                runningInfo.setTotalInstancesCompletedCycleTime(activityInfo.getDataByCategory()[this.getCategoryIndex(selectedCategory)].getTotalInstancesCompletedCycleTime());
                infos.add(runningInfo);
                this.selectedCategories = prevCategories;
                if (names.contains(selectedCategory.getString())) continue;
                names.add(selectedCategory.getString());
            }
            runningInfoArray[i] = infos.toArray(new RunningInfo[infos.size()]);
            ++i;
        }
        Indicator indicator = this.getSelectedIndicator();
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_INDICATOR_TITLE(processLabel, indicator.getString());
        this.tableModel.createMatrix(runningInfoArray, BamMsg.ACTIVITIES, activityNameArray, names.toArray(new String[0]), indicator, rotate);
    }

    private void setXActivitiesZIndicators(boolean rotate) {
        String processId = this.getCurrentProcessId();
        String processLabel = this.dataModel.getProcessLabel(processId);
        List<String> selectedActivities = this.getSelectedActivitiesByProcess(processId);
        ArrayList<RunningInfo> runningInfoArray = new ArrayList<RunningInfo>();
        ArrayList<String> processNameArray = new ArrayList<String>();
        Iterator<String> i$ = selectedActivities.iterator();
        while (i$.hasNext()) {
            String selectedActivity;
            String activity = selectedActivity = i$.next();
            BAMActivityInfo activityInfo = this.getBAMProcessInfo(processId).getActivity(activity);
            RunningInfo runningInfo = this.applyCategoryAndResourceFilter(activityInfo);
            int completedInstances = this.selectedCategories.isEmpty() ? activityInfo.getRunningInfo().getInstancesCompletedCount() : 0;
            long processTime = this.selectedCategories.isEmpty() ? activityInfo.getRunningInfo().getTotalInstancesCompletedCycleTime() : 0L;
            for (Priority category : this.selectedCategories) {
                completedInstances += activityInfo.getDataByCategory()[this.getCategoryIndex(category)].getInstancesCompletedCount();
                processTime += activityInfo.getDataByCategory()[this.getCategoryIndex(category)].getTotalInstancesCompletedCycleTime();
            }
            runningInfo.setInstancesCompletedCount(completedInstances);
            runningInfo.setTotalInstancesCompletedCycleTime(processTime);
            runningInfoArray.add(runningInfo);
            processNameArray.add(this.getActivityLabelByProcessId(processId, activity));
        }
        RunningInfo[] runningInfos = runningInfoArray.toArray(new RunningInfo[runningInfoArray.size()]);
        String[] processNames = processNameArray.toArray(new String[processNameArray.size()]);
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_TITLE(processLabel);
        this.tableModel.createMatrix(runningInfos, BamMsg.ACTIVITIES, processNames, this.getSelectedIndicators(), rotate);
    }

    private void setXActivitiesZResources(boolean rotate) {
        if (this.selectedResources == null) {
            return;
        }
        List<String> selectedActivitiesOfSelectedProcess = this.getSelectedActivitiesOfSelectedProcess();
        RunningInfo[][] runningInfoArray = new RunningInfo[selectedActivitiesOfSelectedProcess.size()][0];
        Object[] processNameArray = new String[selectedActivitiesOfSelectedProcess.size()];
        String processId = this.getCurrentProcessId();
        BAMProcessInfo processModel = this.getBAMProcessInfo(processId);
        String processLabel = this.dataModel.getProcessLabel(processId);
        Iterator<String> it = selectedActivitiesOfSelectedProcess.iterator();
        ArrayList<String> resourcesIds = new ArrayList<String>();
        int i = 0;
        while (it.hasNext()) {
            String activity = it.next();
            processNameArray[i] = this.getActivityLabelByProcessId(processId, activity);
            ArrayList<RunningInfo> infos = new ArrayList<RunningInfo>();
            for (SimulationResource selectedResource : this.selectedResources) {
                String resourceId = selectedResource.getId();
                List<SimulationResource> prevResources = this.selectedResources;
                this.selectedResources = new ArrayList<SimulationResource>();
                this.selectedResources.add(selectedResource);
                infos.add(this.applyCategoryAndResourceFilter(processModel.getActivity(activity)));
                this.selectedResources = prevResources;
                if (resourcesIds.contains(resourceId)) continue;
                resourcesIds.add(resourceId);
            }
            runningInfoArray[i] = infos.toArray(new RunningInfo[0]);
            ++i;
        }
        Indicator indicator = this.getSelectedIndicator();
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_INDICATOR_TITLE(processLabel, indicator.getString());
        this.tableModel.createMatrix(runningInfoArray, BamMsg.ACTIVITIES, processNameArray, resourcesIds.toArray(new String[0]), indicator, rotate);
    }

    private void setXActivityTime(boolean rotate) {
        switch (this.currentView[2]) {
            case 4: {
                this.setXActivitiesTimeZIndicators(rotate);
                break;
            }
            case 0: {
                this.setXActivitiesTimeZCategories(rotate);
                break;
            }
        }
    }

    private void setXCategories() {
        switch (this.currentView[2]) {
            case 4: {
                this.setXCategoriesZIndicators(false);
                break;
            }
            case 3: {
                this.setXProcessesZCategories(true);
                break;
            }
            case 2: {
                this.setXActivitiesZCategories(true);
                break;
            }
            case 1: {
                this.setXCategoriesZResources(false);
                break;
            }
            case 6: {
                this.setXTimeZCategories(true);
            }
        }
    }

    private void setXCategoriesZIndicators(boolean rotate) {
        if (this.selectedCategories == null) {
            return;
        }
        String processId = this.getCurrentProcessId();
        BAMProcessInfo processModel = this.getBAMProcessInfo(processId);
        String processLabel = this.dataModel.getProcessLabel(processId);
        RunningInfo[] runningInfoArray = new RunningInfo[this.selectedCategories.size()];
        String[] processNameArray = new String[this.selectedCategories.size()];
        Iterator<Priority> it = this.selectedCategories.iterator();
        int i = 0;
        while (it.hasNext()) {
            Priority category = it.next();
            int categoryIndex = this.getCategoryIndex(category);
            runningInfoArray[i] = this.applyResourceAndActivityFilterForCategory((BAMActivityInfo)processModel, categoryIndex);
            runningInfoArray[i].setInstancesCompletedCount(processModel.getDataByCategory()[categoryIndex].getInstancesCompletedCount());
            runningInfoArray[i].setTotalInstancesCompletedCycleTime(processModel.getDataByCategory()[categoryIndex].getTotalInstancesCompletedCycleTime());
            processNameArray[i] = category.getString();
            ++i;
        }
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_TITLE(processLabel);
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, processNameArray, this.getSelectedIndicators(), rotate);
    }

    private void setXCategoriesZResources(boolean rotate) {
        if (this.selectedCategories == null || this.selectedResources == null) {
            return;
        }
        RunningInfo[][] runningInfoArray = new RunningInfo[this.selectedCategories.size()][0];
        Object[] processNameArray = new String[this.selectedCategories.size()];
        String processId = this.getCurrentProcessId();
        BAMProcessInfo processModel = this.getBAMProcessInfo(processId);
        String processLabel = this.dataModel.getProcessLabel(processId);
        ArrayList<String> names = new ArrayList<String>();
        Iterator<Priority> it = this.selectedCategories.iterator();
        int i = 0;
        while (it.hasNext()) {
            Priority category = it.next();
            processNameArray[i] = category.getString();
            ArrayList<RunningInfo> infos = new ArrayList<RunningInfo>();
            for (SimulationResource selectedResource : this.selectedResources) {
                String resource = selectedResource.getId();
                List<SimulationResource> prevResources = this.selectedResources;
                this.selectedCategories = new ArrayList<Priority>();
                this.selectedCategories.add(category);
                infos.add(this.applyResourceAndActivityFilterForCategory((BAMActivityInfo)processModel, this.getCategoryIndex(category)));
                this.selectedResources = prevResources;
                if (names.contains(resource)) continue;
                names.add(resource);
            }
            runningInfoArray[i] = infos.toArray(new RunningInfo[0]);
            ++i;
        }
        Indicator indicator = this.getSelectedIndicator();
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_INDICATOR_TITLE(processLabel, indicator.getString());
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, processNameArray, names.toArray(new String[0]), indicator, rotate);
    }

    private void setXIndicators() {
        switch (this.currentView[2]) {
            case 3: {
                this.setXProcessesZIndicators(true);
                break;
            }
            case 2: {
                this.setXActivitiesZIndicators(true);
                break;
            }
            case 1: {
                this.setXResourcesZIndicators(true);
                break;
            }
            case 0: {
                this.setXCategoriesZIndicators(true);
                break;
            }
            case 6: {
                this.setXTimeZIndicators(true);
            }
        }
    }

    private void setXProcesses() {
        switch (this.currentView[2]) {
            case 4: {
                this.setXProcessesZIndicators(false);
                break;
            }
            case 0: {
                this.setXProcessesZCategories(false);
                break;
            }
            case 1: {
                this.setXProcessesZResources(false);
            }
        }
    }

    private void setXProcessesTimeZCategories(boolean rotate) {
        String currentProcessId = this.getCurrentProcessId();
        if (this.isResourceView() || currentProcessId == null || this.selectedCategories.size() == 0) {
            this.tableModel.reset();
            return;
        }
        List<BAMProcessInfo> historicalProcessInfo = this.getHistoricalProcessInfo(currentProcessId, this.timeLevel);
        if (historicalProcessInfo.size() == 0) {
            return;
        }
        RunningInfo[][] runningInfoArray = new RunningInfo[historicalProcessInfo.size()][0];
        Object[] dateLabels = new String[historicalProcessInfo.size()];
        List<String> selectedActivities = this.getSelectedActivitiesByProcess(currentProcessId);
        for (int i = 0; i < historicalProcessInfo.size(); ++i) {
            BAMProcessInfo bamProcessInfo = historicalProcessInfo.get(i);
            ArrayList<RunningInfo> runningInfoList = new ArrayList<RunningInfo>();
            for (Priority selectedCategory : this.selectedCategories) {
                ArrayList<Priority> categoryList = new ArrayList<Priority>();
                categoryList.add(selectedCategory);
                RunningInfo consolidatedProcessInfo = this.createConsolidatedProcessInfo((BAMActivityInfo)bamProcessInfo);
                for (String activityId : selectedActivities) {
                    BAMActivityInfo activityInfo = bamProcessInfo.getActivity(activityId);
                    RunningInfo filteredActivityInfo = this.applyCategoryAndResourceFilter(activityInfo, categoryList, this.selectedResources);
                    filteredActivityInfo.consolidate((BAMRunningInfo)consolidatedProcessInfo);
                }
                runningInfoList.add(consolidatedProcessInfo);
            }
            runningInfoArray[i] = runningInfoList.toArray(new RunningInfo[runningInfoList.size()]);
            dateLabels[i] = this.formatDateByTimeLevel(bamProcessInfo.getFinishTime());
        }
        Indicator ind = this.getSelectedIndicator();
        String processLabel = this.dataModel.getProcessLabel(currentProcessId);
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_INDICATOR_TITLE(processLabel, ind.getString());
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, dateLabels, this.getCurrentCategoriesLabels(), ind, rotate);
    }

    private void setXProcessesTimeZIndicators(boolean rotate) {
        if (this.isResourceView()) {
            this.tableModel.reset();
            return;
        }
        String currentProcessId = this.getCurrentProcessId();
        if (currentProcessId == null) {
            this.tableModel.reset();
            return;
        }
        List<BAMProcessInfo> historicalProcessInfo = this.getHistoricalProcessInfo(currentProcessId, this.timeLevel);
        if (historicalProcessInfo.size() == 0) {
            return;
        }
        RunningInfo[] runningInfoArray = new RunningInfo[historicalProcessInfo.size()];
        String[] dateLabels = new String[historicalProcessInfo.size()];
        List<String> selectedActivities = this.getSelectedActivitiesByProcess(currentProcessId);
        for (int i = 0; i < historicalProcessInfo.size(); ++i) {
            BAMProcessInfo bamProcessInfo = historicalProcessInfo.get(i);
            RunningInfo consolidatedProcessInfo = this.createConsolidatedProcessInfo((BAMActivityInfo)bamProcessInfo);
            for (String activityId : selectedActivities) {
                BAMActivityInfo activityInfo = bamProcessInfo.getActivity(activityId);
                RunningInfo filteredActivityInfo = this.applyCategoryAndResourceFilter(activityInfo);
                filteredActivityInfo.consolidate((BAMRunningInfo)consolidatedProcessInfo);
            }
            runningInfoArray[i] = consolidatedProcessInfo;
            dateLabels[i] = this.formatDateByTimeLevel(bamProcessInfo.getFinishTime());
        }
        String processLabel = this.dataModel.getProcessLabel(currentProcessId);
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_TITLE(processLabel);
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, dateLabels, this.getSelectedIndicators(), rotate);
    }

    private void setXProcessesZCategories(boolean rotate) {
        if (this.selectedProcesses == null || this.selectedProcesses.size() == 0 || this.selectedCategories == null || this.selectedCategories.size() == 0) {
            this.tableModel.reset();
            return;
        }
        RunningInfo[][] runningInfoArray = new RunningInfo[this.selectedProcesses.size()][0];
        Object[] processNameArray = new String[this.selectedProcesses.size()];
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> it = this.selectedProcesses.iterator();
        int i = 0;
        while (it.hasNext()) {
            String processId = it.next();
            BAMProcessInfo processInfo = this.getBAMProcessInfo(processId);
            processNameArray[i] = this.getProcessLabelById(processId);
            ArrayList<RunningInfo> infos = new ArrayList<RunningInfo>();
            for (Priority selectedCategory : this.selectedCategories) {
                RunningInfo consolidatedProcessInfo = this.createConsolidatedProcessInfo((BAMActivityInfo)processInfo, selectedCategory);
                for (String activityName : this.getSelectedActivitiesByProcess(processId)) {
                    BAMActivityInfo activityInfo = processInfo.getActivity(activityName);
                    assert (activityInfo != null) : "Activity [" + activityName + "] was not found for " + processId;
                    List<Priority> prevCategories = this.selectedCategories;
                    this.selectedCategories = new ArrayList<Priority>();
                    this.selectedCategories.add(selectedCategory);
                    this.applyCategoryAndResourceFilter(activityInfo).consolidate((BAMRunningInfo)consolidatedProcessInfo);
                    this.selectedCategories = prevCategories;
                }
                infos.add(consolidatedProcessInfo);
                if (names.contains(selectedCategory.getString())) continue;
                names.add(selectedCategory.getString());
            }
            runningInfoArray[i] = infos.toArray(new RunningInfo[0]);
            ++i;
        }
        Indicator ind = this.getSelectedIndicator();
        String processesLabel = processNameArray.length == 1 ? processNameArray[0] : PROCESS_NAME_FOR_ROOT;
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_INDICATOR_TITLE(processesLabel, ind.getString());
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, processNameArray, names.toArray(new String[0]), ind, rotate);
    }

    private void setXProcessesZIndicators(boolean rotate) {
        if (this.selectedProcesses == null || this.selectedProcesses.isEmpty()) {
            this.tableModel.reset();
            return;
        }
        RunningInfo[] runningInfoArray = new RunningInfo[this.selectedProcesses.size()];
        String[] processNameArray = new String[this.selectedProcesses.size()];
        Iterator<String> it = this.selectedProcesses.iterator();
        int i = 0;
        while (it.hasNext()) {
            String consolidatedProcessId = it.next();
            BAMProcessInfo bamProcess = this.getBAMProcessInfo(consolidatedProcessId);
            assert (bamProcess != null) : "no BAM process info for " + consolidatedProcessId;
            RunningInfo consolidatedProcessInfo = this.createConsolidatedProcessInfo((BAMActivityInfo)bamProcess);
            List<String> selectedActivities = this.getSelectedActivitiesByProcess(consolidatedProcessId);
            for (String activityName : selectedActivities) {
                BAMActivityInfo bamActivity = bamProcess.getActivity(activityName);
                assert (bamActivity != null) : "no BAM activity info for " + consolidatedProcessId + " : " + activityName;
                this.applyCategoryAndResourceFilter(bamActivity).consolidate((BAMRunningInfo)consolidatedProcessInfo);
            }
            runningInfoArray[i] = consolidatedProcessInfo;
            processNameArray[i] = this.getProcessLabelById(consolidatedProcessId);
            ++i;
        }
        String processLabel = processNameArray.length == 1 ? processNameArray[0] : PROCESS_NAME_FOR_ROOT;
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_TITLE(processLabel);
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, processNameArray, this.getSelectedIndicators(), rotate);
    }

    private void setXProcessesZResources(boolean rotate) {
        if (this.selectedProcesses == null || this.selectedResources == null || this.selectedProcesses.isEmpty() || this.selectedResources.isEmpty()) {
            this.tableModel.reset();
            return;
        }
        RunningInfo[][] runningInfoArray = new RunningInfo[this.selectedProcesses.size()][0];
        Object[] processNameArray = new String[this.selectedProcesses.size()];
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> it = this.selectedProcesses.iterator();
        int i = 0;
        while (it.hasNext()) {
            String processId = it.next();
            BAMProcessInfo processModel = this.getBAMProcessInfo(processId);
            processNameArray[i] = this.getProcessLabelById(processId);
            ArrayList<RunningInfo> infos = new ArrayList<RunningInfo>();
            for (SimulationResource selectedResource : this.selectedResources) {
                SimulationResourceImpl simulationResourceImpl = (SimulationResourceImpl)selectedResource;
                String resource = simulationResourceImpl.getId();
                RunningInfo consolidatedProcessInfo = this.createConsolidatedProcessInfo((BAMActivityInfo)processModel);
                for (String activityName : this.getSelectedActivitiesByProcess(processId)) {
                    BAMActivityInfo activityInfo = processModel.getActivity(activityName);
                    List<SimulationResource> prevResources = this.selectedResources;
                    this.selectedResources = new ArrayList<SimulationResource>();
                    this.selectedResources.add((SimulationResource)simulationResourceImpl);
                    this.applyCategoryAndResourceFilter(activityInfo).consolidate((BAMRunningInfo)consolidatedProcessInfo);
                    this.selectedResources = prevResources;
                }
                infos.add(consolidatedProcessInfo);
                if (names.contains(resource)) continue;
                names.add(resource);
            }
            runningInfoArray[i] = infos.toArray(new RunningInfo[0]);
            ++i;
        }
        Indicator indicator = this.getSelectedIndicator();
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_INDICATOR_TITLE(processNameArray[0], indicator.getString());
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, processNameArray, names.toArray(new String[0]), indicator, rotate);
    }

    private void setXProcessTime(boolean rotate) {
        switch (this.currentView[2]) {
            case 4: {
                this.setXProcessesTimeZIndicators(rotate);
                break;
            }
            case 0: {
                this.setXProcessesTimeZCategories(rotate);
                break;
            }
        }
    }

    private void setXResources() {
        switch (this.currentView[2]) {
            case 4: {
                this.setXResourcesZIndicators(false);
                break;
            }
            case 3: {
                this.setXProcessesZResources(true);
                break;
            }
            case 2: {
                this.setXActivitiesZResources(true);
                break;
            }
            case 0: {
                this.setXCategoriesZResources(true);
                break;
            }
        }
    }

    private void setXResourcesZIndicators(boolean rotate) {
        if (this.selectedResources == null) {
            return;
        }
        String processId = this.getCurrentProcessId();
        BAMProcessInfo processModel = this.getBAMProcessInfo(processId);
        String processLabel = this.dataModel.getProcessLabel(processId);
        RunningInfo[] runningInfoArray = new RunningInfo[this.selectedResources.size()];
        String[] processNameArray = new String[this.selectedResources.size()];
        Iterator<SimulationResource> resources = this.selectedResources.iterator();
        int i = 0;
        while (resources.hasNext()) {
            String resource = resources.next().getId();
            runningInfoArray[i] = this.applyCategoryAndActivityFilterForResource((BAMActivityInfo)processModel, resource);
            processNameArray[i] = resource;
            ++i;
        }
        this.labelsTop[this.chartLevel] = BamMsg.PROCESS_TITLE(processLabel);
        this.tableModel.createMatrix(runningInfoArray, BamMsg.PROCESS, processNameArray, this.getSelectedIndicators(), rotate);
    }

    private void setXTime(boolean rotate) {
        if (this.chartLevel == 0) {
            this.setXProcessTime(rotate);
        } else {
            this.setXActivityTime(rotate);
        }
    }

    private void setXTimeZCategories(boolean rotate) {
        if (this.chartLevel == 0) {
            this.setXProcessesTimeZCategories(rotate);
        } else {
            this.setXActivitiesTimeZCategories(rotate);
        }
    }

    private void setXTimeZIndicators(boolean rotate) {
        if (this.chartLevel == 0) {
            this.setXProcessesTimeZIndicators(rotate);
        } else {
            this.setXActivitiesTimeZIndicators(rotate);
        }
    }

    private List<RunningInfo> getRunningInfosFromResourceInfo(BAMResourceInfo resourceInfo) {
        ArrayList<RunningInfo> list = new ArrayList<RunningInfo>();
        if (!this.selectedCategories.isEmpty()) {
            for (Priority selectedCategory : this.selectedCategories) {
                list.add((RunningInfo)resourceInfo.getDataByCategory()[this.getCategoryIndex(selectedCategory)]);
            }
        } else {
            list.add((RunningInfo)resourceInfo.getRunningInfo());
        }
        return list;
    }

    private List<RunningInfo> getInfosToConsolidate(BAMActivityInfo activityInfo, String resource) {
        ArrayList<RunningInfo> list = new ArrayList<RunningInfo>();
        List<String> selectedActivities = this.getSelectedActivitiesOfSelectedProcess();
        if (selectedActivities.size() > 0) {
            for (String activityId : selectedActivities) {
                BAMActivityInfo childActivityInfo = activityInfo.getActivity(activityId);
                if (childActivityInfo.containsResourceInfo(resource)) {
                    list.addAll(this.getRunningInfosFromResourceInfo(childActivityInfo.getResourceInfo(resource)));
                    continue;
                }
                if (this.selectedCategories.size() == 0) {
                    list.add((RunningInfo)new DummyResourceRunningInfo(activityInfo.getRun()));
                    continue;
                }
                for (int i = 0; i < this.selectedCategories.size(); ++i) {
                    list.add((RunningInfo)new DummyResourceRunningInfo(activityInfo.getRun()));
                }
            }
        } else if (activityInfo.containsResourceInfo(resource)) {
            list.addAll(this.getRunningInfosFromResourceInfo(activityInfo.getResourceInfo(resource)));
        } else {
            for (int i = 0; i < this.selectedCategories.size(); ++i) {
                list.add((RunningInfo)new DummyResourceRunningInfo(activityInfo.getRun()));
            }
        }
        return list;
    }

    private RunningInfo applyCategoryAndActivityFilterForResource(BAMActivityInfo activityInfo, String resource) {
        List<RunningInfo> infosToConsolidate = this.getInfosToConsolidate(activityInfo, resource);
        ResourceRunningInfo consolidatedRunningInfo = new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0);
        for (RunningInfo runningInfo : infosToConsolidate) {
            runningInfo.consolidate((BAMRunningInfo)consolidatedRunningInfo);
        }
        return consolidatedRunningInfo;
    }

    private RunningInfo applyCategoryAndResourceFilter(BAMActivityInfo activityInfo) {
        return this.applyCategoryAndResourceFilter(activityInfo, this.selectedCategories, this.selectedResources);
    }

    private RunningInfo applyCategoryAndResourceFilter(BAMActivityInfo activityInfo, List<Priority> selectedCategories, List<SimulationResource> selectedResources) {
        assert (activityInfo != null);
        if (!selectedCategories.isEmpty()) {
            RunningInfo consolidatedRunningInfo = this.createConsolidatedActivityInfo(activityInfo);
            for (Priority category : selectedCategories) {
                if (this.isResourceView() && !selectedResources.isEmpty()) {
                    for (SimulationResource selectedResource : selectedResources) {
                        String name = selectedResource.getId();
                        RunningInfo runningInfo = (RunningInfo)(activityInfo.containsResourceInfo(name) ? activityInfo.getResourceInfo(name).getDataByCategory()[this.getCategoryIndex(category)] : new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0));
                        runningInfo.consolidate((BAMRunningInfo)consolidatedRunningInfo);
                    }
                    continue;
                }
                activityInfo.getDataByCategory()[this.getCategoryIndex(category)].consolidate((BAMRunningInfo)consolidatedRunningInfo);
            }
            return consolidatedRunningInfo;
        }
        return this.applyResourceFilter(activityInfo);
    }

    private RunningInfo applyResourceAndActivityFilterForCategory(BAMActivityInfo activityInfo, int categoryIndex) {
        if (this.getSelectedActivitiesOfSelectedProcess() == null) {
            return null;
        }
        if (activityInfo == null) {
            return null;
        }
        if (categoryIndex < 0) {
            return null;
        }
        if (!this.getSelectedActivitiesOfSelectedProcess().isEmpty()) {
            ResourceRunningInfo consolidatedRunningInfo = this.isResourceView() ? new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0) : new RunningInfo(activityInfo.getRun());
            for (String activityId : this.getSelectedActivitiesOfSelectedProcess()) {
                if (this.isResourceView() && !this.selectedResources.isEmpty()) {
                    for (SimulationResource selectedResource : this.selectedResources) {
                        String name = selectedResource.getId();
                        RunningInfo runningInfo = (RunningInfo)(activityInfo.getActivity(activityId).containsResourceInfo(name) ? activityInfo.getActivity(activityId).getResourceInfo(name).getDataByCategory()[categoryIndex] : new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0));
                        runningInfo.consolidate((BAMRunningInfo)consolidatedRunningInfo);
                    }
                    continue;
                }
                activityInfo.getActivity(activityId).getDataByCategory()[categoryIndex].consolidate((BAMRunningInfo)consolidatedRunningInfo);
            }
            return consolidatedRunningInfo;
        }
        if (this.isResourceView() && !this.selectedResources.isEmpty()) {
            ResourceRunningInfo consolidatedRunningInfo = new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0);
            for (SimulationResource selectedResource : this.selectedResources) {
                String name = selectedResource.getId();
                RunningInfo runningInfo = (RunningInfo)(activityInfo.containsResourceInfo(name) ? activityInfo.getResourceInfo(name).getDataByCategory()[categoryIndex] : new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0));
                runningInfo.consolidate((BAMRunningInfo)consolidatedRunningInfo);
            }
            return consolidatedRunningInfo;
        }
        return (RunningInfo)activityInfo.getDataByCategory()[categoryIndex];
    }

    private RunningInfo applyResourceFilter(BAMActivityInfo activityInfo) {
        if (this.isResourceView() && !this.selectedResources.isEmpty()) {
            ResourceRunningInfo consolidatedRunningInfo = new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0);
            for (SimulationResource selectedResource : this.selectedResources) {
                String name = selectedResource.getId();
                RunningInfo runningInfo = (RunningInfo)(activityInfo.containsResourceInfo(name) ? activityInfo.getResourceInfo(name).getRunningInfo() : new ResourceRunningInfo(activityInfo.getRun(), 0, 0.0));
                runningInfo.consolidate((BAMRunningInfo)consolidatedRunningInfo);
            }
            return consolidatedRunningInfo;
        }
        return (RunningInfo)activityInfo.getRunningInfo();
    }

    private RunningInfo createConsolidatedActivityInfo(BAMActivityInfo bamActivityInfo) {
        return this.isResourceView() ? new ResourceRunningInfo(bamActivityInfo.getRun(), 0, 0.0) : new RunningInfo(bamActivityInfo.getRun());
    }

    private RunningInfo createConsolidatedProcessInfo(BAMActivityInfo bamActivityInfo, Priority category) {
        RunningInfo consolidatedProcessInfo;
        if (this.isResourceView()) {
            consolidatedProcessInfo = new ResourceRunningInfo(bamActivityInfo.getRun(), 0, 0.0);
        } else {
            consolidatedProcessInfo = new RunningInfo(bamActivityInfo.getRun());
            consolidatedProcessInfo.setInstancesCompletedCount(bamActivityInfo.getDataByCategory()[this.getCategoryIndex(category)].getInstancesCompletedCount());
            consolidatedProcessInfo.setTotalInstancesCompletedCycleTime(bamActivityInfo.getDataByCategory()[this.getCategoryIndex(category)].getTotalInstancesCompletedCycleTime());
        }
        return consolidatedProcessInfo;
    }

    private RunningInfo createConsolidatedProcessInfo(BAMActivityInfo bamActivityInfo) {
        RunningInfo consolidatedProcessInfo;
        if (this.isResourceView()) {
            consolidatedProcessInfo = new ResourceRunningInfo(bamActivityInfo.getRun(), 0, 0.0);
        } else {
            consolidatedProcessInfo = new RunningInfo(bamActivityInfo.getRun());
            int completedInstances = this.selectedCategories.isEmpty() ? bamActivityInfo.getRunningInfo().getInstancesCompletedCount() : 0;
            long processTime = this.selectedCategories.isEmpty() ? bamActivityInfo.getRunningInfo().getTotalInstancesCompletedCycleTime() : 0L;
            for (Priority category : this.selectedCategories) {
                completedInstances += bamActivityInfo.getDataByCategory()[this.getCategoryIndex(category)].getInstancesCompletedCount();
                processTime += bamActivityInfo.getDataByCategory()[this.getCategoryIndex(category)].getTotalInstancesCompletedCycleTime();
            }
            consolidatedProcessInfo.setInstancesCompletedCount(completedInstances);
            consolidatedProcessInfo.setTotalInstancesCompletedCycleTime(processTime);
        }
        return consolidatedProcessInfo;
    }

    private String formatDateByTimeLevel(long longTime) {
        Time time = Time.valueOf(longTime);
        String date = "";
        switch (this.timeLevel) {
            case 0: {
                date = String.valueOf(time.getYear());
                break;
            }
            case 1: {
                date = time.getYear() + "/" + time.getMonth();
                break;
            }
            case 2: {
                date = time.getYear() + "/" + time.getMonth() + "/" + time.getDayOfMonth();
                break;
            }
            case 3: {
                date = time.getYear() + "/" + time.getMonth() + "/" + time.getDayOfMonth() + " " + time.getHourOfDay() + ":" + time.getMinute() + ":" + time.getSecond();
            }
        }
        return date;
    }

    private void init() {
        if (this.tableModel == null) {
            this.rawTableModel = new ChartTableModel();
            this.tableModel = new NumericTableModel(this.rawTableModel);
        }
        this.chartConfig = new ChartConfiguration(this.chart);
        this.initLabels();
        this.chartConfig.setUpChart();
    }

    private void initLabels() {
        this.labelsTop = new Msg[2];
        this.labelsBottom = new Msg[4];
    }

    private void initXAxis() {
        this.currentView[0] = 3;
    }

    private void initYAxis() {
        this.currentView[1] = 5;
    }

    private void initZAxis() {
        this.currentView[2] = 4;
    }

    private void sort() {
        MatrixEvaluatorImpl matrixEvaluator = (MatrixEvaluatorImpl)this.rawTableModel.getMatrixEvaluator();
        matrixEvaluator.sort(this.indicatorSortLabel);
        this.indicatorSortLabel = null;
    }
}

