/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.bam.chartviewer.CategoryCheckTreeNode;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.project.Priority;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;

public class CategoryCheckTree
extends CheckTree {
    private List<Priority> selectedCategories = null;

    private CategoryCheckTree(UiContainer parent) {
        super(parent);
    }

    private CategoryCheckTree(UiContainer parent, CategoryCheckTreeNode root) {
        this(parent);
        this.setRoot((TreeNode)root);
        this.setShowsRootHandles(true);
    }

    public static CategoryCheckTree createCategoryCheckTree(UiContainer parent) {
        CategoryCheckTree tree = null;
        if (Priority.values().length > 0) {
            CategoryCheckTreeNode categoryRoot = CategoryCheckTreeNode.createRootNode(BamMsg.ALL, null, tree);
            tree = CategoryCheckTree.createCategoryCheckTree(parent, categoryRoot);
            CheckTreeNode rootNode = tree.getRoot();
            ArrayList<Priority> categories = new ArrayList<Priority>();
            ArrayList<CategoryCheckTreeNode> categoryCheckTreeNodes = new ArrayList<CategoryCheckTreeNode>();
            for (Priority category : Priority.values()) {
                categories.add(category);
                categoryCheckTreeNodes.add(new CategoryCheckTreeNode(category, null, tree));
            }
            rootNode.addAll(categoryCheckTreeNodes);
            rootNode.expand();
            tree.selectAllCategories();
            tree.setSelectedCategories(categories);
        }
        return tree;
    }

    public List<Priority> getSelectedCategories() {
        if (this.selectedCategories == null) {
            this.selectedCategories = new ArrayList<Priority>();
        }
        return this.selectedCategories;
    }

    public void setSelectedCategories(List<Priority> categories) {
        CategoryCheckTreeNode root = (CategoryCheckTreeNode)this.getRoot();
        Iterator i$ = root.iterator();
        while (i$.hasNext()) {
            TreeNode treeNode = (TreeNode)i$.next();
            CategoryCheckTreeNode node = (CategoryCheckTreeNode)treeNode;
            if (categories.contains(node.getUserObject())) {
                node.setSelected(TreeNode.Selection.ALL);
                continue;
            }
            node.setSelected(TreeNode.Selection.NONE);
        }
        root.expand();
        this.selectedCategories = categories;
    }

    public void selectAllCategories() {
        List<Priority> selectedCategories = this.getSelectedCategories();
        selectedCategories.clear();
        for (Priority entry : Priority.values()) {
            selectedCategories.add(entry);
        }
    }

    private static CategoryCheckTree createCategoryCheckTree(UiContainer parent, CategoryCheckTreeNode node) {
        return new CategoryCheckTree(parent, node);
    }
}

