/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.List;
import java.util.Map;
import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class ActivityCheckTreeNode
extends CheckTreeNode {
    private String consolidatedProcessId;

    private ActivityCheckTreeNode(String value, Image icon, ActivityCheckTree tree) {
        this(null, value, icon, tree);
    }

    private ActivityCheckTreeNode(String consolidatedProcessId, String value, Image icon, ActivityCheckTree tree) {
        super((Object)value);
        this.setIcon(icon);
        this.setTree((Tree)tree);
        this.consolidatedProcessId = consolidatedProcessId;
    }

    public static ActivityCheckTreeNode createRootNode(Image icon, ActivityCheckTree tree) {
        return new ActivityCheckTreeNode(BamMsg.ALL.getString(), icon, tree);
    }

    public static ActivityCheckTreeNode createProcessNode(String processId, Image icon, ActivityCheckTree tree) {
        return new ActivityCheckTreeNode(processId, processId, icon, tree);
    }

    public void setSelected(TreeNode.Selection selection) {
        super.setSelected(selection);
        if (this.consolidatedProcessId != null) {
            Map<String, List<String>> activitiesByProcess = this.getTree().getSelectedActivitiesByProcess();
            if (selection == TreeNode.Selection.ALL) {
                this.getTree().selectAllActivitiesByProcessFor(this.consolidatedProcessId);
            } else if (selection == TreeNode.Selection.NONE) {
                activitiesByProcess.remove(this.consolidatedProcessId);
            }
        } else if (selection == TreeNode.Selection.ALL) {
            this.getTree().selectAllActivitiesByProcess();
        } else if (selection == TreeNode.Selection.NONE) {
            this.getTree().getSelectedActivitiesByProcess().clear();
        }
    }

    public ActivityCheckTree getTree() {
        return (ActivityCheckTree)super.getTree();
    }

    public void setUserObject(Object userObject) {
        if (!(userObject instanceof String)) {
            throw new ClassCastException(userObject.getClass().getName());
        }
        super.setUserObject(userObject);
    }

    public String getUserObject() {
        return (String)super.getUserObject();
    }
}

