/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.bpm.bam.EventLogModel;
import oracle.bpm.bam.EventLogReader;

public class EventLogSimulationReader
implements EventLogReader {
    private BufferedReader bufferedReader = null;
    private File eventLogFile = null;
    private String eventLogString = null;
    private FileReader fileReader = null;
    private StringTokenizer st = null;

    public EventLogSimulationReader(File eventLogFile) {
        this.eventLogFile = eventLogFile;
    }

    public EventLogSimulationReader(String eventLogString) {
        this.eventLogString = eventLogString;
    }

    @Override
    public EventLogModel nextEvent() throws IOException {
        String line = null;
        line = this.readLine();
        if (line == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line, ";");
        EventLogModel elm = new EventLogModel();
        elm.setProcessId(st.nextToken());
        elm.setInstanceId(Long.getLong(st.nextToken()));
        elm.setInstanceCreationTime(Long.getLong(st.nextToken()));
        elm.setTimeStamp(Long.getLong(st.nextToken()));
        elm.setType(Long.getLong(st.nextToken()));
        elm.setActivityFrom(st.nextToken());
        elm.setActivityTo(st.nextToken());
        return elm;
    }

    private String readFileLine() throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new FileReader(this.eventLogFile);
        }
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(this.fileReader);
        }
        return this.bufferedReader.readLine();
    }

    private String readLine() throws IOException {
        if (this.eventLogString != null) {
            return this.readStringLine();
        }
        if (this.eventLogFile != null) {
            return this.readFileLine();
        }
        return null;
    }

    private String readStringLine() {
        if (this.st == null) {
            this.st = new StringTokenizer(this.eventLogString, "\n");
        }
        if (this.st.hasMoreTokens()) {
            return this.st.nextToken();
        }
        return null;
    }
}

