/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.Collection;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;

public class SimulationChecker
extends ProjectObjectChecker {
    private final ProjectSimulation simulation;

    public SimulationChecker(ProjectSimulation simulation, ProjectMessageListener listener) {
        super(listener);
        this.simulation = simulation;
    }

    @Override
    public void check() {
        Collection<SimulationResource> resources = this.simulation.getResources();
        for (SimulationResource resource : resources) {
            if (resource.getName() == null || resource.getName().equals("")) {
                this.reportError(this.simulation, new ModelException((ProjectObject)this.simulation, ProjectCompileMsg.SIMULATION_INVALID_RESOURCE_NAME(resource.getId())));
            }
            if (resource.getRoles().length == 0) {
                this.reportError(this.simulation, new ModelException((ProjectObject)this.simulation, ProjectCompileMsg.NO_ROLES_FOR_SIMULATION_RESOURCE(resource.getId())));
            }
            if (resource.getEfficiency() > 100.0 || resource.getEfficiency() < 0.0) {
                this.reportError(this.simulation, new ModelException((ProjectObject)this.simulation, ProjectCompileMsg.SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR(resource.getId())));
            }
            if (resource.getAvailability() <= 100 && resource.getAvailability() >= 0) continue;
            this.reportError(this.simulation, new ModelException((ProjectObject)this.simulation, ProjectCompileMsg.SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR(resource.getId())));
        }
        double[] categoryProbalities = this.simulation.getCategoryProbabilities();
        double sum = 0.0;
        for (double c : categoryProbalities) {
            sum += c;
        }
        if (sum > 1.0) {
            this.reportError(this.simulation, new ModelException((ProjectObject)this.simulation, ProjectCompileMsg.SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR(this.simulation.getId())));
        }
    }
}

