/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.bpm.cil.CilException;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.lib.InvalidXPathExpression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.SimpleCompiler;
import oracle.bpm.project.compile.XPathCompiler;
import oracle.bpm.project.compile.XPathCompilerResult;
import oracle.bpm.project.compile.XPathReferenceResult;
import oracle.bpm.project.compile.XPathReferencesParser;
import oracle.bpm.project.compile.exceptions.InvalidExpressionException;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

public class ExpressionHelper {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final String SIMPLE_MODE_SEPARATOR = ".";

    private ExpressionHelper() {
    }

    @Deprecated
    public static Expression createSimpleExpression(@NotNull String expressionString, @NotNull DataDeclarationContainer context) {
        return ExpressionHelper.createSimpleExpression(expressionString, context, null, null);
    }

    @Deprecated
    public static Expression createSimpleExpression(@NotNull String expressionString, @NotNull DataAssociationSet dataAssociationSet, @NotNull DataAssociationItemEndpoint endPoint) {
        return ExpressionHelper.createSimpleExpression(expressionString, dataAssociationSet.getContextProvider(endPoint).getDataDeclarationContainer(), null, null);
    }

    public static Expression createSimpleExpression(@NotNull String expressionString, @NotNull DataDeclarationContainer context, CatalogType resultType, Map<String, URI> usedNamespaces) {
        InvalidXPathExpression result = new InvalidXPathExpression(expressionString);
        try {
            XPathCompilerResult xpathResult = ExpressionHelper.getXPathGeneratorResult(expressionString, context, resultType, usedNamespaces);
            result = xpathResult.expression;
        }
        catch (CilException e) {
            // empty catch block
        }
        result.setMode(ExpressionMode.SIMPLE);
        return result;
    }

    public static Expression createTextExpression(@NotNull String text) {
        String xpathExpressionString = XPathCompiler.makeLiteral(text);
        XPathExpression result = new XPathExpression(xpathExpressionString);
        result.setMode(ExpressionMode.TEXT);
        return result;
    }

    public static Expression createTextExpression(@NotNull XPathExpression xPathExpression) {
        XPathExpression result = null;
        String literal = SimpleCompiler.makeLiteral(xPathExpression.getExpressionValue());
        if (!Str.isEmpty((String)literal)) {
            result = new XPathExpression(xPathExpression.getExpressionValue(), xPathExpression.getNamespaces());
            result.setMode(ExpressionMode.TEXT);
        }
        return result;
    }

    public static String getLiteralText(@NotNull Expression expression) {
        String result = null;
        if (expression.getMode() == ExpressionMode.TEXT) {
            result = SimpleCompiler.makeLiteral(expression.getExpressionValue());
        }
        return result;
    }

    public static Expression convertExpression(@NotNull XPathExpression xPathExpression, @NotNull DataDeclarationContainer context, CatalogType resultType, @NotNull ExpressionMode mode) {
        XPathExpression result = null;
        if (xPathExpression.getMode() == mode) {
            result = xPathExpression;
        } else if (mode == ExpressionMode.SIMPLE) {
            result = ExpressionHelper.createSimpleExpression(xPathExpression, context, resultType);
        } else if (mode == ExpressionMode.XPATH) {
            result = ExpressionHelper.createXPathExpression(xPathExpression);
        } else if (mode == ExpressionMode.TEXT) {
            result = ExpressionHelper.createTextExpression(xPathExpression);
        }
        return result;
    }

    public static Expression createSimpleExpression(@NotNull XPathExpression xPathExpression, @NotNull DataDeclarationContainer context, CatalogType resultType) {
        InvalidXPathExpression result = new InvalidXPathExpression(xPathExpression.getExpressionValue());
        try {
            String simpleResult = ExpressionHelper.getSimpleGeneratorResult(xPathExpression, context, resultType);
            if (!Str.isEmpty((String)simpleResult)) {
                result = new XPathExpression(xPathExpression.getExpressionValue(), xPathExpression.getNamespaces());
            }
        }
        catch (CilException e) {
            // empty catch block
        }
        result.setMode(ExpressionMode.SIMPLE);
        return result;
    }

    public static Expression createXPathExpression(@NotNull XPathExpression xPathExpression) {
        return new XPathExpression(xPathExpression.getExpressionValue(), xPathExpression.getNamespaces());
    }

    public static Expression createExpressionFromParts(@NotNull ExpressionMode expressionMode, @NotNull Sequence<DataDeclaration> parts, @NotNull DataDeclarationContainer context, CatalogType resultType, Map<String, URI> usedNamespaces) {
        String simpleQuery = ExpressionHelper.buildSimpleQueryString(parts);
        InvalidXPathExpression result = new InvalidXPathExpression(simpleQuery);
        if (expressionMode.equals((Object)ExpressionMode.SIMPLE)) {
            result = ExpressionHelper.createSimpleExpression(simpleQuery, context, resultType, usedNamespaces);
        } else if (expressionMode.equals((Object)ExpressionMode.XPATH)) {
            result = ExpressionHelper.createSimpleExpression(simpleQuery, context, resultType, usedNamespaces);
            result.setMode(ExpressionMode.XPATH);
        }
        return result;
    }

    public static boolean isQuery(@NotNull Expression expression, @NotNull DataDeclarationContainer context) {
        boolean result = false;
        XPathExpression xPathexpression = (XPathExpression)expression;
        try {
            String simpleResult = ExpressionHelper.getSimpleGeneratorResult(xPathexpression, context, null);
            if (!Str.isEmpty((String)simpleResult)) {
                XPathCompilerResult xpathResult = ExpressionHelper.getXPathGeneratorResult(simpleResult, context, null, null);
                result = !xpathResult.isComplex();
            }
        }
        catch (CilException e) {
            // empty catch block
        }
        return result;
    }

    public static boolean isExpressionValid(@NotNull Expression expression, @NotNull DataDeclarationContainer context, CatalogType typeToValidate) {
        boolean result = false;
        try {
            ExpressionHelper.validateExpression(expression, context, typeToValidate);
            result = true;
        }
        catch (InvalidExpressionException e) {
            // empty catch block
        }
        return result;
    }

    public static void validateExpression(@NotNull Expression expression, @NotNull DataDeclarationContainer context, CatalogType typeToValidate) throws InvalidExpressionException {
        if (expression instanceof InvalidXPathExpression) {
            throw InvalidExpressionException.createExpressionIsInvalid(null);
        }
        if (expression instanceof XPathExpression) {
            XPathExpression xPathexpression = (XPathExpression)expression;
            String xpathExpression = expression.getExpressionValue();
            ExpressionHelper.validatePrefixes(context, xPathexpression);
            if (expression.getMode().equals((Object)ExpressionMode.XPATH)) {
                if (!Str.isEmpty((String)xpathExpression)) {
                    try {
                        XPATH_FACTORY.newXPath().compile(expression.getExpressionValue());
                    }
                    catch (XPathExpressionException e) {
                        throw InvalidExpressionException.createXPathExpressionIsInvalid(xpathExpression, e);
                    }
                }
            } else if (expression.getMode().equals((Object)ExpressionMode.SIMPLE)) {
                try {
                    String simpleResult = ExpressionHelper.getSimpleGeneratorResult(xPathexpression, context, typeToValidate);
                    if (!Str.isEmpty((String)simpleResult)) {
                        CatalogType resultType;
                        boolean isQuery;
                        XPathCompilerResult xpathResult = ExpressionHelper.getXPathGeneratorResult(simpleResult, context, typeToValidate, null);
                        boolean bl = isQuery = typeToValidate == null;
                        if (isQuery && xpathResult.isComplex()) {
                            throw InvalidExpressionException.createExpressionIsNotQuery();
                        }
                        if (!(typeToValidate == null || (resultType = ExpressionHelper.getExpressionType(expression, context, typeToValidate)) != null && typeToValidate.isAssignableFrom(resultType))) {
                            throw InvalidExpressionException.createExpressionHasInvalidResultType(typeToValidate, resultType);
                        }
                    }
                }
                catch (CilException e) {
                    throw InvalidExpressionException.createExpressionIsInvalid(e.getKey());
                }
            }
        }
    }

    public static CatalogType getExpressionType(@NotNull Expression expression, @NotNull DataDeclarationContainer context, CatalogType resultType) {
        CatalogType result = null;
        if (expression.getMode().equals((Object)ExpressionMode.SIMPLE)) {
            XPathExpression xPathexpression = (XPathExpression)expression;
            try {
                String simpleResult = ExpressionHelper.getSimpleGeneratorResult(xPathexpression, context, resultType);
                if (!Str.isEmpty((String)simpleResult)) {
                    XPathCompilerResult xpathResult = ExpressionHelper.getXPathGeneratorResult(simpleResult, context, resultType, null);
                    result = xpathResult.returnType;
                }
            }
            catch (CilException e) {}
        } else if (expression.getMode().equals((Object)ExpressionMode.XPATH)) {
            result = CatalogType.Default.getAny();
        }
        return result;
    }

    public static Sequence<DataDeclaration> getDeclarationsPath(@NotNull Expression expression, @NotNull DataDeclarationContainer context) {
        Sequence result = CollectionUtils.emptySequence();
        if (expression instanceof XPathExpression) {
            XPathExpression xPathExpression = (XPathExpression)expression;
            try {
                String simpleResult = ExpressionHelper.getSimpleGeneratorResult(xPathExpression, context, null);
                if (!Str.isEmpty((String)simpleResult)) {
                    XPathCompilerResult xpathResult = ExpressionHelper.getXPathGeneratorResult(simpleResult, context, null, null);
                    if (xpathResult.simpleReferences != null) {
                        result = CollectionUtils.asSequence(xpathResult.simpleReferences);
                    }
                }
            }
            catch (CilException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getText(@NotNull Expression expression, @NotNull DataDeclarationContainer context, CatalogType resultType) {
        String result = null;
        if (expression instanceof InvalidExpression) {
            InvalidExpression invalidExpression = (InvalidExpression)expression;
            result = invalidExpression.getInvalidExpressionString();
        } else if (expression instanceof XPathExpression) {
            XPathExpression xPathExpression = (XPathExpression)expression;
            switch (expression.getMode()) {
                case SIMPLE: {
                    try {
                        result = ExpressionHelper.getSimpleGeneratorResult(xPathExpression, context, resultType);
                    }
                    catch (CilException e) {}
                    break;
                }
                case XPATH: {
                    result = expression.getExpressionValue();
                    break;
                }
                case TEXT: {
                    result = SimpleCompiler.makeLiteral(expression.getExpressionValue());
                }
            }
        }
        return result;
    }

    public static XPathExpression getPurgedExpression(@NotNull XPathExpression expression, @NotNull DataDeclarationContainer context) {
        XPathReferenceResult references;
        XPathReferencesParser parser = new XPathReferencesParser(context);
        try {
            references = parser.generate(expression);
        }
        catch (CilException ignore) {
            return expression;
        }
        HashMap nameSpaces = new HashMap(expression.getNamespaces());
        if (!nameSpaces.keySet().retainAll(references.prefixes)) {
            return expression;
        }
        XPathExpression result = new XPathExpression(expression.getExpressionValue(), nameSpaces);
        result.setMode(expression.getMode());
        return result;
    }

    private static void validatePrefixes(DataDeclarationContainer context, XPathExpression xPathexpression) throws InvalidExpressionException {
        HashSet<String> prefixes = new HashSet<String>(ExpressionHelper.getExpressionPrefixes(context, xPathexpression));
        prefixes.removeAll(xPathexpression.getNamespaces().keySet());
        if (!prefixes.isEmpty()) {
            throw InvalidExpressionException.undefinedPrefixes(xPathexpression.getExpressionValue(), prefixes);
        }
    }

    private static Set<String> getExpressionPrefixes(DataDeclarationContainer context, XPathExpression xPathexpression) throws InvalidExpressionException {
        XPathReferenceResult parserResult;
        XPathReferencesParser parser = new XPathReferencesParser(context);
        try {
            parserResult = parser.generate(xPathexpression);
        }
        catch (CilException e) {
            throw InvalidExpressionException.createXPathExpressionIsInvalid(xPathexpression.getExpressionValue(), (Exception)((Object)e));
        }
        return parserResult.prefixes;
    }

    private static String buildSimpleQueryString(@NotNull Sequence<DataDeclaration> parts) {
        StringBuilder result = new StringBuilder();
        for (DataDeclaration part : parts) {
            if (result.length() > 0) {
                result.append(SIMPLE_MODE_SEPARATOR);
            }
            result.append(part.getName());
        }
        return result.toString();
    }

    @NotNull
    private static XPathCompilerResult getXPathGeneratorResult(@NotNull String expression, @NotNull DataDeclarationContainer context, CatalogType resultType, Map<String, URI> usedNamespaces) throws CilException {
        XPathCompiler compiler = new XPathCompiler(context);
        if (usedNamespaces != null) {
            compiler.setCurrentNameSpaces(usedNamespaces);
        }
        return compiler.generate(expression, resultType);
    }

    @NotNull
    private static String getSimpleGeneratorResult(@NotNull XPathExpression xpathExpression, @NotNull DataDeclarationContainer context, CatalogType resultType) throws CilException {
        SimpleCompiler compiler = new SimpleCompiler(context);
        return compiler.generate(xpathExpression, resultType);
    }
}

