/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.ArgumentException;
import oracle.bpm.project.compile.exceptions.ConversationErrorException;
import oracle.bpm.project.compile.exceptions.ConversationHasAnInvalidImplementationException;
import oracle.bpm.project.compile.exceptions.ConversationHasNoInitiatorImplementationException;
import oracle.bpm.project.compile.exceptions.ConversationHasNoRelatedNodeException;
import oracle.bpm.project.compile.exceptions.ConversationInterfaceException;
import oracle.bpm.project.compile.exceptions.ConversationOperationException;
import oracle.bpm.project.compile.exceptions.ConversationOverImplementedException;
import oracle.bpm.project.compile.exceptions.FlowNodeHasNoImplementationException;
import oracle.bpm.project.compile.exceptions.MustContinueAnInitiatorNodeException;
import oracle.bpm.project.compile.exceptions.ProcessCommunicationException;
import oracle.bpm.project.compile.exceptions.ServiceOperationException;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.compile.process.DataAssociationChecker;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;
    private ConversationEnabled node;

    public ConversationChecker(@NotNull ProjectMessageListener listener, @NotNull ConversationEnabled node, @NotNull ProcessChecker.CheckContext context) {
        super(listener);
        this.node = node;
        this.context = context;
    }

    public ProcessChecker.CheckContext getContext() {
        return this.context;
    }

    public CheckOptions getOptions() {
        return this.getContext().getOptions();
    }

    @Override
    public void check() {
        if (this.isOverImplemented(this.node)) {
            this.reportError(this.node, new ConversationOverImplementedException(this.node));
        }
        if (this.node.isConversationInitiator()) {
            if (ConversationHelper.isCatcher(this.node)) {
                this.checkCatcherInitiator(this.node);
            } else {
                this.checkThrowerInitiator(this.node);
            }
        } else {
            ConversationEnabled conversationInitiator = this.node.getConversationInitiator();
            if (conversationInitiator == null) {
                this.reportError(this.node, new ConversationHasNoRelatedNodeException(this.node));
            } else if (conversationInitiator.getConversationInitiator() != null) {
                this.reportError(this.node, new MustContinueAnInitiatorNodeException(this.node));
            } else if (ConversationHelper.isCatcher(this.node)) {
                this.checkCatcherContinuator(this.node);
            } else {
                this.checkThrowerContinuator(this.node);
            }
        }
        new DataAssociationChecker(this.getListener(), this.node).check();
    }

    private void checkCatcherInitiator(@NotNull ConversationEnabled node) {
        if (!ConversationHelper.hasImplementation(node)) {
            this.reportErrorWarning(node, new FlowNodeHasNoImplementationException(node));
        } else if (ConversationHelper.isDefiner(node)) {
            this.checkOperationNameNotNull(node);
            this.checkOperationNameNotDuplicated(node);
            this.checkArgumentsType(node);
            this.checkSyncValidPath(node);
        } else if (ConversationHelper.usesService(node)) {
            this.checkValidService(node, false, null, false);
            this.checkServiceOperation(node);
            this.checkSyncValidPath(node);
        } else {
            this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
        }
    }

    private void checkCatcherContinuator(@NotNull ConversationEnabled node) {
        ConversationEnabled initiator = node.getConversationInitiator();
        if (!ConversationHelper.hasImplementation(initiator)) {
            this.reportErrorWarning(node, new ConversationHasNoInitiatorImplementationException(node));
        } else if (!ConversationHelper.hasImplementation(node)) {
            this.reportErrorWarning(node, new FlowNodeHasNoImplementationException(node));
        } else if (ConversationHelper.isCatcher(initiator)) {
            if (ConversationHelper.isDefiner(initiator)) {
                this.checkOperationNameNotNull(node);
                this.checkArgumentsType(node);
            } else if (ConversationHelper.usesService(initiator)) {
                this.checkSameInitiatorService(node);
                this.checkServiceOperation(node);
            } else {
                this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
            }
        } else if (ConversationHelper.usesService(initiator)) {
            this.checkCallbackService(node);
            this.checkServiceOperation(node);
        } else if (ConversationHelper.usesProcess(initiator)) {
            this.checkSameInitiatorProcess(node);
            this.checkAssociatedNode(node);
        } else {
            this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
        }
    }

    private void checkThrowerInitiator(@NotNull ConversationEnabled node) {
        if (!ConversationHelper.hasImplementation(node)) {
            this.reportErrorWarning(node, new FlowNodeHasNoImplementationException(node));
        } else if (ConversationHelper.usesService(node)) {
            this.checkValidService(node, false, false, true);
            this.checkServiceOperation(node);
        } else if (ConversationHelper.usesProcess(node)) {
            this.checkValidProcess(node);
            this.checkAssociatedNode(node);
        } else {
            this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
        }
    }

    private void checkThrowerContinuator(@NotNull ConversationEnabled node) {
        ConversationEnabled initiator = node.getConversationInitiator();
        if (!ConversationHelper.hasImplementation(initiator)) {
            this.reportErrorWarning(node, new ConversationHasNoInitiatorImplementationException(node));
        } else if (!ConversationHelper.hasImplementation(node)) {
            this.reportErrorWarning(node, new FlowNodeHasNoImplementationException(node));
        } else if (ConversationHelper.isCatcher(initiator)) {
            if (ConversationHelper.isDefiner(initiator)) {
                if (ConversationHelper.usesError(node)) {
                    if (Event.class.isAssignableFrom(node.getRawClass()) && initiator.isSync()) {
                        this.checkException(node);
                    } else {
                        this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
                    }
                } else if (ConversationHelper.isDefiner(node)) {
                    if (!node.isSync()) {
                        this.checkOperationNameNotNull(node);
                        this.checkOperationNameNotDuplicated(node);
                    } else {
                        this.checkInputArguments(node);
                    }
                    this.checkArgumentsType(node);
                } else {
                    this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
                }
            } else if (ConversationHelper.usesService(initiator)) {
                InterfaceObject service = (InterfaceObject)initiator.getParticipant();
                if (ConversationHelper.usesError(node)) {
                    if (Event.class.isAssignableFrom(node.getRawClass()) && service.isSync()) {
                        this.checkException(node);
                    } else {
                        this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
                    }
                } else if (ConversationHelper.usesService(node)) {
                    if (service.isSync()) {
                        this.checkSameInitiatorService(node);
                    } else {
                        this.checkCallbackService(node);
                    }
                    this.checkServiceOperation(node);
                } else {
                    this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
                }
            }
        } else if (ConversationHelper.usesService(initiator)) {
            this.checkSameInitiatorService(node);
            this.checkServiceOperation(node);
        } else if (ConversationHelper.usesProcess(initiator)) {
            this.checkSameInitiatorProcess(node);
            this.checkAssociatedNode(node);
        } else {
            this.reportErrorWarning(node, new ConversationHasAnInvalidImplementationException(node));
        }
    }

    private void reportErrorWarning(@NotNull ConversationEnabled node, @NotNull ProjectException exception) {
        if (this.getOptions().isDeploying()) {
            this.reportError(node, exception);
        } else {
            this.reportWarning(node, exception);
        }
    }

    private void checkOperationNameNotNull(@NotNull ConversationEnabled node) {
        if (Str.isEmpty((String)node.getDefinedOperationName())) {
            this.reportError(node, ConversationOperationException.createNull(node));
        }
    }

    private void checkOperationNameNotDuplicated(@NotNull ConversationEnabled node) {
        if (!Str.isEmpty((String)node.getDefinedOperationName()) && ConversationHelper.operationNameExists(node.getDefinedOperationName(), node)) {
            this.reportError(node, ConversationOperationException.createDuplicated(node));
        }
    }

    private void checkValidService(@NotNull ConversationEnabled node, final Boolean isCallback, final Boolean isSync, final Boolean isService) {
        CatalogObject service = node.getParticipant();
        if (service == null) {
            this.reportError(node, ServiceOperationException.createNullService(node));
        } else {
            CatalogModule root;
            CatalogModule catalogModule = root = node.getProject() != null ? node.getProject().getCatalogRoot() : null;
            if (root != null) {
                Predicate<InterfaceObject> servicesPredicate = new Predicate<InterfaceObject>(){

                    public boolean check(@Nullable InterfaceObject value) {
                        return value != null && (isService == null || isService != false && value instanceof ServiceObject || isService == false && value instanceof ReferenceObject) && (isCallback == null || isCallback.booleanValue() == value.isCallback()) && (isSync == null || isSync.booleanValue() == value.isSync());
                    }
                };
                Sequence validServices = root.getDescendants(InterfaceObject.class).select((Predicate)servicesPredicate);
                if (!validServices.contains((Object)service)) {
                    this.reportError(node, ServiceOperationException.createInvalidService(node));
                }
            }
        }
    }

    private void checkSameInitiatorService(@NotNull ConversationEnabled node) {
        CatalogObject service = node.getParticipant();
        if (service == null) {
            this.reportError(node, ServiceOperationException.createNullService(node));
        } else {
            ConversationEnabled initiator = node.getConversationInitiator();
            if (initiator.getParticipant() == null || !initiator.getParticipant().equals(service)) {
                this.reportError(node, ServiceOperationException.createInvalidService(node));
            }
        }
    }

    private void checkCallbackService(@NotNull ConversationEnabled node) {
        CatalogObject service = node.getParticipant();
        if (service == null) {
            this.reportError(node, ServiceOperationException.createNullService(node));
        } else {
            ConversationEnabled initiator = node.getConversationInitiator();
            InterfaceObject initiatorService = (InterfaceObject)initiator.getParticipant();
            if (initiatorService == null || ConversationHelper.getCallbackInterface(initiatorService) == null || !ConversationHelper.getCallbackInterface(initiatorService).equals(service)) {
                this.reportError(node, ServiceOperationException.createInvalidService(node));
            }
        }
    }

    private void checkServiceOperation(@NotNull ConversationEnabled node) {
        CatalogObject service = node.getParticipant();
        if (service != null) {
            CatalogMember operation = node.getOperation();
            if (operation == null) {
                this.reportError(node, ServiceOperationException.createNullOperation(node));
            } else if (!service.getMethods().contains((Object)operation)) {
                this.reportError(node, ServiceOperationException.createInvalidOperation(node));
            }
        }
    }

    private void checkValidProcess(@NotNull ConversationEnabled node) {
        Process process = node.getAssociatedProcess();
        if (process == null) {
            this.reportError(node, ProcessCommunicationException.createNullProcess(node));
        } else {
            Project project = process.getProject();
            if (!project.getProcesses().contains(process)) {
                this.reportError(node, ProcessCommunicationException.createInvalidProcess(node));
            }
        }
    }

    private void checkSameInitiatorProcess(@NotNull ConversationEnabled node) {
        Process process = node.getAssociatedProcess();
        if (process == null) {
            this.reportError(node, ProcessCommunicationException.createNullProcess(node));
        } else {
            ConversationEnabled initiator = node.getConversationInitiator();
            if (initiator.getAssociatedProcess() == null || !initiator.getAssociatedProcess().equals(process)) {
                this.reportError(node, ProcessCommunicationException.createInvalidProcess(node));
            }
        }
    }

    private void checkAssociatedNode(@NotNull ConversationEnabled node) {
        Process process = node.getAssociatedProcess();
        if (process != null) {
            ConversationEnabled associatedNode = node.getAssociatedNode();
            if (associatedNode == null) {
                this.reportError(node, ProcessCommunicationException.createNullNode(node));
            } else {
                Sequence<ConversationEnabled> nodes = CollectionUtils.emptySequence();
                ConversationEnabled initiator = node.getConversationInitiator();
                if (initiator == null) {
                    nodes = ConversationHelper.getAllInitiatorCatchers(process, node.getBpmnType());
                } else {
                    ConversationEnabled relatedInitiatorNode = initiator.getAssociatedNode();
                    if (relatedInitiatorNode != null) {
                        Sequence<ConversationEnabled> sequence = nodes = ConversationHelper.isCatcher(node) ? ConversationHelper.getContinuatorsThrowers(relatedInitiatorNode, true) : ConversationHelper.getContinuatorsCatchers(relatedInitiatorNode);
                    }
                }
                if (!nodes.contains((Object)associatedNode)) {
                    this.reportError(node, ProcessCommunicationException.createInvalidNode(node));
                }
            }
        }
    }

    private void checkException(@NotNull ConversationEnabled node) {
        Sequence<ErrorObject> errors;
        ConversationEnabled initiator = node.getConversationInitiator();
        ErrorObject error = node.getAssociatedError();
        Sequence<ErrorObject> sequence = errors = ConversationHelper.isDefiner(initiator) ? node.getProject().getCatalogRoot().getDescendants(ErrorObject.class) : initiator.getOperation().getExceptions();
        if (!errors.contains((Object)error)) {
            this.reportError(node, ConversationErrorException.createInvalid(node));
        }
    }

    private void checkSyncValidPath(@NotNull ConversationEnabled node) {
        if (node.isSync() && ConversationHelper.getContinuatorsThrowers(node, false).isEmpty()) {
            this.reportError(node, ConversationErrorException.createValidPathMissing(node));
        }
    }

    private void checkArgumentsType(@NotNull ConversationEnabled node) {
        if (InputArgumentsEnabled.class.isAssignableFrom(node.getRawClass())) {
            InputArgumentsEnabled inputArgumentsEnabled = (InputArgumentsEnabled)((Object)node);
            this.checkArgumentsType(inputArgumentsEnabled.getInputArgumentsContainer());
        }
        if (OutputArgumentsEnabled.class.isAssignableFrom(node.getRawClass())) {
            OutputArgumentsEnabled outputArgumentsEnabled = (OutputArgumentsEnabled)((Object)node);
            this.checkArgumentsType(outputArgumentsEnabled.getOutputArgumentsContainer());
        }
    }

    private void checkArgumentsType(@NotNull DataDeclarationContainer argumentsContainer) {
        for (DataDeclaration argument : argumentsContainer.getLocalDeclarations()) {
            if (!argument.getType().isUnknown()) continue;
            this.reportError(this.node, ArgumentException.createInvalidType(this.node, argument));
        }
    }

    private void checkInputArguments(@NotNull ConversationEnabled node) {
        InputArgumentsEnabled inputsNode = (InputArgumentsEnabled)((Object)node);
        ConversationEnabled initiator = node.getConversationInitiator();
        Sequence<ConversationEnabled> continuators = ConversationHelper.getContinuatorsThrowers(initiator, false);
        for (ConversationEnabled continuator : continuators) {
            InputArgumentsEnabled inputsContinuator = (InputArgumentsEnabled)((Object)continuator);
            if (this.isSameInterface(inputsNode.getInputArgumentsContainer(), inputsContinuator.getInputArgumentsContainer())) continue;
            this.reportError(node, ConversationInterfaceException.createInvalidThrowerInterface(node));
            break;
        }
    }

    private boolean isSameInterface(@NotNull DataDeclarationContainer interface1, @NotNull DataDeclarationContainer interface2) {
        DataDeclaration[] interfaceArray2;
        DataDeclaration[] interfaceArray1 = (DataDeclaration[])interface1.getLocalDeclarations().toArray((Object[])new DataDeclaration[0]);
        if (interfaceArray1.length == (interfaceArray2 = (DataDeclaration[])interface2.getLocalDeclarations().toArray((Object[])new DataDeclaration[0])).length) {
            for (int i = 0; i < interfaceArray1.length; ++i) {
                if (interfaceArray1[i].getName().equals(interfaceArray2[i].getName()) && interfaceArray1[i].getType().equals(interfaceArray2[i].getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isOverImplemented(@NotNull ConversationEnabled node) {
        int implementations = 0;
        if (ConversationHelper.isDefiner(node)) {
            ++implementations;
        }
        if (ConversationHelper.usesService(node)) {
            ++implementations;
        }
        if (ConversationHelper.usesProcess(node)) {
            ++implementations;
        }
        if (ConversationHelper.usesError(node)) {
            ++implementations;
        }
        return implementations > 1;
    }
}

