/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.exceptions;

import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.exception.ActivityException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;

public class DataTransformationException
extends ActivityException {
    private static final long serialVersionUID = 7932962666369765486L;

    private DataTransformationException(FlowNode node, Msg message) {
        super(node);
        this.setKey(message);
    }

    public static DataTransformationException createTransformationNotExists(FlowNode node, String transformationName) {
        return new DataTransformationException(node, ProjectCompileMsg.DATA_TRANSFORMATION_NOT_EXISTS(node.getDefaultLabel(), transformationName));
    }

    public static DataTransformationException createInvalidSource(FlowNode node, String source) {
        return new DataTransformationException(node, ProjectCompileMsg.INVALID_DATA_TRANSFORMATION_SOURCE(node.getDefaultLabel(), source));
    }

    public static DataTransformationException createInvalidTarget(FlowNode node, String target) {
        return new DataTransformationException(node, ProjectCompileMsg.INVALID_DATA_TRANSFORMATION_TARGET(node.getDefaultLabel(), target));
    }

    public static DataTransformationException createNullTarget(FlowNode node) {
        return new DataTransformationException(node, ProjectCompileMsg.NULL_DATA_TRANSFORMATION_TARGET(node.getDefaultLabel()));
    }
}

