/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.xpath.XPathGeneratorUtils;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.compile.CatalogUtils;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExpressionCompiler {
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull DataDeclarationContainer context) {
        Set<XPathVariable> scope = ExpressionCompiler.buildScope(context);
        ComponentCatalog catalog = context.getProject().getComponentCatalog();
        return XPathGeneratorUtils.buildMethod(scope, (ComponentCatalog)catalog);
    }

    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull DataDeclarationContainer context, @Nullable CatalogType resultType) {
        Set<XPathVariable> scope = ExpressionCompiler.buildScope(context);
        ComponentCatalog catalog = context.getProject().getComponentCatalog();
        TypeDescription ref = resultType == null ? TypeFactory.getAny() : resultType.getDynamicRef();
        return XPathGeneratorUtils.buildMethod(scope, (ComponentCatalog)catalog, (TypeRef)ref);
    }

    @NotNull
    public static Set<XPathVariable> buildScope(final @NotNull DataDeclarationContainer context) {
        return new AbstractSet<XPathVariable>(){

            @Override
            public Iterator<XPathVariable> iterator() {
                final Iterator iterator = context.getDeclarations().iterator();
                return new Iterator<XPathVariable>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public XPathVariable next() {
                        return CatalogUtils.asXPathVariable((DataDeclaration)iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return CollectionUtils.size(context.getDeclarations());
            }
        };
    }

    @NotNull
    static Set<DataDeclaration> asDataDeclarations(@NotNull DataDeclarationContainer context, @NotNull Set<XPathVariable> expressionVariables) {
        LinkedHashSet<DataDeclaration> variables = new LinkedHashSet<DataDeclaration>(expressionVariables.size());
        for (XPathVariable variable : expressionVariables) {
            String varName = variable.getName();
            DataDeclaration declaration = context.findDeclaration(varName);
            if (declaration != null) {
                variables.add(declaration);
                continue;
            }
            assert (false) : "Unknown variable name \"" + varName + '\"';
        }
        return variables;
    }
}

