/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.client.internal.processmodel;

import java.io.File;
import java.io.UnsupportedEncodingException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.fs.FileProjectLoader;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.internal.processmodel.ejb.IProcessModelServiceRemote;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;

public class ProcessModelServiceRemoteClient
implements IProcessModelService {
    private IProcessModelServiceRemote stub;

    public ProcessModelServiceRemoteClient(IProcessModelServiceRemote stub) {
        this.stub = stub;
    }

    @Override
    public Process getProcessModel(IBPMContext context, String compositeDN, String processName) throws BPMException {
        Process process;
        try {
            FuegoProject project = FuegoProject.createInMemory((String)compositeDN);
            project.setComponentCatalog((ComponentCatalog)TypeUtils.getDefaultCatalog());
            project.setLoader((ProjectLoader)new FileProjectLoader(null, (Project)project, null));
            byte[] modelXMLBytes = this.getStub().getProcessModelXML(context, compositeDN, processName);
            String modelXML = new String(modelXMLBytes, "UTF-8");
            process = (Process)project.createFromXml(Process.class, modelXML);
        }
        catch (ProjectException e) {
            throw new BPMException(71201, null, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BPMException(71201, null, e);
        }
        return process;
    }

    private IProcessModelServiceRemote getStub() {
        return this.stub;
    }

    static {
        FileProjectRepository repository = FileProjectRepository.create((File)new File("dummy_file"));
        RepositoryService.getInstance().setActiveRepository((ProjectRepository)repository);
    }
}

