/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.BatchOperationException;
import fuego.papi.HistoryView;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.View;
import fuego.papi.ViewType;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TreeView
implements Serializable {
    private Locale locale;
    private SortedSet<NodeView> root;
    private ViewComparator viewComparator;
    private ViewFilter viewFilter;
    static final long serialCheck = -3208310705049656358L;
    static final long serialVersionUID = -8253791734034641308L;

    public TreeView(ProcessServiceSession processServiceSession) {
        this(processServiceSession, null);
    }

    public TreeView(ProcessServiceSession processServiceSession, ViewComparator comparator) {
        this(processServiceSession, comparator, null);
    }

    public TreeView(ProcessServiceSession processServiceSession, ViewComparator comparator, ViewFilter viewFilter) {
        this(processServiceSession, comparator, viewFilter, null);
    }

    public TreeView(ProcessServiceSession processServiceSession, ViewComparator comparator, ViewFilter viewFilter, Locale locale) {
        if (locale == null) {
            this.updateLocale(processServiceSession);
        } else {
            this.locale = locale;
        }
        this.viewComparator = comparator != null ? comparator : this.getDefaultViewComparator();
        this.viewFilter = viewFilter != null ? viewFilter : this.getDefaultViewFilter();
        this.makeTree(processServiceSession);
    }

    public void setViewComparator(ViewComparator viewComparator) {
        this.viewComparator = viewComparator;
    }

    public ViewComparator getViewComparator() {
        return this.viewComparator != null ? this.viewComparator : this.getDefaultViewComparator();
    }

    public SortedSet<NodeView> getRoot() {
        return this.root;
    }

    public void collapse() {
        for (NodeView rootNode : this.root) {
            rootNode.collapse();
        }
    }

    public void expand() {
        for (NodeView rootNode : this.root) {
            rootNode.expand();
        }
    }

    public void expandAll() {
        for (NodeView rootNode : this.root) {
            rootNode.expandAll();
        }
    }

    public void reload(ProcessServiceSession processServiceSession) {
        this.updateLocale(processServiceSession);
        this.makeTree(processServiceSession);
    }

    private void updateLocale(ProcessServiceSession processServiceSession) {
        try {
            this.locale = processServiceSession.participantLocale();
        }
        catch (OperationException e) {
            this.locale = Locale.getDefault();
        }
    }

    private ViewFilter getDefaultViewFilter() {
        return new DefaultViewFilter();
    }

    private ViewComparator getDefaultViewComparator() {
        return new DeafultViewComparator();
    }

    private void makeTree(ProcessServiceSession processServiceSession) {
        this.root = new TreeSet<NodeView>(this.viewComparator);
        try {
            for (String viewId : processServiceSession.viewsGetIds()) {
                View view;
                String parentViewId = processServiceSession.viewGetParentId(viewId);
                if (parentViewId != null) continue;
                NodeView rootView = new NodeView(view, null, !this.viewFilter.accept(view = processServiceSession.viewGet(viewId)));
                this.makeTree(rootView, processServiceSession);
                if (!rootView.hasAssociatedView() && !rootView.hasChildren()) continue;
                rootView.setVisible(true);
                this.root.add(rootView);
            }
        }
        catch (OperationException cause) {
            throw new OperationRuntimeException(cause);
        }
        catch (BatchOperationException cause) {
            throw new OperationRuntimeException(cause);
        }
    }

    private void makeTree(NodeView parent, ProcessServiceSession processServiceSession) {
        assert (parent != null) : "Parent node should not be null";
        String parentViewId = parent.getId();
        for (Map.Entry<String, View> entry : processServiceSession.viewGetChildren(parentViewId).entrySet()) {
            View childView = entry.getValue();
            if (!childView.getParentId().equalsIgnoreCase(parentViewId)) continue;
            NodeView child = new NodeView(childView, null, !this.viewFilter.accept(childView));
            this.makeTree(child, processServiceSession);
            if (!child.hasAssociatedView() && !child.hasChildren()) continue;
            parent.addChild(child);
        }
    }

    private class DeafultViewComparator
    implements ViewComparator {
        private static final long serialVersionUID = 1767256834378664795L;

        private DeafultViewComparator() {
        }

        public int getOrderByType(ViewType viewType) {
            int result;
            switch (viewType) {
                case INSTANCES: {
                    result = 0;
                    break;
                }
                case APPLICATIONS: {
                    result = 1;
                    break;
                }
                case FOLDER: {
                    result = 2;
                    break;
                }
                case ATTACHMENTS: {
                    result = 3;
                    break;
                }
                case BOOKMARKS: {
                    result = 4;
                    break;
                }
                case CONSULTATIONS: {
                    result = 5;
                    break;
                }
                case HISTORY: {
                    result = 6;
                    break;
                }
                default: {
                    result = 7;
                }
            }
            return result;
        }

        public int getOrderById(String viewId) {
            int result = viewId.equals("unified_inbox") ? 0 : (viewId.equals("history_view") ? 3 : 1);
            return result;
        }

        @Override
        public int compare(int number1, int number2) {
            int result = number1 != number2 ? (number1 > number2 ? 1 : -1) : 0;
            return result;
        }

        @Override
        public int compare(NodeView node1, NodeView node2) {
            int result;
            View view1 = node1.getView();
            View view2 = node2.getView();
            if (view1 == null && view2 == null) {
                result = 0;
            } else if (view1 == null) {
                result = -1;
            } else if (view2 == null) {
                result = 1;
            } else {
                result = this.compare(this.getOrderById(view1.getId()), this.getOrderById(view2.getId()));
                if (result == 0) {
                    ViewType type1 = view1.getType();
                    ViewType type2 = view2.getType();
                    result = this.compare(this.getOrderByType(type1), this.getOrderByType(type2));
                    if (result == 0) {
                        if (type1.equals(ViewType.HISTORY)) {
                            result = this.compare(((HistoryView)view1).getOrder(), ((HistoryView)view2).getOrder());
                        } else {
                            String label2;
                            String label1 = view1.getLabel(TreeView.this.locale);
                            result = label1.compareTo(label2 = view2.getLabel(TreeView.this.locale));
                            if (result == 0) {
                                return view1.getId().compareTo(view2.getId());
                            }
                        }
                    }
                }
            }
            return result;
        }
    }

    private static class DefaultViewFilter
    implements ViewFilter {
        private static final long serialVersionUID = 940943868692216551L;

        private DefaultViewFilter() {
        }

        @Override
        public boolean accept(View view) {
            return true;
        }
    }

    public class NodeView
    implements Serializable {
        private SortedSet<NodeView> children;
        private boolean hasView;
        private boolean isExpanded;
        private boolean isVisible;
        private NodeView parent;
        private View view;
        static final long serialCheck = -8097565321922101137L;
        static final long serialVersionUID = -2745917077557153837L;

        private NodeView(View view, NodeView parent, boolean isVirtual) {
            this.view = view;
            this.parent = parent;
            this.children = new TreeSet<NodeView>(TreeView.this.viewComparator);
            this.isVisible = false;
            this.hasView = !isVirtual;
        }

        public String getId() {
            return this.view.getId();
        }

        public NodeView getParent() {
            return this.parent;
        }

        public SortedSet<NodeView> getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public View getView() {
            return this.view;
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isVisible() {
            if (this.isVisible && this.parent != null) {
                return this.parent.isExpanded();
            }
            return this.isVisible;
        }

        public String getLabel(Locale locale) {
            return this.view.getLabel(locale);
        }

        public boolean hasAssociatedView() {
            return this.hasView;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public void collapse() {
            this.setVisible(true);
            this.setExpanded(false);
        }

        public void expand() {
            this.setVisible(true);
            this.setExpanded(true);
            for (NodeView child : this.children) {
                child.setVisible(true);
            }
        }

        public void expandAll() {
            this.setVisible(true);
            this.setExpanded(true);
            for (NodeView child : this.children) {
                child.expandAll();
            }
        }

        public boolean equals(Object object) {
            return this == object || object instanceof NodeView && ((NodeView)object).getId().equalsIgnoreCase(this.getId());
        }

        public int hashCode() {
            return this.getId().toLowerCase().hashCode();
        }

        private boolean isExpanded() {
            return this.isExpanded;
        }

        private void setExpanded(boolean expanded) {
            this.isExpanded = expanded;
        }

        private void addChild(NodeView child) {
            this.children.add(child);
        }
    }

    public static interface ViewFilter
    extends Serializable {
        public boolean accept(View var1);
    }

    public static interface ViewComparator
    extends Serializable,
    Comparator<NodeView> {
        @Override
        public int compare(NodeView var1, NodeView var2);
    }
}

