/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.BatchOperationException;
import fuego.papi.Filter;
import fuego.papi.InstanceInfo;
import fuego.papi.InstancesView;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.exception.InstancesException;
import fuego.papi.utils.BackwardsCompatibilitySupport;
import fuego.papi.utils.ProcessInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class ProcessInstanceQuery
implements BackwardsCompatibilitySupport<Implementation> {
    private static ProcessInstanceQuery instance = new ProcessInstanceQuery();
    private static final String IMPLEMENTATION_11G = "oracle.bpm.papi.ora.util.ProcessInstanceQuery11G";

    public static ProcessInstance processGetInstance(@NotNull ProcessServiceSession session, @NotNull String instanceId) throws OperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).processGetInstance(session, instanceId);
    }

    public static Collection<ProcessInstance> processesGetInstancesByFilter(@NotNull ProcessServiceSession session, @NotNull ProcessIdSet processes, @NotNull Filter filter) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).processesGetInstancesByFilter(session, processes, filter);
    }

    public static Collection<ProcessInstance> processesGetInstancesByFilter(@NotNull ProcessServiceSession session, @NotNull ProcessIdSet processes, @NotNull Filter filter, int startRow, int endRow) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).processesGetInstancesByFilter(session, processes, filter, startRow, endRow);
    }

    public static int processesCountInstancesByFilter(@NotNull ProcessServiceSession session, @NotNull ProcessIdSet processes, @NotNull Filter filter) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).processesCountInstancesByFilter(session, processes, filter);
    }

    public static InstanceInfoList processesGetInstanceThreadsByFilter(@NotNull ProcessServiceSession session, @NotNull ProcessIdSet processes, @NotNull Filter filter, int startRow, int endRow) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).processesGetInstancesThreadsByFilter(session, processes, filter, startRow, endRow);
    }

    public static int processesCountInstanceThreadsByFilter(@NotNull ProcessServiceSession session, @NotNull ProcessIdSet processes, @NotNull Filter filter) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).processesCountInstancesThreadsByFilter(session, processes, filter);
    }

    public static Collection<ProcessInstance> viewGetInstances(@NotNull ProcessServiceSession session, @NotNull String viewId) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewGetInstances(session, viewId);
    }

    public static Collection<ProcessInstance> viewGetInstances(@NotNull ProcessServiceSession session, @NotNull String viewId, int startRow, int endRow) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewGetInstances(session, viewId, startRow, endRow);
    }

    public static int viewCountInstances(@NotNull ProcessServiceSession session, @NotNull String viewId) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewCountInstances(session, viewId);
    }

    public static InstanceInfoList viewGetInstancesThreads(@NotNull ProcessServiceSession session, @NotNull String viewId, int startRow, int endRow) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewGetInstancesThreads(session, viewId, startRow, endRow);
    }

    public static int viewCountInstanceThreads(@NotNull ProcessServiceSession session, @NotNull String viewId) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewCountInstancesThreads(session, viewId);
    }

    public static Collection<ProcessInstance> viewGetInstances(@NotNull ProcessServiceSession session, @NotNull InstancesView view) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewGetInstances(session, view);
    }

    public static Collection<ProcessInstance> viewGetInstances(@NotNull ProcessServiceSession session, @NotNull InstancesView view, int startRow, int endRow) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewGetInstances(session, view, startRow, endRow);
    }

    public static int viewCountInstances(@NotNull ProcessServiceSession session, @NotNull InstancesView view) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewCountInstances(session, view);
    }

    public static InstanceInfoList viewGetInstanceThreads(@NotNull ProcessServiceSession session, @NotNull InstancesView view, int startRow, int endRow) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewGetInstancesThreads(session, view, startRow, endRow);
    }

    public static int viewCountInstanceThreads(@NotNull ProcessServiceSession session, @NotNull InstancesView view) throws OperationException, BatchOperationException {
        return ProcessInstanceQuery.getInstance().getImplementation(session).viewCountInstancesThreads(session, view);
    }

    private static ProcessInstanceQuery getInstance() {
        return instance;
    }

    @Override
    public Implementation getImplementation(@NotNull ProcessServiceSession session) throws OperationException {
        return BackwardsCompatibilitySupport.Utils.loadImplementation(this, session);
    }

    @Override
    public String getImplementationClassName(@NotNull ProcessServiceSession session) {
        if (session.getClass().getName().equals("oracle.bpm.papi.ora.ProcessServiceSessionAdapter")) {
            return IMPLEMENTATION_11G;
        }
        return "fuego.papi.utils.ProcessInstanceQuery.Implementation";
    }

    public static class PapiImplementation
    implements Implementation {
        /*
         * Exception decompiling
         */
        @Override
        public ProcessInstance processGetInstance(ProcessServiceSession session, String instanceId) throws OperationException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Collection<ProcessInstance> processesGetInstancesByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.processesGetInstancesByFilter(processes, filter);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            return this.makeProcessInstance(instances, exceptions);
        }

        @Override
        public Collection<ProcessInstance> processesGetInstancesByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter, int startRow, int endRow) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.processesGetInstancesByFilter(processes, filter);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances, exceptions);
            int start = startRow > endRow ? endRow : startRow;
            int end = endRow < startRow ? startRow : endRow;
            start = start < 0 ? 0 : start;
            int n = end = end < 0 ? 0 : end;
            if (processInstances.size() < start || processInstances.size() == 0 || end == 0) {
                return new ArrayList<ProcessInstance>();
            }
            if (processInstances.size() < end) {
                return processInstances.subList(start, processInstances.size());
            }
            return processInstances.subList(start, end);
        }

        @Override
        public int processesCountInstancesByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.processesGetInstancesByFilter(processes, filter);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances, exceptions);
            return processInstances.size();
        }

        @Override
        public InstanceInfoList processesGetInstancesThreadsByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter, int startRow, int endRow) throws OperationException, BatchOperationException {
            InstanceInfoList instanceInfoList = session.processesGetInstancesByFilter(processes, filter);
            int start = startRow > endRow ? endRow : startRow;
            int end = endRow < startRow ? startRow : endRow;
            start = start < 0 ? 0 : start;
            int n = end = end < 0 ? 0 : end;
            if (instanceInfoList.size() < start || instanceInfoList.size() == 0 || end == 0) {
                return InstanceInfoList.create();
            }
            if (instanceInfoList.size() < end) {
                return InstanceInfoList.create(instanceInfoList.subList(start, instanceInfoList.size()));
            }
            return InstanceInfoList.create(instanceInfoList.subList(start, end));
        }

        @Override
        public int processesCountInstancesThreadsByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter) throws OperationException, BatchOperationException {
            InstanceInfoList instanceInfoList = session.processesGetInstancesByFilter(processes, filter);
            return instanceInfoList.size();
        }

        @Override
        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, String viewId) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.viewGetInstances(viewId);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            return this.makeProcessInstance(instances, exceptions);
        }

        @Override
        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, String viewId, int startRow, int endRow) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.viewGetInstances(viewId);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances, exceptions);
            int start = startRow > endRow ? endRow : startRow;
            int end = endRow < startRow ? startRow : endRow;
            start = start < 0 ? 0 : start;
            int n = end = end < 0 ? 0 : end;
            if (processInstances.size() < start || processInstances.size() == 0 || end == 0) {
                return new ArrayList<ProcessInstance>();
            }
            if (processInstances.size() < end) {
                return processInstances.subList(start, processInstances.size());
            }
            return processInstances.subList(start, end);
        }

        @Override
        public int viewCountInstances(ProcessServiceSession session, String viewId) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.viewGetInstances(viewId);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances, exceptions);
            return processInstances.size();
        }

        @Override
        public InstanceInfoList viewGetInstancesThreads(ProcessServiceSession session, String viewId, int startRow, int endRow) throws OperationException, BatchOperationException {
            InstanceInfoList instanceInfoList = session.viewGetInstances(viewId);
            int start = startRow > endRow ? endRow : startRow;
            int end = endRow < startRow ? startRow : endRow;
            start = start < 0 ? 0 : start;
            int n = end = end < 0 ? 0 : end;
            if (instanceInfoList.size() < start || instanceInfoList.size() == 0 || end == 0) {
                return InstanceInfoList.create();
            }
            if (instanceInfoList.size() < end) {
                return InstanceInfoList.create(instanceInfoList.subList(start, instanceInfoList.size()));
            }
            return InstanceInfoList.create(instanceInfoList.subList(start, end));
        }

        @Override
        public int viewCountInstancesThreads(ProcessServiceSession session, String viewId) throws OperationException, BatchOperationException {
            InstanceInfoList instances = session.viewGetInstances(viewId);
            return instances.size();
        }

        @Override
        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, InstancesView view) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.viewGetInstances(view);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            return this.makeProcessInstance(instances, exceptions);
        }

        @Override
        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, InstancesView view, int startRow, int endRow) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.viewGetInstances(view);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances, exceptions);
            int start = startRow > endRow ? endRow : startRow;
            int end = endRow < startRow ? startRow : endRow;
            start = start < 0 ? 0 : start;
            int n = end = end < 0 ? 0 : end;
            if (processInstances.size() < start || processInstances.size() == 0 || end == 0) {
                return new ArrayList<ProcessInstance>();
            }
            if (processInstances.size() < end) {
                return processInstances.subList(start, processInstances.size());
            }
            return processInstances.subList(start, end);
        }

        @Override
        public int viewCountInstances(ProcessServiceSession session, InstancesView view) throws OperationException, BatchOperationException {
            Map<String, Throwable> exceptions = null;
            InstanceInfoList instances = InstanceInfoList.create();
            try {
                instances = session.viewGetInstances(view);
            }
            catch (BatchOperationException exception) {
                exceptions = exception.getNotAvailableObjects();
                instances.add((InstanceInfo[])exception.getAvailableObjects());
            }
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances, exceptions);
            return processInstances.size();
        }

        @Override
        public InstanceInfoList viewGetInstancesThreads(ProcessServiceSession session, InstancesView view, int startRow, int endRow) throws OperationException, BatchOperationException {
            InstanceInfoList instanceInfoList = session.viewGetInstances(view);
            int start = startRow > endRow ? endRow : startRow;
            int end = endRow < startRow ? startRow : endRow;
            start = start < 0 ? 0 : start;
            int n = end = end < 0 ? 0 : end;
            if (instanceInfoList.size() < start || instanceInfoList.size() == 0 || end == 0) {
                return InstanceInfoList.create();
            }
            if (instanceInfoList.size() < end) {
                return InstanceInfoList.create(instanceInfoList.subList(start, instanceInfoList.size()));
            }
            return InstanceInfoList.create(instanceInfoList.subList(start, end));
        }

        @Override
        public int viewCountInstancesThreads(ProcessServiceSession session, InstancesView view) throws OperationException, BatchOperationException {
            InstanceInfoList instanceInfoList = session.viewGetInstances(view);
            return instanceInfoList.size();
        }

        protected List<ProcessInstance> makeProcessInstance(InstanceInfoList instances) throws OperationException {
            ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
            Map<String, Set<InstanceInfo>> instancesByProcess = this.sortInstancesByProcess(instances);
            for (Map.Entry<String, Set<InstanceInfo>> entry : instancesByProcess.entrySet()) {
                HashMap<Integer, ProcessInstance> processInstances = new HashMap<Integer, ProcessInstance>();
                for (InstanceInfo instance : entry.getValue()) {
                    ProcessInstance processInstance = (ProcessInstance)processInstances.get(instance.getInstanceIn());
                    if (processInstance == null) {
                        processInstance = ProcessInstance.create(instance);
                        processInstances.put(instance.getInstanceIn(), processInstance);
                    }
                    processInstance.addThread(instance);
                }
                result.addAll(processInstances.values());
            }
            return result;
        }

        protected List<ProcessInstance> makeProcessInstance(InstanceInfoList instances, Map<String, Throwable> exceptions) throws OperationException, InstancesException {
            List<ProcessInstance> processInstances = this.makeProcessInstance(instances);
            if (exceptions != null && !exceptions.isEmpty()) {
                InstanceInfo[] processInstanceArray;
                throw new InstancesException(processInstanceArray, exceptions, (processInstanceArray = processInstances.toArray(new ProcessInstance[processInstances.size()])).length == 0);
            }
            return processInstances;
        }

        protected Map<String, Set<InstanceInfo>> sortInstancesByProcess(InstanceInfoList instances) {
            TreeMap<String, Set<InstanceInfo>> instancesByProcess = new TreeMap<String, Set<InstanceInfo>>(String.CASE_INSENSITIVE_ORDER);
            for (InstanceInfo instance : instances) {
                HashSet<InstanceInfo> processInstances = (HashSet<InstanceInfo>)instancesByProcess.get(instance.getProcessId());
                if (processInstances == null) {
                    processInstances = new HashSet<InstanceInfo>();
                    instancesByProcess.put(instance.getProcessId(), processInstances);
                }
                processInstances.add(instance);
            }
            return instancesByProcess;
        }
    }

    public static interface Implementation {
        public ProcessInstance processGetInstance(ProcessServiceSession var1, String var2) throws OperationException;

        public Collection<ProcessInstance> processesGetInstancesByFilter(ProcessServiceSession var1, ProcessIdSet var2, Filter var3) throws OperationException, BatchOperationException;

        public Collection<ProcessInstance> processesGetInstancesByFilter(ProcessServiceSession var1, ProcessIdSet var2, Filter var3, int var4, int var5) throws OperationException, BatchOperationException;

        public int processesCountInstancesByFilter(ProcessServiceSession var1, ProcessIdSet var2, Filter var3) throws OperationException, BatchOperationException;

        public InstanceInfoList processesGetInstancesThreadsByFilter(ProcessServiceSession var1, ProcessIdSet var2, Filter var3, int var4, int var5) throws OperationException, BatchOperationException;

        public int processesCountInstancesThreadsByFilter(ProcessServiceSession var1, ProcessIdSet var2, Filter var3) throws OperationException, BatchOperationException;

        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession var1, String var2) throws OperationException, BatchOperationException;

        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession var1, String var2, int var3, int var4) throws OperationException, BatchOperationException;

        public int viewCountInstances(ProcessServiceSession var1, String var2) throws OperationException, BatchOperationException;

        public InstanceInfoList viewGetInstancesThreads(ProcessServiceSession var1, String var2, int var3, int var4) throws OperationException, BatchOperationException;

        public int viewCountInstancesThreads(ProcessServiceSession var1, String var2) throws OperationException, BatchOperationException;

        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession var1, InstancesView var2) throws OperationException, BatchOperationException;

        public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession var1, InstancesView var2, int var3, int var4) throws OperationException, BatchOperationException;

        public int viewCountInstances(ProcessServiceSession var1, InstancesView var2) throws OperationException, BatchOperationException;

        public InstanceInfoList viewGetInstancesThreads(ProcessServiceSession var1, InstancesView var2, int var3, int var4) throws OperationException, BatchOperationException;

        public int viewCountInstancesThreads(ProcessServiceSession var1, InstancesView var2) throws OperationException, BatchOperationException;
    }
}

