/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.Arguments;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.utils.BackwardsCompatibilitySupport;
import org.jetbrains.annotations.NotNull;

public class ApplicationExecution
implements BackwardsCompatibilitySupport<ApplicationExecutionImplementation> {
    private static ApplicationExecution instance = new ApplicationExecution();

    public static Arguments beginExecution(@NotNull ProcessServiceSession session, @NotNull String processId, @NotNull Arguments args) throws OperationException {
        return ApplicationExecution.getInstance().getImplementation(session).beginExecution(session, processId, args);
    }

    @Override
    public ApplicationExecutionImplementation getImplementation(@NotNull ProcessServiceSession session) throws OperationException {
        return BackwardsCompatibilitySupport.Utils.loadImplementation(this, session);
    }

    @Override
    public String getImplementationClassName(@NotNull ProcessServiceSession session) {
        if (session.getClass().getName().equals("oracle.bpm.papi.ora.ProcessServiceSessionAdapter")) {
            return "oracle.bpm.papi.ora.util.ApplicationExecution11G";
        }
        return "fuego.papi.utils.ApplicationExecution.ApplicationExecutionImplementation10g";
    }

    private static ApplicationExecution getInstance() {
        return instance;
    }

    public static class ApplicationExecutionImplementation10G
    implements ApplicationExecutionImplementation {
        @Override
        public Arguments beginExecution(@NotNull ProcessServiceSession session, @NotNull String processId, @NotNull Arguments args) {
            throw new UnsupportedOperationException("Not supported in 10g!");
        }
    }

    public static interface ApplicationExecutionImplementation {
        public Arguments beginExecution(@NotNull ProcessServiceSession var1, @NotNull String var2, @NotNull Arguments var3) throws OperationException;
    }
}

