/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.collections;

import fuego.papi.Process;
import fuego.papi.collections.ElementIdSet;
import fuego.papi.collections.ProcessList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.bpm.collections.iterator.ReadOnlyIterator;
import oracle.bpm.collections.sets.StringSet;

public class ProcessIdSet
implements ElementIdSet<String> {
    private Set<String> items = StringSet.create();
    static final long serialCheck = 2497899103036448885L;
    static final long serialVersionUID = 4781307951521305418L;

    private ProcessIdSet() {
    }

    public static ProcessIdSet create() {
        return new ProcessIdSet();
    }

    public ProcessIdSet add(String processId) {
        this.items.add(processId);
        return this;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return ReadOnlyIterator.create(this.items.iterator());
    }

    public ProcessIdSet add(Process process) {
        this.add(process.getId());
        return this;
    }

    public ProcessIdSet addAll(Process ... processes) {
        for (Process process : processes) {
            this.add(process.getId());
        }
        return this;
    }

    public ProcessIdSet addAll(String ... processIds) {
        for (String processId : processIds) {
            this.add(processId);
        }
        return this;
    }

    public ProcessIdSet addAll(List<String> processIds) {
        for (String processId : processIds) {
            this.add(processId);
        }
        return this;
    }

    public ProcessIdSet addAll(ProcessList processes) {
        for (Process process : processes) {
            this.add(process.getId());
        }
        return this;
    }

    public ProcessIdSet addAll(ElementIdSet<String> processIds) {
        for (String id : processIds) {
            this.add(id);
        }
        return this;
    }

    @Override
    public boolean contains(String elementId) {
        return this.items.contains(elementId);
    }

    public String[] toArray() {
        return this.items.toArray(new String[this.size()]);
    }
}

