/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.collections;

import fuego.papi.Activity;
import fuego.papi.InstanceId;
import java.io.Serializable;

public class InstanceActivityPair
implements Serializable {
    private String activityName;
    private String instanceId;
    static final long serialCheck = -5720939960692178254L;
    static final long serialVersionUID = 0L;

    protected InstanceActivityPair() {
    }

    protected InstanceActivityPair(String instanceId, String activityName) {
        this.instanceId = instanceId;
        this.activityName = activityName;
    }

    public static InstanceActivityPair valueOf(String instanceActivityPairId) {
        int indexOf = instanceActivityPairId.lastIndexOf("!");
        if (indexOf == -1) {
            throw new IllegalArgumentException("Invalid argument format.");
        }
        String instanceId = instanceActivityPairId.substring(0, indexOf);
        String activityName = instanceActivityPairId.substring(indexOf + 1);
        return new InstanceActivityPair(instanceId, activityName);
    }

    public static InstanceActivityPair valueOf(String instanceId, String activityName) {
        if (instanceId == null || instanceId.length() < 12) {
            throw new IllegalArgumentException("Invalid argument 'instanceId' (" + instanceId + ").");
        }
        if (activityName != null && activityName.length() < 1) {
            throw new IllegalArgumentException("Invalid argument 'activityName' (" + activityName + ").");
        }
        return new InstanceActivityPair(instanceId, activityName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceActivityPair that = (InstanceActivityPair)o;
        return this.instanceId.toLowerCase().equals(that.instanceId.toLowerCase());
    }

    public int hashCode() {
        return this.instanceId.toLowerCase().hashCode();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getActivityId() {
        assert (this.activityName != null && this.instanceId != null);
        return Activity.makeId(InstanceId.getProcessId(this.getInstanceId()), this.getActivityName());
    }

    public String toString() {
        return this.instanceId + "!" + this.activityName;
    }

    protected void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    protected void setActivityName(String activityName) {
        this.activityName = activityName;
    }
}

