/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.collections;

import fuego.papi.Activity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ActivityList
extends ArrayList<Activity> {
    static final long serialCheck = 1894110998242149220L;
    static final long serialVersionUID = 0L;

    private ActivityList(int initialCapacity) {
        super(initialCapacity);
    }

    public static ActivityList create() {
        return new ActivityList(10);
    }

    public static ActivityList create(int initialCapacity) {
        return new ActivityList(initialCapacity);
    }

    public static ActivityList create(Activity ... values) {
        ActivityList result = new ActivityList(ActivityList.capacity(values.length));
        for (Activity value : values) {
            result.add(value);
        }
        return result;
    }

    public static ActivityList create(Collection<Activity> values) {
        ActivityList result = new ActivityList(ActivityList.capacity(values.size()));
        for (Activity value : values) {
            result.add(value);
        }
        return result;
    }

    public static ActivityList convert(Collection<?> objects) {
        ActivityList result = new ActivityList(ActivityList.capacity(objects.size()));
        for (Object value : objects) {
            result.add((Activity)value);
        }
        return result;
    }

    public void addAll(Activity[] activities) {
        this.addAll(Arrays.asList(activities));
    }

    public Activity[] toArray() {
        return this.toArray(new Activity[this.size()]);
    }

    public ActivityList add(Activity ... values) {
        for (Activity value : values) {
            this.add(value);
        }
        return this;
    }

    public Activity last() {
        return (Activity)this.get(this.size() - 1);
    }

    @Override
    public ActivityList clone() {
        return (ActivityList)super.clone();
    }

    private static int capacity(int length) {
        return (int)Math.min((long)length * 110L / 100L, Integer.MAX_VALUE);
    }
}

