/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.attachment.config;

import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.papi.attachment.config.AttachmentConfigMappingInfo;
import fuego.papi.attachment.config.AttachmentRepositoryType;
import fuego.papi.attachment.config.MappingCredentials;
import fuego.papi.exception.AttachmentConfigException;
import fuego.papi.msg.PapiMsg;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.log.Log;

public class AttachmentConfigManager {
    private AttachmentConfigMappingInfo defaultMapping;
    private String externalStorageEndpointUrl;
    private MappingCredentials mappingCredentials;
    private final Map<String, AttachmentConfigMappingInfo> processMappings = new TreeMap<String, AttachmentConfigMappingInfo>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, AttachmentConfigMappingInfo> projectMappings = new TreeMap<String, AttachmentConfigMappingInfo>(String.CASE_INSENSITIVE_ORDER);
    private AttachmentRepositoryType repositoryType;
    private Boolean usesInstanceFolders;
    private static AttachmentConfigManager instance;
    private static final String ENCRYPTION_KEY = "external_attachment";

    private AttachmentConfigManager() {
    }

    public static synchronized AttachmentConfigManager getInstance() {
        if (instance == null) {
            instance = new AttachmentConfigManager();
        }
        return instance;
    }

    public String retrieveRemoteEndpointUrl(DirectorySession session) {
        try {
            if (this.externalStorageEndpointUrl == null) {
                this.externalStorageEndpointUrl = (String)Directory.retrieveProperty(session, "albpm.attachment.global.config", "albpm.attachment.plugin.external.endpoint");
            }
            return this.externalStorageEndpointUrl;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11000, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11000, (Throwable)e);
        }
    }

    public void storeRemoteEndpointUrl(DirectorySession session, String remoteEndpointUrl) {
        try {
            Directory.storeProperty(session, "albpm.attachment.global.config", "albpm.attachment.plugin.external.endpoint", remoteEndpointUrl);
            this.externalStorageEndpointUrl = remoteEndpointUrl;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11001, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11001, (Throwable)e);
        }
    }

    public AttachmentConfigMappingInfo retrieveDefaultMapping(DirectorySession session) {
        return this.retrieveDefaultMapping(session, true);
    }

    public AttachmentConfigMappingInfo retrieveDefaultMapping(DirectorySession session, boolean forceRefresh) {
        AttachmentConfigMappingInfo info = null;
        info = this.defaultMapping;
        if (info == null || forceRefresh) {
            try {
                String xmlProp = (String)Directory.retrieveProperty(session, "albpm.attachment.plugin.default_project.mapping", "albpm.attachment.plugin.default");
                if (this.isValidXmlProperty(xmlProp)) {
                    this.defaultMapping = info = AttachmentConfigMappingInfo.createFromXml(xmlProp);
                } else {
                    Log.logDebug(PapiMsg.PAPI_11010);
                }
            }
            catch (DirectoryException e) {
                Log.logWarning(PapiMsg.PAPI_11010, e);
                throw new AttachmentConfigException(PapiMsg.PAPI_11010, (Throwable)e);
            }
        }
        return info;
    }

    public AttachmentConfigMappingInfo retrieveProjectMapping(DirectorySession session, String projectName) {
        return this.retrieveProjectMapping(session, projectName, true);
    }

    public AttachmentConfigMappingInfo retrieveProjectMapping(DirectorySession session, String projectName, boolean forceRefresh) {
        assert (projectName != null);
        AttachmentConfigMappingInfo info = null;
        info = this.projectMappings.get(projectName);
        if (info == null || forceRefresh) {
            try {
                String xmlProp = (String)Directory.retrieveProperty(session, "albpm.attachment.plugin.albpmproject_project.mapping", projectName);
                if (this.isValidXmlProperty(xmlProp)) {
                    info = AttachmentConfigMappingInfo.createFromXml(xmlProp);
                    this.projectMappings.put(projectName, info);
                } else {
                    Log.logDebug(PapiMsg.PAPI_11020(projectName));
                }
            }
            catch (DirectoryException e) {
                Log.logWarning(PapiMsg.PAPI_11020(projectName), e);
                throw new AttachmentConfigException(PapiMsg.PAPI_11020(projectName), (Throwable)e);
            }
        }
        if (info == null) {
            info = this.retrieveDefaultMapping(session, forceRefresh);
        }
        return info;
    }

    public Map<String, AttachmentConfigMappingInfo> retrieveAllProcessMappings(DirectorySession session) {
        try {
            this.processMappings.clear();
            Map<String, Object> xmlProperties = Directory.retrieveAllProperties(session, "albpm.attachment.plugin.processproject.mapping");
            for (String processName : xmlProperties.keySet()) {
                String xmlProp = (String)xmlProperties.get(processName);
                if (this.isValidXmlProperty(xmlProp)) {
                    AttachmentConfigMappingInfo info = AttachmentConfigMappingInfo.createFromXml(xmlProp);
                    this.processMappings.put(processName, info);
                    continue;
                }
                Log.logDebug(PapiMsg.PAPI_11030(processName));
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11011, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11011, (Throwable)e);
        }
        return Collections.unmodifiableMap(this.processMappings);
    }

    public Map<String, AttachmentConfigMappingInfo> retrieveAllProjectMappings(DirectorySession session) {
        try {
            this.projectMappings.clear();
            Map<String, Object> xmlProperties = Directory.retrieveAllProperties(session, "albpm.attachment.plugin.albpmproject_project.mapping");
            for (String projectName : xmlProperties.keySet()) {
                String xmlProp = (String)xmlProperties.get(projectName);
                if (this.isValidXmlProperty(xmlProp)) {
                    AttachmentConfigMappingInfo info = AttachmentConfigMappingInfo.createFromXml(xmlProp);
                    this.projectMappings.put(projectName, info);
                    continue;
                }
                Log.logDebug(PapiMsg.PAPI_11020(projectName));
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11012, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11012, (Throwable)e);
        }
        return Collections.unmodifiableMap(this.projectMappings);
    }

    public AttachmentConfigMappingInfo retrieveProcessMapping(DirectorySession session, String projectName, String processName) {
        return this.retrieveProcessMapping(session, projectName, processName, true);
    }

    public AttachmentConfigMappingInfo retrieveProcessMapping(DirectorySession session, String projectName, String processName, boolean forceRefresh) {
        assert (processName != null);
        AttachmentConfigMappingInfo info = null;
        info = this.processMappings.get(processName);
        if (info == null || forceRefresh) {
            try {
                String xmlProp = (String)Directory.retrieveProperty(session, "albpm.attachment.plugin.processproject.mapping", processName);
                if (this.isValidXmlProperty(xmlProp)) {
                    info = AttachmentConfigMappingInfo.createFromXml(xmlProp);
                    this.processMappings.put(processName, info);
                } else {
                    Log.logDebug(PapiMsg.PAPI_11030(processName));
                }
            }
            catch (DirectoryException e) {
                Log.logWarning(PapiMsg.PAPI_11030(processName), e);
                throw new AttachmentConfigException(PapiMsg.PAPI_11030(processName), (Throwable)e);
            }
        }
        if (info == null) {
            info = this.retrieveProjectMapping(session, projectName);
        }
        return info;
    }

    public void storeDefaultMapping(DirectorySession session, AttachmentConfigMappingInfo mappingInfo) {
        assert (mappingInfo != null);
        try {
            String xml = mappingInfo.toXml();
            Directory.storeProperty(session, "albpm.attachment.plugin.default_project.mapping", "albpm.attachment.plugin.default", xml);
            this.defaultMapping = mappingInfo;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11040, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11040, (Throwable)e);
        }
    }

    public void storeProcessMapping(DirectorySession session, String processName, AttachmentConfigMappingInfo mappingInfo) {
        assert (mappingInfo != null && processName != null);
        try {
            String xml = mappingInfo.toXml();
            Directory.storeProperty(session, "albpm.attachment.plugin.processproject.mapping", processName, xml);
            this.processMappings.put(processName, mappingInfo);
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11040, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11040, (Throwable)e);
        }
    }

    public void storeProjectMapping(DirectorySession session, String projectName, AttachmentConfigMappingInfo mappingInfo) {
        assert (mappingInfo != null && projectName != null);
        try {
            String xml = mappingInfo.toXml();
            Directory.storeProperty(session, "albpm.attachment.plugin.albpmproject_project.mapping", projectName, xml);
            this.projectMappings.put(projectName, mappingInfo);
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11040, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11040, (Throwable)e);
        }
    }

    public void removeProcessMappingInfo(DirectorySession session, String processName) {
        assert (processName != null);
        try {
            String xmlProp = (String)Directory.retrieveProperty(session, "albpm.attachment.plugin.processproject.mapping", processName);
            if (xmlProp != null) {
                Directory.storeProperty(session, "albpm.attachment.plugin.processproject.mapping", processName, null);
                this.processMappings.remove(processName);
            } else {
                Log.logDebug(PapiMsg.PAPI_11050(processName));
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11050(processName), e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11050(processName), (Throwable)e);
        }
    }

    public void removeDefaultMapping(DirectorySession session) {
        try {
            Directory.storeProperty(session, "albpm.attachment.plugin.default_project.mapping", "albpm.attachment.plugin.default", null);
            this.defaultMapping = null;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11060, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11060, (Throwable)e);
        }
    }

    public void removeProjectMappingInfo(DirectorySession session, String projectName) {
        assert (projectName != null);
        try {
            String xmlProp = (String)Directory.retrieveProperty(session, "albpm.attachment.plugin.albpmproject_project.mapping", projectName);
            if (xmlProp != null) {
                Directory.storeProperty(session, "albpm.attachment.plugin.albpmproject_project.mapping", projectName, null);
                this.projectMappings.remove(projectName);
            } else {
                Log.logDebug(PapiMsg.PAPI_11070(projectName));
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11070(projectName), e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11070(projectName), (Throwable)e);
        }
    }

    public MappingCredentials retrieveMappingCredentials(DirectorySession session) {
        try {
            String credentialsString;
            if (this.mappingCredentials == null && (credentialsString = (String)Directory.retrieveEncryptedProperty(session, "albpm.attachment.global.config", "albpm.attachment.plugin.external.credentials", ENCRYPTION_KEY)) != null) {
                this.mappingCredentials = MappingCredentials.createFromString(credentialsString);
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11080, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11080, (Throwable)e);
        }
        return this.mappingCredentials;
    }

    public void storeMappingCredentials(DirectorySession session, MappingCredentials credentials) {
        try {
            String credentialsValue = credentials != null ? credentials.toString() : null;
            Directory.storeEncryptedProperty(session, "albpm.attachment.global.config", "albpm.attachment.plugin.external.credentials", credentialsValue, ENCRYPTION_KEY);
            this.mappingCredentials = credentials;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11090, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11090, (Throwable)e);
        }
    }

    public AttachmentRepositoryType retrieveAttachmentRepositoryType(DirectorySession session) {
        try {
            String repString;
            if (this.repositoryType == null && (repString = (String)Directory.retrieveProperty(session, "albpm.attachment.global.config", "albpm.attachment.storage.repository")) != null) {
                this.repositoryType = AttachmentRepositoryType.valueOf(repString);
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11100, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11100, (Throwable)e);
        }
        return this.repositoryType;
    }

    public void storeAttachmentRepositoryType(DirectorySession session, AttachmentRepositoryType repositoryType) {
        try {
            Directory.storeProperty(session, "albpm.attachment.global.config", "albpm.attachment.storage.repository", repositoryType.toString());
            this.repositoryType = repositoryType;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11110, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11110, (Throwable)e);
        }
    }

    public boolean retrieveUsesInstanceFolders(DirectorySession session) {
        try {
            String usesInstanceFoldersString;
            if (this.usesInstanceFolders == null && (usesInstanceFoldersString = (String)Directory.retrieveProperty(session, "albpm.attachment.global.config", "albpm.attachment.storage.use_instance_folders")) != null) {
                this.usesInstanceFolders = Boolean.valueOf(usesInstanceFoldersString);
            }
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11120, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11120, (Throwable)e);
        }
        return this.usesInstanceFolders != null && this.usesInstanceFolders != false;
    }

    public void storeUsesInstanceFolders(DirectorySession session, boolean usesInstanceFolders) {
        try {
            Directory.storeProperty(session, "albpm.attachment.global.config", "albpm.attachment.storage.use_instance_folders", String.valueOf(usesInstanceFolders));
            this.usesInstanceFolders = usesInstanceFolders;
        }
        catch (DirectoryException e) {
            Log.logWarning(PapiMsg.PAPI_11130, e);
            throw new AttachmentConfigException(PapiMsg.PAPI_11130, (Throwable)e);
        }
    }

    private boolean isValidXmlProperty(String xmlProp) {
        return xmlProp != null && !xmlProp.trim().equals("");
    }
}

