/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

@Component(module="Fuego.Papi")
public enum StatusScope implements I18nProvider
{
    ONLY_INPROCESS(PapiMsg.ONLY_INPROCESS),
    ONLY_COMPLETED(PapiMsg.ONLY_COMPLETED),
    ONLY_ABORTED(PapiMsg.ONLY_ABORTED),
    INPROCESS_AND_COMPLETED(PapiMsg.INPROCESS_AND_COMPLETED),
    INPROCESS_AND_ABORTED(PapiMsg.INPROCESS_AND_ABORTED),
    ABORTED_AND_COMPLETED(PapiMsg.ABORTED_AND_COMPLETED),
    ALL(PapiMsg.ALL);

    private transient Msg msg;

    private StatusScope(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Exclude
    public Msg getMsg() {
        return this.msg;
    }

    public boolean isInProcess() {
        return this == ALL || this == INPROCESS_AND_COMPLETED || this == INPROCESS_AND_ABORTED || this == ONLY_INPROCESS;
    }

    public boolean isCompleted() {
        return this == ALL || this == INPROCESS_AND_COMPLETED || this == ABORTED_AND_COMPLETED || this == ONLY_COMPLETED;
    }

    public boolean isAborted() {
        return this == ALL || this == INPROCESS_AND_ABORTED || this == ABORTED_AND_COMPLETED || this == ONLY_ABORTED;
    }

    public static StatusScope valueOf(boolean inProcess, boolean completed, boolean aborted) {
        StatusScope result;
        if (inProcess) {
            result = completed ? (aborted ? ALL : INPROCESS_AND_COMPLETED) : (aborted ? INPROCESS_AND_ABORTED : ONLY_INPROCESS);
        } else if (completed) {
            result = aborted ? ABORTED_AND_COMPLETED : ONLY_COMPLETED;
        } else {
            if (!aborted) {
                throw new IllegalArgumentException("Illegal combination");
            }
            result = ONLY_ABORTED;
        }
        return result;
    }
}

