/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.CommunicationException;
import fuego.papi.Filter;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.attachment.runtime.AttachmentConfigRetriever;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.ConnectionPassport;
import org.jetbrains.annotations.NonNls;

public abstract class ProcessService {
    @NonNls
    private static final String PROCESS_SERVICE_FACTORY_IMPLEMENTATION = "fuego.papi.impl.ProcessServiceFactoryImpl";
    @NonNls
    private static final String FEDERATED_PROCESS_SERVICE_FACTORY_IMPLEMENTATION = "fuego.papi.impl.federated.FederatedProcessServiceFactory";
    @NonNls
    private static final String FEDERATED_DIRECTORY_PASSPORT_CLASS = "fuego.papi.impl.federated.FederatedDirectoryPassport";
    @NonNls
    public static final String DIRECTORY_PROPERTIES_FILE = "fuego.directory.file";
    @NonNls
    public static final String DIRECTORY_PROPERTIES_RESOURCE = "fuego.directory.resource";
    @NonNls
    public static final String DIRECTORY_PROPERTIES_URL = "fuego.directory.url";
    @NonNls
    public static final String PROJECT_PATH = "fuego.project.path";
    @NonNls
    public static final String DIRECTORY_ID = "fuego.directory.id";
    @NonNls
    public static final String DIRECTORY_AUTHENTICATION = "fuego.directory.authentication";
    @NonNls
    public static final String DIRECTORY_MUST_AUTHENTICATE = "MUST_AUTHENTICATE";
    @NonNls
    public static final String DIRECTORY_MAY_AUTHENTICATE = "MAY_AUTHENTICATE";
    @NonNls
    public static final String INSTANCES_CACHE_SIZE = "fuego.papi.cache.size";
    public static final String MAX_PARTICIPANTS = "fuego.papi.max.participants";
    @NonNls
    public static final String INSTANCES_CACHE_INCREMENT_PERCENT = "fuego.papi.cache.increment.percent";
    @Deprecated
    @NonNls
    public static final String UPDATE_SESSIONS_VIEWS = "fuego.papi.view.update";
    @NonNls
    public static final String WORKING_FOLDER = "fuego.papi.folder";
    @NonNls
    public static final String WEB_APPLICATION_FOLDER = "fuego.webapplication.folder";
    @Deprecated
    @NonNls
    public static final String USER_DOCUMENTATION_FOLDER = "fuego.documentation.folder";
    @NonNls
    public static final String DOCUMENTATION_FOLDER = "fuego.documentation.folder";
    @NonNls
    public static final String EMBEDDED_ENVIRONMENT = "fuego.papi.processService.embedded";
    @NonNls
    public static final String FEDERATED_ENVIRONMENT = "fuego.papi.processService.federated";
    @Deprecated
    public static final int DEFAULT_CACHE_SIZE = 2000;
    public static final int DEFAULT_INSTANCE_CACHE_SIZE = 2000;
    public static final int DEFAULT_CACHE_INCREMENT_PERCENT = 25;
    @Deprecated
    @NonNls
    public static final String DEFAULT_WORKING_DIRECTORY = "/tmp";
    @NonNls
    public static final String DEFAULT_WORKING_FOLDER = "/tmp";
    @Deprecated
    @NonNls
    public static final String DEFAULT_USER_DOCUMENTATION_FOLDER = "/tmp";
    @NonNls
    public static final String DEFAULT_DOCUMENTATION_FOLDER = "/tmp";
    @NonNls
    public static final String DEFAULT_DIRECTORY_ID = "default";
    @NonNls
    public static final String DEFAULT_DIRECTORY_PROPERTIES_FILE = "../config/directory.xml";
    @NonNls
    public static final String DEFAULT_DIRECTORY_AUTHENTICATION = "MUST_AUTHENTICATE";
    @NonNls
    public static final String SECURITY_TOKEN_TYPE = "directory.security.token.type";
    @NonNls
    public static final String SECURITY_TOKEN = "directory.security.token";
    @NonNls
    public static final String CHECK_SERVICES_FEDERATED_ENVIRONMENT = "fuego.papi.processService.federated.check";
    @NonNls
    public static final String PAPI_APPLICATION_NAME = "fuego.papi.application";
    @NonNls
    public static final String DEFAULT_PAPI_APPLICATION_NAME = "papi";
    private static Factory factory;

    public abstract void close();

    public abstract boolean isOpen();

    public abstract ConnectionPassport createPassport(String var1);

    public abstract ConnectionPassport createPassportWithPreset(String var1);

    public abstract ProcessServiceSession createSession(ConnectionPassport var1, @NonNls String var2) throws OperationException;

    public abstract ProcessServiceSession createSession(String var1, String var2, String var3) throws OperationException;

    public abstract String getUserDocumentationFolder();

    public abstract void setLocale(Locale var1, ProcessServiceSession var2) throws OperationException;

    @Deprecated
    public abstract void setUserDocumentationFolder(String var1);

    public abstract void startUpdater(long var1) throws OperationException;

    public abstract void startUpdater(ConnectionPassport var1, long var2) throws OperationException;

    public abstract void stopUpdater() throws OperationException;

    public abstract String toString();

    public abstract Object retrieveOrganizationProperty(String var1, String var2) throws OperationException;

    public abstract Map<String, Object> retrieveAllOrganizationProperties(String var1) throws OperationException;

    public abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public abstract void authenticatePassport(ConnectionPassport var1) throws OperationException;

    public abstract AttachmentConfigRetriever getAttachmentConfigRetriever();

    public abstract boolean isFederatedEnvironment();

    public abstract String getCustomJspURLFolder(int var1) throws OperationException;

    public abstract String getCustomJspURLFolder(@NonNls Process var1) throws OperationException;

    public abstract String getWebResourcesURLFolder(int var1) throws OperationException;

    public abstract String getWebResourcesURLFolder(@NonNls Process var1) throws OperationException;

    public static synchronized ProcessService create(Properties properties) throws CommunicationException {
        return ProcessService.getFactory(properties).create(properties);
    }

    public static synchronized ProcessService create(ConnectionPassport passport, Properties properties) throws CommunicationException {
        return ProcessService.getFactory(passport).create(passport, properties);
    }

    public static Filter createFilter() {
        return ProcessService.getFactory().createFilter();
    }

    public static char[] invalidIdCharacters() {
        return new char[]{';', ',', '+', '\"', '<', '>', '\\', '?', '#', '@', '-', '/', '.'};
    }

    @Exclude
    public static void updateOrganizationalInformationFromDirectory() {
        ProcessService.getFactory().updateOrgInfo();
    }

    private static Factory getFactory() {
        if (factory == null) {
            try {
                factory = (Factory)Class.forName(PROCESS_SERVICE_FACTORY_IMPLEMENTATION, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return factory;
    }

    private static Factory getFactory(Properties properties) {
        if (factory == null) {
            String factoryClass = PROCESS_SERVICE_FACTORY_IMPLEMENTATION;
            if (properties.getProperty(DIRECTORY_ID, null) == null && properties.getProperty("fuego.directory.id.0", null) != null) {
                factoryClass = FEDERATED_PROCESS_SERVICE_FACTORY_IMPLEMENTATION;
            }
            if (properties.getProperty("fuego.papi.factory") != null) {
                factoryClass = properties.getProperty("fuego.papi.factory");
            }
            try {
                factory = (Factory)Class.forName(factoryClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return factory;
    }

    private static Factory getFactory(ConnectionPassport passport) {
        if (factory == null) {
            String factoryClass = PROCESS_SERVICE_FACTORY_IMPLEMENTATION;
            if (FEDERATED_DIRECTORY_PASSPORT_CLASS.equals(passport.getClass().getName())) {
                factoryClass = FEDERATED_PROCESS_SERVICE_FACTORY_IMPLEMENTATION;
            }
            try {
                factory = (Factory)Class.forName(factoryClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return factory;
    }

    public static interface Factory {
        public ProcessService create(Properties var1) throws CommunicationException;

        public ProcessService create(ConnectionPassport var1, Properties var2) throws CommunicationException;

        public Filter createFilter();

        public void updateOrgInfo();
    }
}

