/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.Activity;
import fuego.papi.ColumnFormat;
import fuego.papi.Ordering;
import fuego.papi.PresentationColumnFormat;
import fuego.papi.PresentationType;
import fuego.papi.Priority;
import fuego.papi.Process;
import fuego.papi.ProcessInstanceState;
import fuego.papi.VarDefinition;
import fuego.papi.exception.InvalidPresentationTypeException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.Void;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.FriendlyDateFormat;
import oracle.bpm.util.VarUtils;
import org.jetbrains.annotations.NonNls;

public interface Presentation
extends Serializable {
    @NonNls
    public static final String DEFAULT_ACTIVITY_ID = "default_activity";
    @NonNls
    public static final String DEFAULT_APPLICATIONS_ID = "default_applications";
    @NonNls
    public static final String DEFAULT_ATTACHMENTS_ID = "default_attachments";
    @NonNls
    public static final String DEFAULT_FOLDER_ID = "default_folder";
    @NonNls
    public static final String DEFAULT_ID = "default";
    @NonNls
    public static final String DEFAULT_INSTANCES_ID = "default_instances";
    @NonNls
    public static final String DEFAULT_OWNER = "organization";
    public static final long serialCheck = -92582166069997671L;
    public static final long serialVersionUID = -3400962856839358939L;

    public void setOrdering(Ordering var1);

    public Ordering getOrdering();

    public Column[] getColumns();

    public String getId();

    public String getOwner();

    public boolean isReadOnly();

    public PresentationType getType();

    public Presentation copy(String var1) throws InvalidPresentationTypeException;

    public static class DefaultPresentationColumnFormat
    implements PresentationColumnFormat {
        @Override
        public String format(Column column, Object value, Locale locale) {
            String formattedValue = null;
            if (value == null || value instanceof Void) {
                formattedValue = "";
            } else if (column.getId().equals("PREDEFINE_STATUS")) {
                formattedValue = ProcessInstanceState.getDescription((Integer)value, locale);
            } else if (column.getId().equals("PREDEFINE_PRIORITY")) {
                formattedValue = Priority.getDescription((Integer)value, locale);
            } else if (column.getId().equals("PREDEFINE_ACTIVITY")) {
                formattedValue = value instanceof Activity ? ((Activity)value).getLabel(locale) : value.toString();
            } else if (column.getId().equals("PREDEFINE_PROCESS")) {
                formattedValue = value instanceof Process ? ((Process)value).getLabel(locale) : value.toString();
            } else {
                ColumnFormat colFormat;
                Format theFormat;
                VarDefinition varDefinition = column.getVarDefinition();
                boolean alreadyFormatted = false;
                if (this.hasUserDefinedFormat(column) && (theFormat = (colFormat = column.getColumnFormat()).getFormat(locale)) != null) {
                    switch (varDefinition.getKind()) {
                        case 2: {
                            formattedValue = theFormat.format(value);
                            break;
                        }
                        case 3: {
                            formattedValue = ((NumberFormat)theFormat).format(((BigDecimal)value).doubleValue());
                            break;
                        }
                        case 4: {
                            formattedValue = ((NumberFormat)theFormat).format((Double)value);
                            break;
                        }
                        case 6: {
                            formattedValue = ((Time)value).format((DateFormat)theFormat);
                            break;
                        }
                        default: {
                            formattedValue = theFormat.format(value);
                        }
                    }
                    alreadyFormatted = true;
                }
                if (!alreadyFormatted) {
                    NumberFormat numberFormatter = NumberFormat.getNumberInstance(locale);
                    switch (varDefinition.getKind()) {
                        case 1: {
                            formattedValue = (Boolean)value != false ? CoreMsg.TRUE.getString(locale) : CoreMsg.FALSE.getString(locale);
                            break;
                        }
                        case 2: {
                            formattedValue = numberFormatter.format(((Number)value).longValue());
                            break;
                        }
                        case 3: {
                            DecimalFormat df = (DecimalFormat)numberFormatter;
                            df.setMinimumFractionDigits(varDefinition.getFractionSize());
                            df.setMaximumFractionDigits(varDefinition.getFractionSize());
                            formattedValue = df.format(((BigDecimal)value).doubleValue());
                            break;
                        }
                        case 4: {
                            formattedValue = numberFormatter.format((Double)value);
                            break;
                        }
                        case 5: {
                            formattedValue = (String)value;
                            break;
                        }
                        case 6: {
                            FriendlyDateFormat friendlyDateFormat = FriendlyDateFormat.getInstance(0, locale);
                            formattedValue = friendlyDateFormat.format((Time)value);
                            break;
                        }
                        default: {
                            formattedValue = value.toString();
                        }
                    }
                }
            }
            return formattedValue;
        }

        private boolean hasUserDefinedFormat(Column column) {
            return column != null && column.getColumnFormat() != null;
        }
    }

    public static class Column
    implements Serializable {
        private ColumnFormat columnFormatter = null;
        private transient DefaultPresentationColumnFormat defaultColumnFormat;
        private int size_d = -1;
        private transient VarDefinition varDefinition_d;
        private String varDefinitionId_d;
        static final long serialCheck = 6797882371691663108L;
        static final long serialVersionUID = -5543757071050616696L;
        static final long SerialVersionUID = 1L;

        public Column(VarDefinition varDefinition) {
            this.varDefinition_d = varDefinition;
            this.varDefinitionId_d = varDefinition.getId();
            this.size_d = varDefinition.getSize();
        }

        public Column(String variableId, int size) {
            this.varDefinitionId_d = variableId;
            this.size_d = size;
        }

        public Column(String variableId, int size, ColumnFormat columnFormat) {
            this(variableId, size);
            this.columnFormatter = columnFormat;
        }

        protected Column() {
        }

        public String getFormattedValue(Object value, Locale locale) {
            if (this.defaultColumnFormat == null) {
                this.defaultColumnFormat = new DefaultPresentationColumnFormat();
            }
            return this.getFormattedValue(value, locale, this.defaultColumnFormat);
        }

        public String getFormattedValue(Object value, Locale locale, PresentationColumnFormat columnFormat) {
            return columnFormat.format(this, value, locale);
        }

        public String getFormattedValue(Object value, Locale locale, TimeZone timeZone) {
            if (this.defaultColumnFormat == null) {
                this.defaultColumnFormat = new DefaultPresentationColumnFormat();
            }
            return this.getFormattedValue(value, locale, timeZone, this.defaultColumnFormat);
        }

        public String getFormattedValue(Object value, Locale locale, TimeZone timeZone, PresentationColumnFormat columnFormat) {
            if (value instanceof Time) {
                Time time = (Time)value;
                Calendar calendar = Calendar.getInstance(timeZone, locale);
                calendar.setTime(time.dateValue());
                return columnFormat.format(this, Time.valueOf(calendar.getTime()), locale);
            }
            return columnFormat.format(this, value, locale);
        }

        public String getId() {
            this.varDefinitionId_d = VarUtils.getExternalVariableFromDatabaseColumnName(this.varDefinitionId_d);
            return this.varDefinitionId_d;
        }

        public String getLabel(Locale locale) {
            if (this.varDefinition_d == null) {
                return this.varDefinitionId_d;
            }
            return this.varDefinition_d.getLabel(locale);
        }

        public void setSize(int size) {
            this.size_d = size;
        }

        public int getSize() {
            return this.size_d;
        }

        public void setVarDefinition(VarDefinition varDefinition) {
            if (varDefinition.getId().equalsIgnoreCase(this.getId())) {
                this.varDefinition_d = varDefinition;
                this.varDefinitionId_d = varDefinition.getId();
            }
            if (this.size_d == -1) {
                this.size_d = varDefinition.getSize();
            }
        }

        public VarDefinition getVarDefinition() {
            return this.varDefinition_d;
        }

        public ColumnFormat getColumnFormat() {
            return this.columnFormatter;
        }

        public void setColumnFormat(ColumnFormat columnFormat) {
            this.columnFormatter = columnFormat;
        }
    }
}

