/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.OperationRuntimeException;
import fuego.papi.ParticipantFor;
import fuego.papi.msg.PapiMsg;
import java.io.Serializable;
import oracle.bpm.collections.maps.SortedStringMap;

public abstract class Participant
implements Serializable,
Comparable<Participant> {
    protected SortedStringMap<RoleAssignment> rolesId_d;
    private String firstName = "";
    private boolean isAdministrator;
    private String lastName = "";
    private String mail_d;
    private String name_d;
    private String ou_d;
    private String uid_d;
    protected static final char ABORT_PERMISION = 'A';
    protected static final char EXECUTE_PERMISION = 'X';
    protected static final char SEND_PERMISION = 'R';
    protected static final char SUSPEND_PERMISION = 'S';
    protected static final char REASIGN_PERMISION = 'G';
    protected static final char DELEGATE_PERMISION = 'D';
    protected static final char ESCALATE_PERMISION = 'E';
    protected static final char PEER_ASSIGMENT_PERMISION = 'P';
    static final long serialVersionUID = 20041210112507012L;
    static final long serialCheck = -8465320241308353639L;

    protected Participant(String name, String firstName, String lastName, String uid, String ou, String mail, RoleAssignment[] roles, boolean isAdministrator) {
        this.name_d = name;
        this.firstName = firstName;
        this.lastName = lastName;
        this.uid_d = uid;
        this.ou_d = ou;
        this.mail_d = mail;
        this.rolesId_d = SortedStringMap.createCaseInsensitive();
        for (RoleAssignment role : roles) {
            this.rolesId_d.put(role.id, role);
        }
        this.isAdministrator = isAdministrator;
    }

    public abstract boolean hasRole(String var1, String var2);

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public boolean isProcessOwner() {
        return false;
    }

    public String getMail() {
        return this.mail_d;
    }

    public String getName() {
        return this.name_d;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getOu() {
        return this.ou_d;
    }

    public String[] getOUs() {
        return new String[]{this.getOu()};
    }

    public int getRoleCategory(String role) {
        RoleAssignment roleAssignment = (RoleAssignment)this.rolesId_d.get(role);
        if (roleAssignment == null) {
            throw new OperationRuntimeException(PapiMsg.PAPI_9100(this.getUid(), role));
        }
        return roleAssignment.category;
    }

    public String getRolePermitions(String roleId) {
        RoleAssignment roleAssignment = (RoleAssignment)this.rolesId_d.get(roleId);
        if (roleAssignment == null) {
            throw new OperationRuntimeException(PapiMsg.PAPI_9100(this.getUid(), roleId));
        }
        return roleAssignment.permissions;
    }

    public String[] getRoles() {
        return this.rolesId_d.keySet().toArray(new String[this.rolesId_d.size()]);
    }

    public String getUid() {
        return this.uid_d;
    }

    public char compareParticipantCategoryWith(Participant participant, String roleId) {
        int result = this.getRoleCategory(roleId) - participant.getRoleCategory(roleId);
        return (char)(result == 0 ? 80 : (result > 0 ? 68 : 69));
    }

    @Override
    public int compareTo(Participant participant) {
        return participant == null ? -1 : this.getUid().compareToIgnoreCase(participant.getUid());
    }

    public boolean equals(Object compare) {
        return compare == this || compare != null && compare instanceof Participant && this.getUid().equalsIgnoreCase(((Participant)compare).getUid());
    }

    @Deprecated
    public boolean hasAbortPermision(String role) {
        return this.hasAbortPermission(role);
    }

    public boolean hasAbortPermission(String role) {
        return this.hasPermission(role, 'A');
    }

    @Deprecated
    public boolean hasExecutePermision(String role) {
        return this.hasExecutePermission(role);
    }

    public boolean hasExecutePermission(String role) {
        return this.hasPermission(role, 'X');
    }

    public boolean hasRole(String roleId) {
        return this.rolesId_d.containsKey(roleId);
    }

    @Deprecated
    public boolean hasSendPermision(String role) {
        return this.hasSendPermission(role);
    }

    public boolean hasSendPermission(String role) {
        return this.hasPermission(role, 'R');
    }

    public boolean hasReassignPermission(String role) {
        return this.hasPermission(role, 'G');
    }

    public boolean hasPeerAssignmentPermission(String role) {
        return this.hasPermission(role, 'P');
    }

    public boolean hasEscalatePermission(String role) {
        return this.hasPermission(role, 'E');
    }

    public boolean hasDelegatePermission(String role) {
        return this.hasPermission(role, 'D');
    }

    @Deprecated
    public boolean hasSuspendPermision(String role) {
        return this.hasSuspendPermission(role);
    }

    public boolean hasSuspendPermission(String role) {
        return this.hasPermission(role, 'S');
    }

    public boolean hasPermission(String role, ParticipantFor action) {
        return this.hasPermission(role, action.getStringRepresentation().charAt(0));
    }

    public int hashCode() {
        return this.getUid().toLowerCase().hashCode();
    }

    private boolean hasPermission(String role, char permision) {
        RoleAssignment r = (RoleAssignment)this.rolesId_d.get(role);
        return r != null && r.permissions != null && r.permissions.indexOf(permision) != -1;
    }

    public static class RoleAssignment
    implements Serializable {
        public int category;
        public String id;
        public int in;
        public String permissions;
        static final long serialVersionUID = 5354744654936741509L;
        static final long serialCheck = 1593536603719803221L;

        public RoleAssignment(String id, int in, String permissions) {
            this.id = id;
            this.permissions = permissions;
            this.in = in;
        }

        public RoleAssignment(String roleId, int roleIn, String permissions, int category) {
            this.id = roleId;
            this.in = roleIn;
            this.permissions = permissions;
            this.category = category;
        }
    }
}

