/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.Activity;
import fuego.papi.InstanceId;
import fuego.papi.InstanceStamp;
import fuego.papi.Process;
import fuego.papi.Task;
import fuego.papi.collections.InstanceActivityPair;
import fuego.papi.exception.InvalidVariableIdException;
import java.io.Serializable;
import java.util.Locale;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Time;

public abstract class InstanceInfo
extends InstanceId
implements Serializable {
    protected String authorId;
    protected Time creationTime_d;
    protected String participantId_d;
    protected String roleId;
    static final long serialVersionUID = 5149285605696478711L;
    static final long serialCheck = -4626226452239617448L;

    @Deprecated
    public abstract Activity getActivity();

    public abstract boolean isActivityCompleted();

    public abstract Time getActivityDeadline();

    public abstract String getActivityId();

    public abstract String getActivityName();

    public abstract int getAuthor();

    public abstract String getAuthorId();

    public abstract boolean isCompleted();

    public abstract Time getDeadline();

    public abstract String getDescription();

    public abstract boolean isException();

    public abstract boolean isExecuting();

    public abstract boolean isGrabbed();

    public abstract String getId();

    @Exclude
    public abstract int getInternalState();

    public abstract int getNumberOfThreads();

    public abstract int getParentThreadIn();

    public abstract String getParticipantId();

    public abstract int getParticipantIn();

    public abstract boolean isPending();

    public abstract int getPendingTaskIn();

    public abstract int getPriority();

    public abstract Time getProcessDeadline();

    public abstract String getProcessId();

    public abstract Time getReceptionTime();

    public abstract String getRoleId();

    public abstract int getRoleIn();

    public abstract boolean isRunning();

    public abstract boolean isSelected();

    public abstract InstanceActivityPair getInstanceActivityPair();

    public abstract int getTaskCount();

    public abstract int getTaskIn(int var1);

    public abstract int getTaskInternalStatus(int var1);

    public abstract String getTaskLastExecutionParticipant(int var1);

    public abstract Time getTaskLastExecutionTime(int var1);

    public abstract String getTaskParticipantId(int var1);

    public abstract int getTaskRetryCounter(int var1);

    public abstract boolean isTaskRunning(int var1);

    public abstract boolean isTaskSelected(int var1);

    public abstract String getTaskStatusDescription(int var1, Locale var2);

    public abstract boolean isTaskValid(int var1);

    public abstract Task[] getTasks();

    @Deprecated
    public abstract Object getVar(String var1, Locale var2);

    public abstract Object getVariable(String var1, Locale var2);

    public abstract Object getExternalVariable(String var1, Locale var2) throws InvalidVariableIdException;

    @Deprecated
    public abstract Object getVar(String var1);

    public abstract Object getVariable(String var1);

    public abstract Object getExternalVariable(String var1) throws InvalidVariableIdException;

    public abstract Object getNormalVariable(String var1) throws InvalidVariableIdException;

    public abstract boolean hasPendingTasks();

    public abstract boolean hasRepeatableTasks();

    public abstract boolean isAborted();

    public abstract int getStatus();

    public abstract String getStatusDescription(Locale var1);

    public abstract boolean isSuspended();

    public abstract Task getTask(int var1);

    public abstract Task getTask(String var1);

    public abstract boolean isTaskCompleted(int var1);

    public abstract void invalidateTask(int var1);

    public static String makeGlobalId(String organization, String processId, int instanceIn, int threadIn) {
        String id = InstanceInfo.makeId(processId, instanceIn, threadIn);
        return id + "@" + organization;
    }

    public static String makeId(String processId, int instanceIn, int threadIn) {
        return InstanceId.makeId(processId, instanceIn, threadIn);
    }

    @Deprecated
    public static InstanceStamp getStamp(String instanceId, String activityName) {
        return new InstanceStamp(instanceId, activityName);
    }

    @Deprecated
    public static InstanceStamp getStamp(String stampId) {
        return new InstanceStamp(stampId);
    }

    public static long getKey(String instanceId) {
        return InstanceInfo.makeKey(InstanceInfo.getInstanceIn(instanceId), InstanceInfo.getThreadIn(instanceId));
    }

    public static long makeKey(int instanceIn, int threadIn) {
        return (long)instanceIn << 32 | (long)threadIn;
    }

    @Deprecated
    public Process getProcess() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    @Deprecated
    public InstanceStamp getStamp() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    @Deprecated
    public InstanceStamp getStampForActivity(String activityName) {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    public Time getCreationTime() {
        return this.creationTime_d;
    }

    public boolean isSelectedBy(String participantId) {
        return this.isSelected() && this.getParticipantId().equalsIgnoreCase(participantId);
    }

    public long getKey() {
        return InstanceInfo.makeKey(this.getInstanceIn(), this.getThreadIn());
    }

    @Override
    public String toString() {
        return this.processIn + ":" + this.instanceIn + ":" + this.threadIn;
    }
}

