/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.EventType;
import fuego.papi.InstanceId;
import java.io.Serializable;
import java.util.Locale;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NonNls;

public class InstanceEvent
implements Serializable,
Comparable {
    public Time activationTime;
    public String activity;
    public String[] bussinesVariablesIds = new String[0];
    public Object[] bussinesVariablesValues;
    public int category;
    public String eventData = "";
    public int id;
    public int instanceIn;
    public String participantId;
    public int participantIn;
    public String processId;
    public int processIn;
    public Time receiveTime;
    public int threadIn;
    public Time timeStamp;
    public int type;
    @NonNls
    public static final String TASK_NUMBER = "ITEMIN";
    @NonNls
    public static final String TASK_NAME = "ITEMID";
    @NonNls
    public static final String TASK_STATE = "STATE";
    @NonNls
    public static final String TASK_EXECUTION_RESULT = "RESULT";
    @NonNls
    public static final String INSTANCE_ACTION = "ACTION";
    @NonNls
    public static final String INSTANCE_DUE = "DUE";
    @NonNls
    public static final String TRANSITION_FROM = "FROM";
    @NonNls
    public static final String TRANSITION_TO = "TO";
    @NonNls
    public static final String TRANSITION_TYPE = "TYPE";
    @NonNls
    public static final String TRANSITION_RULE_ID = "RULE";
    @NonNls
    public static final String EXCEPTION = "EXCEPTION";
    static final long serialVersionUID = 1000303051912000002L;
    static final long serialCheck = -4672429340125150140L;

    public Time getActivationTime() {
        return this.activationTime;
    }

    public String getActivity() {
        return this.activity;
    }

    public String[] getBussinesVariablesIds() {
        return this.bussinesVariablesIds;
    }

    public Object[] getBussinesVariablesValues() {
        return this.bussinesVariablesValues;
    }

    public int getCategory() {
        return this.category;
    }

    public String getEventData() {
        return this.eventData;
    }

    public int getId() {
        return this.id;
    }

    public int getInstanceIn() {
        return this.instanceIn;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public int getParticipantIn() {
        return this.participantIn;
    }

    @Deprecated
    public int getProcessIn() {
        return this.processIn;
    }

    public Time getReceiveTime() {
        return this.receiveTime;
    }

    public int getThreadIn() {
        return this.threadIn;
    }

    public Time getTimeStamp() {
        return this.timeStamp;
    }

    public int getType() {
        return this.type;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getInstanceId() {
        return this.getProcessId() != null ? InstanceId.makeId(this.getProcessId(), this.getInstanceIn(), this.getThreadIn()) : null;
    }

    public final String getDescription(Locale locale) {
        return EventType.getDescription(this.type, locale);
    }

    @NonNls
    public final String toString() {
        return "InstanceEvent [" + this.getInstanceId() + "] Id:" + this.getId() + " Type:" + this.getType() + " TimeStamp:" + this.getTimeStamp() + " Participant:" + this.getParticipantId() + " Activity: " + this.getActivity() + " EventData:" + this.getEventData();
    }

    public String getEventDataValue(String key) {
        if (this.eventData == null) {
            return "";
        }
        String str = this.eventData;
        if (this.isValidKey(key)) {
            int start = str.indexOf(key + "=");
            if (start != -1) {
                int end = str.indexOf(":", start += (key + "=").length());
                return str.substring(start, end);
            }
            return "";
        }
        return this.eventData;
    }

    public int compareTo(Object compareObject) {
        InstanceEvent compare = (InstanceEvent)compareObject;
        int result = this.processIn - compare.processIn;
        if (result == 0 && (result = this.instanceIn - compare.instanceIn) == 0 && (result = this.threadIn - compare.threadIn) == 0) {
            return this.id - compare.id;
        }
        return result;
    }

    private boolean isValidKey(String key) {
        return key != null && (key.equalsIgnoreCase(TASK_NUMBER) || key.equalsIgnoreCase(TASK_STATE) || key.equalsIgnoreCase(TASK_EXECUTION_RESULT) || key.equalsIgnoreCase(TASK_NAME) || key.equalsIgnoreCase(INSTANCE_ACTION) || key.equalsIgnoreCase(INSTANCE_DUE) || key.equalsIgnoreCase(TRANSITION_FROM) || key.equalsIgnoreCase(TRANSITION_TO) || key.equalsIgnoreCase(TRANSITION_TYPE) || key.equalsIgnoreCase(EXCEPTION) || key.equalsIgnoreCase(TRANSITION_RULE_ID));
    }
}

